/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.bigquery;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageClient;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageSettings;
import io.prestosql.plugin.bigquery.BigQueryCredentialsSupplier;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import javax.inject.Inject;

public class BigQueryStorageClientFactory {
    private final Optional<Credentials> credentials;
    private final HeaderProvider headerProvider;

    @Inject
    public BigQueryStorageClientFactory(BigQueryCredentialsSupplier bigQueryCredentialsSupplier, HeaderProvider headerProvider) {
        this.credentials = bigQueryCredentialsSupplier.getCredentials();
        this.headerProvider = headerProvider;
    }

    BigQueryStorageClient createBigQueryStorageClient() {
        try {
            BigQueryStorageSettings.Builder clientSettings = (BigQueryStorageSettings.Builder)BigQueryStorageSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)BigQueryStorageSettings.defaultGrpcTransportProviderBuilder().setHeaderProvider(this.headerProvider).build());
            this.credentials.ifPresent(credentials -> clientSettings.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentials)));
            return BigQueryStorageClient.create((BigQueryStorageSettings)clientSettings.build());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error creating BigQueryStorageClient", e);
        }
    }
}

