/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.bigquery;

import com.google.cloud.bigquery.BigQueryError;
import com.google.cloud.bigquery.BigQueryException;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.Set;

final class BigQueryUtil {
    private static final Set<String> INTERNAL_ERROR_MESSAGES = ImmutableSet.of((Object)"HTTP/2 error code: INTERNAL_ERROR", (Object)"Connection closed with unknown cause", (Object)"Received unexpected EOS on DATA frame from server");
    private static final Set<String> INVALID_COLUMN_NAMES = ImmutableSet.of((Object)"_partitiondate", (Object)"_PARTITIONDATE", (Object)"_partitiontime", (Object)"_PARTITIONTIME");

    private BigQueryUtil() {
    }

    static boolean isRetryable(Throwable cause) {
        return Throwables.getCausalChain((Throwable)cause).stream().anyMatch(BigQueryUtil::isRetryableInternalError);
    }

    static boolean isRetryableInternalError(Throwable t) {
        if (t instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)t;
            return statusRuntimeException.getStatus().getCode() == Status.Code.INTERNAL && INTERNAL_ERROR_MESSAGES.stream().anyMatch(message -> statusRuntimeException.getMessage().contains((CharSequence)message));
        }
        return false;
    }

    static BigQueryException convertToBigQueryException(BigQueryError error) {
        return new BigQueryException(0, error.getMessage(), error);
    }

    public static boolean validColumnName(String columnName) {
        return !INVALID_COLUMN_NAMES.contains(columnName);
    }
}

