/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.bigquery;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.bigquery.BigQueryColumnHandle;
import io.prestosql.plugin.bigquery.BigQueryType;
import io.prestosql.spi.connector.ColumnMetadata;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

final class Conversions {
    private Conversions() {
    }

    static BigQueryColumnHandle toColumnHandle(Field field) {
        FieldList subFields = field.getSubFields();
        List<BigQueryColumnHandle> subColumns = subFields == null ? Collections.emptyList() : subFields.stream().map(Conversions::toColumnHandle).collect(Collectors.toList());
        return new BigQueryColumnHandle(field.getName(), BigQueryType.valueOf(field.getType().name()), Conversions.getMode(field), subColumns, field.getDescription(), false);
    }

    static ColumnMetadata toColumnMetadata(Field field) {
        return ColumnMetadata.builder().setName(field.getName()).setType(Conversions.adapt(field).getPrestoType()).setComment(Optional.ofNullable(field.getDescription())).setNullable(Conversions.getMode(field) == Field.Mode.NULLABLE).build();
    }

    static BigQueryType.Adaptor adapt(final Field field) {
        return new BigQueryType.Adaptor(){

            @Override
            public BigQueryType getBigQueryType() {
                return BigQueryType.valueOf(field.getType().name());
            }

            public ImmutableMap<String, BigQueryType.Adaptor> getBigQuerySubTypes() {
                FieldList subFields = field.getSubFields();
                if (subFields == null) {
                    return ImmutableMap.of();
                }
                return (ImmutableMap)subFields.stream().collect(ImmutableMap.toImmutableMap(Field::getName, Conversions::adapt));
            }

            @Override
            public Field.Mode getMode() {
                return Conversions.getMode(field);
            }
        };
    }

    private static Field.Mode getMode(Field field) {
        return (Field.Mode)MoreObjects.firstNonNull((Object)field.getMode(), (Object)Field.Mode.NULLABLE);
    }
}

