/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.blackhole;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.BucketFunction;
import io.prestosql.spi.connector.ConnectorBucketNodeMap;
import io.prestosql.spi.connector.ConnectorNodePartitioningProvider;
import io.prestosql.spi.connector.ConnectorPartitioningHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;

public class BlackHoleNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final NodeManager nodeManager;

    public BlackHoleNodePartitioningProvider(NodeManager nodeManager) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public ConnectorBucketNodeMap getBucketNodeMap(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return ConnectorBucketNodeMap.createBucketNodeMap((int)this.nodeManager.getRequiredWorkerNodes().size());
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return value -> {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Black hole connector does not supported distributed reads");
        };
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        return (page, position) -> {
            long hash = 13L;
            for (int i = 0; i < partitionChannelTypes.size(); ++i) {
                Type type = (Type)partitionChannelTypes.get(i);
                hash = 31L * hash + type.hash(page.getBlock(i), position);
            }
            return (int)((hash &= Long.MAX_VALUE) % (long)bucketCount);
        };
    }
}

