/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.blackhole;

import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import io.prestosql.plugin.blackhole.BlackHoleInsertTableHandle;
import io.prestosql.plugin.blackhole.BlackHoleOutputTableHandle;
import io.prestosql.plugin.blackhole.BlackHolePageSink;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorPageSink;
import io.prestosql.spi.connector.ConnectorPageSinkProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;

public class BlackHolePageSinkProvider
implements ConnectorPageSinkProvider {
    private final ListeningScheduledExecutorService executorService;

    public BlackHolePageSinkProvider(ListeningScheduledExecutorService executorService) {
        this.executorService = Objects.requireNonNull(executorService, "executorService is null");
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle) {
        BlackHoleOutputTableHandle handle = (BlackHoleOutputTableHandle)outputTableHandle;
        return new BlackHolePageSink(this.executorService, handle.getPageProcessingDelay());
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle) {
        BlackHoleInsertTableHandle handle = (BlackHoleInsertTableHandle)insertTableHandle;
        return new BlackHolePageSink(this.executorService, handle.getPageProcessingDelay());
    }
}

