/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.blackhole;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.BucketFunction;
import io.prestosql.spi.connector.ConnectorBucketNodeMap;
import io.prestosql.spi.connector.ConnectorNodePartitioningProvider;
import io.prestosql.spi.connector.ConnectorPartitioningHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;

public class BlackHoleNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final NodeManager nodeManager;
    private final TypeOperators typeOperators;

    public BlackHoleNodePartitioningProvider(NodeManager nodeManager, TypeOperators typeOperators) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.typeOperators = typeOperators;
    }

    public ConnectorBucketNodeMap getBucketNodeMap(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return ConnectorBucketNodeMap.createBucketNodeMap((int)this.nodeManager.getRequiredWorkerNodes().size());
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return value -> {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Black hole connector does not supported distributed reads");
        };
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        List hashCodeInvokers = (List)partitionChannelTypes.stream().map(type -> this.typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}))).collect(ImmutableList.toImmutableList());
        return (page, position) -> {
            long hash = 13L;
            for (int i = 0; i < partitionChannelTypes.size(); ++i) {
                try {
                    hash = 31L * hash + ((MethodHandle)hashCodeInvokers.get(i)).invokeExact(page.getBlock(i), 0);
                    continue;
                }
                catch (Throwable throwable) {
                    Throwables.throwIfUnchecked((Throwable)throwable);
                    throw new RuntimeException(throwable);
                }
            }
            return (int)((hash &= Long.MAX_VALUE) % (long)bucketCount);
        };
    }
}

