/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.blackhole;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.plugin.blackhole.BlackHoleColumnHandle;
import io.prestosql.plugin.blackhole.BlackHolePageSource;
import io.prestosql.plugin.blackhole.BlackHoleTableHandle;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.FixedWidthType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class BlackHolePageSourceProvider
implements ConnectorPageSourceProvider {
    private final ListeningScheduledExecutorService executorService;

    public BlackHolePageSourceProvider(ListeningScheduledExecutorService executorService) {
        this.executorService = Objects.requireNonNull(executorService, "executorService is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, TupleDomain<ColumnHandle> dynamicFilter) {
        BlackHoleTableHandle table = (BlackHoleTableHandle)tableHandle;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnHandle column : columns) {
            builder.add((Object)((BlackHoleColumnHandle)column).getColumnType());
        }
        ImmutableList types = builder.build();
        Page page = this.generateZeroPage((List<Type>)types, table.getRowsPerPage(), table.getFieldsLength());
        return new BlackHolePageSource(page, table.getPagesPerSplit(), this.executorService, table.getPageProcessingDelay());
    }

    private Page generateZeroPage(List<Type> types, int rowsCount, int fieldLength) {
        byte[] constantBytes = new byte[fieldLength];
        Arrays.fill(constantBytes, (byte)42);
        Slice constantSlice = Slices.wrappedBuffer((byte[])constantBytes);
        Block[] blocks = new Block[types.size()];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.createZeroBlock(types.get(i), rowsCount, constantSlice);
        }
        return new Page(rowsCount, blocks);
    }

    private Block createZeroBlock(Type type, int rowsCount, Slice constantSlice) {
        Preconditions.checkArgument((boolean)BlackHolePageSourceProvider.isSupportedType(type), (String)"Unsupported type [%s]", (Object)type);
        Slice slice = type instanceof VarcharType && !((VarcharType)type).isUnbounded() ? constantSlice.slice(0, Math.min(((VarcharType)type).getBoundedLength(), constantSlice.length())) : (Decimals.isLongDecimal((Type)type) ? Decimals.encodeScaledValue((BigDecimal)BigDecimal.ZERO) : constantSlice);
        BlockBuilder builder = type instanceof FixedWidthType ? type.createBlockBuilder(null, rowsCount) : type.createBlockBuilder(null, rowsCount, slice.length());
        for (int i = 0; i < rowsCount; ++i) {
            Class javaType = type.getJavaType();
            if (javaType == Boolean.TYPE) {
                type.writeBoolean(builder, false);
                continue;
            }
            if (javaType == Long.TYPE) {
                type.writeLong(builder, 0L);
                continue;
            }
            if (javaType == Double.TYPE) {
                type.writeDouble(builder, 0.0);
                continue;
            }
            if (javaType == Slice.class) {
                Objects.requireNonNull(slice, "slice is null");
                type.writeSlice(builder, slice, 0, slice.length());
                continue;
            }
            throw new UnsupportedOperationException("Unknown javaType: " + javaType.getName());
        }
        return builder.build();
    }

    private static boolean isSupportedType(Type type) {
        return BlackHolePageSourceProvider.isNumericType(type) || type instanceof BooleanType || type instanceof DateType || type instanceof TimestampType || type instanceof VarcharType || type instanceof VarbinaryType;
    }

    public static boolean isNumericType(Type type) {
        return type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType || type instanceof BigintType || type instanceof RealType || type instanceof DoubleType || type instanceof DecimalType;
    }
}

