/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.example;

import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.log.Logger;
import io.prestosql.plugin.example.ExampleMetadata;
import io.prestosql.plugin.example.ExampleRecordSetProvider;
import io.prestosql.plugin.example.ExampleSplitManager;
import io.prestosql.plugin.example.ExampleTransactionHandle;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorRecordSetProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.transaction.IsolationLevel;
import java.util.Objects;
import javax.inject.Inject;

public class ExampleConnector
implements Connector {
    private static final Logger log = Logger.get(ExampleConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final ExampleMetadata metadata;
    private final ExampleSplitManager splitManager;
    private final ExampleRecordSetProvider recordSetProvider;

    @Inject
    public ExampleConnector(LifeCycleManager lifeCycleManager, ExampleMetadata metadata, ExampleSplitManager splitManager, ExampleRecordSetProvider recordSetProvider) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        return ExampleTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

