/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.example;

import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.prestosql.plugin.example.ExampleConnector;
import io.prestosql.plugin.example.ExampleHandleResolver;
import io.prestosql.plugin.example.ExampleModule;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import java.util.Map;
import java.util.Objects;

public class ExampleConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "example-http";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new ExampleHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> requiredConfig, ConnectorContext context) {
        Objects.requireNonNull(requiredConfig, "requiredConfig is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new ExampleModule(context.getTypeManager())});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).initialize();
            return (Connector)injector.getInstance(ExampleConnector.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

