/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.example;

import io.prestosql.plugin.example.ExampleClient;
import io.prestosql.plugin.example.ExampleSplit;
import io.prestosql.plugin.example.ExampleTable;
import io.prestosql.plugin.example.ExampleTableHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.FixedSplitSource;
import io.prestosql.spi.connector.TableNotFoundException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.inject.Inject;

public class ExampleSplitManager
implements ConnectorSplitManager {
    private final ExampleClient exampleClient;

    @Inject
    public ExampleSplitManager(ExampleClient exampleClient) {
        this.exampleClient = Objects.requireNonNull(exampleClient, "client is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle connectorTableHandle, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        ExampleTableHandle tableHandle = (ExampleTableHandle)connectorTableHandle;
        ExampleTable table = this.exampleClient.getTable(tableHandle.getSchemaName(), tableHandle.getTableName());
        if (table == null) {
            throw new TableNotFoundException(tableHandle.toSchemaTableName());
        }
        ArrayList<ExampleSplit> splits = new ArrayList<ExampleSplit>();
        for (URI uri : table.getSources()) {
            splits.add(new ExampleSplit(uri));
        }
        Collections.shuffle(splits);
        return new FixedSplitSource(splits);
    }
}

