/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.annotations.Beta;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import io.airlift.units.MinDuration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@Beta
public class HttpClientConfig {
    public static final String JAVAX_NET_SSL_KEY_STORE = "javax.net.ssl.keyStore";
    public static final String JAVAX_NET_SSL_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String JAVAX_NET_SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    public static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private Duration connectTimeout = new Duration(5.0, TimeUnit.SECONDS);
    private Duration requestTimeout = new Duration(5.0, TimeUnit.MINUTES);
    private Duration idleTimeout = new Duration(1.0, TimeUnit.MINUTES);
    private Duration keepAliveInterval;
    private int maxConnections = 200;
    private int maxConnectionsPerServer = 20;
    private int maxRequestsQueuedPerDestination = 1024;
    private DataSize maxContentLength = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize requestBufferSize = new DataSize(4.0, DataSize.Unit.KILOBYTE);
    private DataSize responseBufferSize = new DataSize(16.0, DataSize.Unit.KILOBYTE);
    private HostAndPort socksProxy;
    private String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
    private String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
    private String trustStorePath = System.getProperty("javax.net.ssl.trustStore");
    private String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
    private String secureRandomAlgorithm;
    private List<String> includedCipherSuites = ImmutableList.of();
    private List<String> excludedCipherSuites = ImmutableList.of((Object)"^.*_(MD5|SHA|SHA1)$", (Object)"^TLS_RSA_.*$", (Object)"^SSL_.*$", (Object)"^.*_NULL_.*$", (Object)"^.*_anon_.*$");
    private boolean authenticationEnabled;
    private String kerberosPrincipal;
    private String kerberosRemoteServiceName;
    private int selectorCount = 2;
    private boolean recordRequestComplete = true;
    private boolean connectBlocking;
    private int maxThreads = 200;
    private int minThreads = 8;
    private int timeoutThreads = 1;
    private int timeoutConcurrency = 1;
    private boolean http2Enabled;
    private DataSize http2InitialSessionReceiveWindowSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize http2InitialStreamReceiveWindowSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private DataSize http2InputBufferSize = new DataSize(8.0, DataSize.Unit.KILOBYTE);
    private String logPath = "var/log/";
    private boolean logEnabled;
    private int logHistory = 15;
    private int logQueueSize = 10000;
    private DataSize logMaxFileSize = new DataSize(1.0, DataSize.Unit.GIGABYTE);
    private DataSize logBufferSize = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private Duration logFlushInterval = new Duration(10.0, TimeUnit.SECONDS);
    private boolean logCompressionEnabled = true;

    public boolean isHttp2Enabled() {
        return this.http2Enabled;
    }

    @Config(value="http-client.http2.enabled")
    @ConfigDescription(value="Enable the HTTP/2 transport")
    public HttpClientConfig setHttp2Enabled(boolean http2Enabled) {
        this.http2Enabled = http2Enabled;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Config(value="http-client.connect-timeout")
    public HttpClientConfig setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @Config(value="http-client.request-timeout")
    public HttpClientConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @Config(value="http-client.idle-timeout")
    @LegacyConfig(value={"http-client.read-timeout"})
    public HttpClientConfig setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    @Deprecated
    public Duration getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    @Deprecated
    @Config(value="http-client.keep-alive-interval")
    public HttpClientConfig setKeepAliveInterval(Duration keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
        return this;
    }

    @Min(value=1L)
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Config(value="http-client.max-connections")
    public HttpClientConfig setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    @Min(value=1L)
    public int getMaxConnectionsPerServer() {
        return this.maxConnectionsPerServer;
    }

    @Config(value="http-client.max-connections-per-server")
    public HttpClientConfig setMaxConnectionsPerServer(int maxConnectionsPerServer) {
        this.maxConnectionsPerServer = maxConnectionsPerServer;
        return this;
    }

    @Min(value=1L)
    public int getMaxRequestsQueuedPerDestination() {
        return this.maxRequestsQueuedPerDestination;
    }

    @Config(value="http-client.max-requests-queued-per-destination")
    public HttpClientConfig setMaxRequestsQueuedPerDestination(int maxRequestsQueuedPerDestination) {
        this.maxRequestsQueuedPerDestination = maxRequestsQueuedPerDestination;
        return this;
    }

    @NotNull
    public DataSize getMaxContentLength() {
        return this.maxContentLength;
    }

    @Config(value="http-client.max-content-length")
    public HttpClientConfig setMaxContentLength(DataSize maxContentLength) {
        this.maxContentLength = maxContentLength;
        return this;
    }

    @NotNull
    @MaxDataSize(value="32MB")
    public DataSize getRequestBufferSize() {
        return this.requestBufferSize;
    }

    @Config(value="http-client.request-buffer-size")
    public HttpClientConfig setRequestBufferSize(DataSize requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
        return this;
    }

    @NotNull
    @MaxDataSize(value="32MB")
    public DataSize getResponseBufferSize() {
        return this.responseBufferSize;
    }

    @Config(value="http-client.response-buffer-size")
    public HttpClientConfig setResponseBufferSize(DataSize responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
        return this;
    }

    public HostAndPort getSocksProxy() {
        return this.socksProxy;
    }

    @Config(value="http-client.socks-proxy")
    public HttpClientConfig setSocksProxy(HostAndPort socksProxy) {
        this.socksProxy = socksProxy;
        return this;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Config(value="http-client.key-store-path")
    public HttpClientConfig setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
        return this;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Config(value="http-client.key-store-password")
    public HttpClientConfig setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Config(value="http-client.trust-store-path")
    public HttpClientConfig setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
        return this;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Config(value="http-client.trust-store-password")
    public HttpClientConfig setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    @Config(value="http-client.secure-random-algorithm")
    public HttpClientConfig setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
        return this;
    }

    public List<String> getHttpsIncludedCipherSuites() {
        return this.includedCipherSuites;
    }

    @Config(value="http-client.https.included-cipher")
    public HttpClientConfig setHttpsIncludedCipherSuites(String includedCipherSuites) {
        this.includedCipherSuites = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)Objects.requireNonNull(includedCipherSuites, "includedCipherSuites is null"));
        return this;
    }

    public List<String> getHttpsExcludedCipherSuites() {
        return this.excludedCipherSuites;
    }

    @Config(value="http-client.https.excluded-cipher")
    @ConfigDescription(value="Setting this config property overwrites Jetty's default excluded cipher suites")
    public HttpClientConfig setHttpsExcludedCipherSuites(String excludedCipherSuites) {
        this.excludedCipherSuites = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)Objects.requireNonNull(excludedCipherSuites, "excludedCipherSuites is null"));
        return this;
    }

    public boolean getAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    @Config(value="http-client.authentication.enabled")
    @ConfigDescription(value="Enable client authentication")
    public HttpClientConfig setAuthenticationEnabled(boolean enabled) {
        this.authenticationEnabled = enabled;
        return this;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    @Config(value="http-client.authentication.krb5.principal")
    @ConfigDescription(value="Set kerberos client principal")
    public HttpClientConfig setKerberosPrincipal(String kerberosClientPrincipal) {
        this.kerberosPrincipal = kerberosClientPrincipal;
        return this;
    }

    public String getKerberosRemoteServiceName() {
        return this.kerberosRemoteServiceName;
    }

    @Config(value="http-client.authentication.krb5.remote-service-name")
    @ConfigDescription(value="Set kerberos service principal name")
    public HttpClientConfig setKerberosRemoteServiceName(String serviceName) {
        this.kerberosRemoteServiceName = serviceName;
        return this;
    }

    @NotNull
    @MinDataSize(value="1kB")
    @MaxDataSize(value="1GB")
    public DataSize getHttp2InitialSessionReceiveWindowSize() {
        return this.http2InitialSessionReceiveWindowSize;
    }

    @Config(value="http-client.http2.session-receive-window-size")
    @ConfigDescription(value="Initial size of session's flow control receive window for HTTP/2")
    public HttpClientConfig setHttp2InitialSessionReceiveWindowSize(DataSize http2InitialSessionReceiveWindowSize) {
        this.http2InitialSessionReceiveWindowSize = http2InitialSessionReceiveWindowSize;
        return this;
    }

    @NotNull
    @MinDataSize(value="1kB")
    @MaxDataSize(value="1GB")
    public DataSize getHttp2InitialStreamReceiveWindowSize() {
        return this.http2InitialStreamReceiveWindowSize;
    }

    @Config(value="http-client.http2.stream-receive-window-size")
    @ConfigDescription(value="Initial size of stream's flow control receive window for HTTP/2")
    public HttpClientConfig setHttp2InitialStreamReceiveWindowSize(DataSize http2InitialStreamReceiveWindowSize) {
        this.http2InitialStreamReceiveWindowSize = http2InitialStreamReceiveWindowSize;
        return this;
    }

    @NotNull
    @MinDataSize(value="1kB")
    @MaxDataSize(value="32MB")
    public DataSize getHttp2InputBufferSize() {
        return this.http2InputBufferSize;
    }

    @Config(value="http-client.http2.input-buffer-size")
    @ConfigDescription(value="Size of the buffer used to read from the network for HTTP/2")
    public HttpClientConfig setHttp2InputBufferSize(DataSize http2InputBufferSize) {
        this.http2InputBufferSize = http2InputBufferSize;
        return this;
    }

    @Min(value=1L)
    public int getSelectorCount() {
        return this.selectorCount;
    }

    @Config(value="http-client.selector-count")
    public HttpClientConfig setSelectorCount(int selectorCount) {
        this.selectorCount = selectorCount;
        return this;
    }

    public boolean getRecordRequestComplete() {
        return this.recordRequestComplete;
    }

    @Config(value="http-client.record-request-complete")
    public HttpClientConfig setRecordRequestComplete(boolean recordRequestComplete) {
        this.recordRequestComplete = recordRequestComplete;
        return this;
    }

    public boolean isConnectBlocking() {
        return this.connectBlocking;
    }

    @Config(value="http-client.use-blocking-connect")
    public HttpClientConfig setConnectBlocking(boolean connectBlocking) {
        this.connectBlocking = connectBlocking;
        return this;
    }

    @Min(value=1L)
    public int getMaxThreads() {
        return this.maxThreads;
    }

    @Config(value="http-client.max-threads")
    public HttpClientConfig setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    @Min(value=1L)
    public int getMinThreads() {
        return this.minThreads;
    }

    @Config(value="http-client.min-threads")
    public HttpClientConfig setMinThreads(int minThreads) {
        this.minThreads = minThreads;
        return this;
    }

    @Min(value=1L)
    public int getTimeoutThreads() {
        return this.timeoutThreads;
    }

    @Config(value="http-client.timeout-threads")
    @ConfigDescription(value="Total number of timeout threads")
    public HttpClientConfig setTimeoutThreads(int timeoutThreads) {
        this.timeoutThreads = timeoutThreads;
        return this;
    }

    @Min(value=1L)
    public int getTimeoutConcurrency() {
        return this.timeoutConcurrency;
    }

    @Config(value="http-client.timeout-concurrency")
    @ConfigDescription(value="Number of concurrent locks for timeout")
    public HttpClientConfig setTimeoutConcurrency(int timeoutConcurrency) {
        this.timeoutConcurrency = timeoutConcurrency;
        return this;
    }

    public String getLogPath() {
        return this.logPath;
    }

    @Config(value="http-client.log.path")
    @ConfigDescription(value="The name of the log file will be prefixed with the name of the HTTP client (<client_name>-http-client.log)")
    public HttpClientConfig setLogPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    @Config(value="http-client.log.enabled")
    public HttpClientConfig setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
        return this;
    }

    public DataSize getLogMaxFileSize() {
        return this.logMaxFileSize;
    }

    @Config(value="http-client.log.max-size")
    public HttpClientConfig setLogMaxFileSize(DataSize logMaxFileSize) {
        this.logMaxFileSize = logMaxFileSize;
        return this;
    }

    public int getLogHistory() {
        return this.logHistory;
    }

    @Config(value="http-client.log.max-history")
    public HttpClientConfig setLogHistory(int logHistory) {
        this.logHistory = logHistory;
        return this;
    }

    @Min(value=1L)
    public int getLogQueueSize() {
        return this.logQueueSize;
    }

    @Config(value="http-client.log.queue-size")
    public HttpClientConfig setLogQueueSize(int logQueueSize) {
        this.logQueueSize = logQueueSize;
        return this;
    }

    @NotNull
    @MinDataSize(value="1MB")
    @MaxDataSize(value="1GB")
    public DataSize getLogBufferSize() {
        return this.logBufferSize;
    }

    @Config(value="http-client.log.buffer-size")
    public HttpClientConfig setLogBufferSize(DataSize logBufferSize) {
        this.logBufferSize = logBufferSize;
        return this;
    }

    @NotNull
    public Duration getLogFlushInterval() {
        return this.logFlushInterval;
    }

    @Config(value="http-client.log.flush-interval")
    public HttpClientConfig setLogFlushInterval(Duration logFlushInterval) {
        this.logFlushInterval = logFlushInterval;
        return this;
    }

    public boolean isLogCompressionEnabled() {
        return this.logCompressionEnabled;
    }

    @Config(value="http-client.log.compression.enabled")
    public HttpClientConfig setLogCompressionEnabled(boolean logCompressionEnabled) {
        this.logCompressionEnabled = logCompressionEnabled;
        return this;
    }
}

