/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet;

import com.google.common.base.MoreObjects;
import io.airlift.slice.Slice;
import io.prestosql.parquet.DataPage;
import io.prestosql.parquet.ParquetEncoding;
import java.util.Objects;
import org.apache.parquet.column.statistics.Statistics;

public class DataPageV1
extends DataPage {
    private final Slice slice;
    private final Statistics<?> statistics;
    private final ParquetEncoding repetitionLevelEncoding;
    private final ParquetEncoding definitionLevelEncoding;
    private final ParquetEncoding valuesEncoding;

    public DataPageV1(Slice slice, int valueCount, int uncompressedSize, Statistics<?> statistics, ParquetEncoding repetitionLevelEncoding, ParquetEncoding definitionLevelEncoding, ParquetEncoding valuesEncoding) {
        super(slice.length(), uncompressedSize, valueCount);
        this.slice = Objects.requireNonNull(slice, "slice is null");
        this.statistics = statistics;
        this.repetitionLevelEncoding = repetitionLevelEncoding;
        this.definitionLevelEncoding = definitionLevelEncoding;
        this.valuesEncoding = valuesEncoding;
    }

    public Slice getSlice() {
        return this.slice;
    }

    public Statistics<?> getStatistics() {
        return this.statistics;
    }

    public ParquetEncoding getDefinitionLevelEncoding() {
        return this.definitionLevelEncoding;
    }

    public ParquetEncoding getRepetitionLevelEncoding() {
        return this.repetitionLevelEncoding;
    }

    public ParquetEncoding getValueEncoding() {
        return this.valuesEncoding;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("slice", (Object)this.slice).add("statistics", this.statistics).add("repetitionLevelEncoding", (Object)this.repetitionLevelEncoding).add("definitionLevelEncoding", (Object)this.definitionLevelEncoding).add("valuesEncoding", (Object)this.valuesEncoding).add("valueCount", this.valueCount).add("compressedSize", this.compressedSize).add("uncompressedSize", this.uncompressedSize).toString();
    }
}

