/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.parquet.dictionary;

import io.prestosql.parquet.dictionary.Dictionary;
import java.io.IOException;
import java.io.InputStream;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;

public class DictionaryReader
extends ValuesReader {
    private final Dictionary dictionary;
    private RunLengthBitPackingHybridDecoder decoder;

    public DictionaryReader(Dictionary dictionary) {
        this.dictionary = dictionary;
    }

    public void initFromPage(int valueCount, ByteBufferInputStream in) throws IOException {
        int bitWidth = BytesUtils.readIntLittleEndianOnOneByte((InputStream)in);
        this.decoder = new RunLengthBitPackingHybridDecoder(bitWidth, (InputStream)in);
    }

    public int readValueDictionaryId() {
        return this.readInt();
    }

    public Binary readBytes() {
        return this.dictionary.decodeToBinary(this.readInt());
    }

    public float readFloat() {
        return this.dictionary.decodeToFloat(this.readInt());
    }

    public double readDouble() {
        return this.dictionary.decodeToDouble(this.readInt());
    }

    public int readInteger() {
        return this.dictionary.decodeToInt(this.readInt());
    }

    public long readLong() {
        return this.dictionary.decodeToLong(this.readInt());
    }

    public void skip() {
        this.readInt();
    }

    private int readInt() {
        try {
            return this.decoder.readInt();
        }
        catch (IOException e) {
            throw new ParquetDecodingException((Throwable)e);
        }
    }
}

