/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.rcfile.text;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.prestosql.rcfile.ColumnData;
import io.prestosql.rcfile.EncodeOutput;
import io.prestosql.rcfile.text.TextColumnEncoding;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class DecimalEncoding
implements TextColumnEncoding {
    private final DecimalType type;
    private final Slice nullSequence;
    private final char[] buffer = new char[100];

    public DecimalEncoding(Type type, Slice nullSequence) {
        this.type = (DecimalType)type;
        this.nullSequence = nullSequence;
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                this.encodeValue(block, position, output);
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(int depth, Block block, int position, SliceOutput output) {
        this.encodeValue(block, position, output);
    }

    private void encodeValue(Block block, int position, SliceOutput output) {
        if (Decimals.isShortDecimal((Type)this.type)) {
            output.writeBytes(Slices.utf8Slice((String)Decimals.toString((long)this.type.getLong(block, position), (int)this.type.getScale())));
        } else {
            output.writeBytes(Slices.utf8Slice((String)Decimals.toString((Slice)this.type.getSlice(block, position), (int)this.type.getScale())));
        }
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int offset = columnData.getOffset(i);
            int length = columnData.getLength(i);
            if (length == 0 || this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length)) {
                builder.appendNull();
                continue;
            }
            if (Decimals.isShortDecimal((Type)this.type)) {
                this.type.writeLong(builder, this.parseLong(slice, offset, length));
                continue;
            }
            this.type.writeSlice(builder, this.parseSlice(slice, offset, length));
        }
        return builder.build();
    }

    @Override
    public void decodeValueInto(int depth, BlockBuilder builder, Slice slice, int offset, int length) {
        if (Decimals.isShortDecimal((Type)this.type)) {
            this.type.writeLong(builder, this.parseLong(slice, offset, length));
        } else {
            this.type.writeSlice(builder, this.parseSlice(slice, offset, length));
        }
    }

    private long parseLong(Slice slice, int offset, int length) {
        BigDecimal decimal = this.parseBigDecimal(slice, offset, length);
        return decimal.unscaledValue().longValue();
    }

    private Slice parseSlice(Slice slice, int offset, int length) {
        BigDecimal decimal = this.parseBigDecimal(slice, offset, length);
        return Decimals.encodeUnscaledValue((BigInteger)decimal.unscaledValue());
    }

    private BigDecimal parseBigDecimal(Slice slice, int offset, int length) {
        Preconditions.checkArgument((length < this.buffer.length ? 1 : 0) != 0);
        for (int i = 0; i < length; ++i) {
            this.buffer[i] = (char)slice.getByte(offset + i);
        }
        BigDecimal decimal = new BigDecimal(this.buffer, 0, length);
        Preconditions.checkState((decimal.scale() <= this.type.getScale() ? 1 : 0) != 0, (Object)"Read decimal value scale larger than column scale");
        decimal = decimal.setScale(this.type.getScale(), RoundingMode.HALF_UP);
        Preconditions.checkState((decimal.precision() <= this.type.getPrecision() ? 1 : 0) != 0, (Object)"Read decimal precision larger than column precision");
        return decimal;
    }
}

