/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.api.client.auth.oauth2.Credential;
import com.google.cloud.hadoop.fs.gcs.FileSystemDescriptor;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFSInputStream;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBaseSpecific;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopOutputStream;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopSyncableOutputStream;
import com.google.cloud.hadoop.fs.gcs.InMemoryGlobberFileSystem;
import com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.gcsio.PathCodec;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.util.AccessTokenProviderClassFromConfigFactory;
import com.google.cloud.hadoop.util.CredentialFactory;
import com.google.cloud.hadoop.util.CredentialFromAccessTokenProviderClassFactory;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.cloud.hadoop.util.HadoopVersionInfo;
import com.google.cloud.hadoop.util.PropertyUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.flogger.GoogleLogger;
import com.google.common.flogger.LazyArgs;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.DirectoryNotEmptyException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.GlobPattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;

public abstract class GoogleHadoopFileSystemBase
extends GoogleHadoopFileSystemBaseSpecific
implements FileSystemDescriptor {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String PATH_CODEC_USE_URI_ENCODING = "uri-path";
    public static final String PATH_CODEC_USE_LEGACY_ENCODING = "legacy";
    public static final short REPLICATION_FACTOR_DEFAULT = 3;
    public static final PathFilter DEFAULT_FILTER = path -> true;
    public static final String AUTHENTICATION_PREFIX = "fs.gs";
    public static final String PROPERTIES_FILE = "gcs.properties";
    public static final String VERSION_PROPERTY = "gcs.connector.version";
    public static final String UNKNOWN_VERSION = "0.0.0";
    public static final String VERSION = PropertyUtil.getPropertyOrDefault(GoogleHadoopFileSystemBase.class, (String)"gcs.properties", (String)"gcs.connector.version", (String)"0.0.0");
    public static final String GHFS_ID;
    private boolean enableAutoRepairImplicitDirectories = GoogleHadoopFileSystemConfiguration.GCS_REPAIR_IMPLICIT_DIRECTORIES_ENABLE.getDefault();
    @VisibleForTesting
    boolean enableFlatGlob = GoogleHadoopFileSystemConfiguration.GCS_FLAT_GLOB_ENABLE.getDefault();
    @VisibleForTesting
    boolean enableConcurrentGlob = GoogleHadoopFileSystemConfiguration.GCS_CONCURRENT_GLOB_ENABLE.getDefault();
    private GcsFileChecksumType checksumType = GoogleHadoopFileSystemConfiguration.GCS_FILE_CHECKSUM_TYPE.getDefault();
    protected URI initUri;
    @Deprecated
    protected String systemBucket;
    protected GoogleCloudStorageFileSystem gcsfs;
    private Path workingDirectory;
    protected long defaultBlockSize = GoogleHadoopFileSystemConfiguration.BLOCK_SIZE.getDefault();
    private FsPermission reportedPermissions;
    protected final ImmutableMap<Counter, AtomicLong> counters = this.createCounterMap();
    protected ListStatusFileNotFoundBehavior listStatusFileNotFoundBehavior = ListStatusFileNotFoundBehavior.get();
    private static final ImmutableSet<Counter> ALL_COUNTERS;
    @Deprecated
    public static final String PERMISSIONS_TO_REPORT_KEY;
    @Deprecated
    public static final String PERMISSIONS_TO_REPORT_DEFAULT;
    @Deprecated
    public static final String BUFFERSIZE_KEY;
    @Deprecated
    public static final int BUFFERSIZE_DEFAULT;
    @Deprecated
    public static final String WRITE_BUFFERSIZE_KEY;
    @Deprecated
    public static final int WRITE_BUFFERSIZE_DEFAULT;
    @Deprecated
    public static final String BLOCK_SIZE_KEY;
    @Deprecated
    public static final int BLOCK_SIZE_DEFAULT;
    @Deprecated
    public static final String ENABLE_GCE_SERVICE_ACCOUNT_AUTH_KEY;
    @Deprecated
    public static final String SERVICE_ACCOUNT_AUTH_EMAIL_KEY;
    @Deprecated
    public static final String SERVICE_ACCOUNT_AUTH_KEYFILE_KEY;
    @Deprecated
    public static final String GCS_PROJECT_ID_KEY;
    @Deprecated
    public static final String GCS_REQUESTER_PAYS_MODE_KEY;
    @Deprecated
    public static final String GCS_REQUESTER_PAYS_PROJECT_ID_KEY;
    @Deprecated
    public static final String GCS_REQUESTER_PAYS_BUCKETS_KEY;
    @Deprecated
    public static final String GCS_CLIENT_ID_KEY;
    @Deprecated
    public static final String GCS_CLIENT_SECRET_KEY;
    @Deprecated
    public static final String GCS_SYSTEM_BUCKET_KEY;
    @Deprecated
    public static final String GCS_CREATE_SYSTEM_BUCKET_KEY;
    @Deprecated
    public static final boolean GCS_CREATE_SYSTEM_BUCKET_DEFAULT;
    @Deprecated
    public static final String GCS_WORKING_DIRECTORY_KEY;
    @Deprecated
    public static final String GCS_FILE_SIZE_LIMIT_250GB;
    @Deprecated
    public static final boolean GCS_FILE_SIZE_LIMIT_250GB_DEFAULT;
    @Deprecated
    public static final String GCS_MARKER_FILE_PATTERN_KEY;
    @Deprecated
    public static final String GCS_ENABLE_PERFORMANCE_CACHE_KEY;
    @Deprecated
    public static final boolean GCS_ENABLE_PERFORMANCE_CACHE_DEFAULT;
    @Deprecated
    public static final String GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE_MILLIS_KEY;
    @Deprecated
    public static final long GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE_MILLIS_DEFAULT;
    @Deprecated
    public static final String GCS_PERFORMANCE_CACHE_LIST_CACHING_ENABLE_KEY;
    @Deprecated
    public static final boolean GCS_PERFORMANCE_CACHE_LIST_CACHING_ENABLE_DEFAULT;
    @Deprecated
    public static final String GCS_PERFORMANCE_CACHE_DIR_METADATA_PREFETCH_LIMIT_KEY;
    @Deprecated
    public static final long GCS_PERFORMANCE_CACHE_DIR_METADATA_PREFETCH_LIMIT_DEFAULT;
    @Deprecated
    public static final String GCS_PARENT_TIMESTAMP_UPDATE_ENABLE_KEY;
    @Deprecated
    public static final boolean GCS_PARENT_TIMESTAMP_UPDATE_ENABLE_DEFAULT;
    @Deprecated
    public static final String GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_KEY;
    @Deprecated
    public static final String GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_DEFAULT;
    @Deprecated
    public static final String MR_JOB_HISTORY_INTERMEDIATE_DONE_DIR_KEY = "mapreduce.jobhistory.intermediate-done-dir";
    @Deprecated
    public static final String MR_JOB_HISTORY_DONE_DIR_KEY = "mapreduce.jobhistory.done-dir";
    @Deprecated
    public static final String GCS_PARENT_TIMESTAMP_UPDATE_INCLUDES_KEY;
    @Deprecated
    public static final String GCS_PARENT_TIMESTAMP_UPDATE_INCLUDES_DEFAULT;
    @Deprecated
    public static final String GCS_ENABLE_REPAIR_IMPLICIT_DIRECTORIES_KEY;
    @Deprecated
    public static final boolean GCS_ENABLE_REPAIR_IMPLICIT_DIRECTORIES_DEFAULT;
    @Deprecated
    public static final String PATH_CODEC_KEY;
    @Deprecated
    public static final String PATH_CODEC_DEFAULT;
    @Deprecated
    public static final String GCS_ENABLE_INFER_IMPLICIT_DIRECTORIES_KEY;
    @Deprecated
    public static final boolean GCS_ENABLE_INFER_IMPLICIT_DIRECTORIES_DEFAULT;
    @Deprecated
    public static final String GCS_ENABLE_FLAT_GLOB_KEY;
    @Deprecated
    public static final boolean GCS_ENABLE_FLAT_GLOB_DEFAULT;
    @Deprecated
    public static final String GCS_ENABLE_MARKER_FILE_CREATION_KEY;
    @Deprecated
    public static final boolean GCS_ENABLE_MARKER_FILE_CREATION_DEFAULT;
    @Deprecated
    public static final String GCS_ENABLE_COPY_WITH_REWRITE_KEY;
    @Deprecated
    public static final boolean GCS_ENABLE_COPY_WITH_REWRITE_DEFAULT;
    @Deprecated
    public static final String GCS_COPY_MAX_REQUESTS_PER_BATCH;
    @Deprecated
    public static final long GCS_COPY_MAX_REQUESTS_PER_BATCH_DEFAULT;
    @Deprecated
    public static final String GCS_COPY_BATCH_THREADS;
    @Deprecated
    public static final int GCS_COPY_BATCH_THREADS_DEFAULT;
    @Deprecated
    public static final String GCS_MAX_LIST_ITEMS_PER_CALL;
    @Deprecated
    public static final long GCS_MAX_LIST_ITEMS_PER_CALL_DEFAULT;
    @Deprecated
    public static final String GCS_MAX_REQUESTS_PER_BATCH;
    @Deprecated
    public static final long GCS_MAX_REQUESTS_PER_BATCH_DEFAULT;
    @Deprecated
    public static final String GCS_BATCH_THREADS;
    @Deprecated
    public static final int GCS_BATCH_THREADS_DEFAULT;
    @Deprecated
    public static final String GCS_HTTP_MAX_RETRY_KEY;
    @Deprecated
    public static final int GCS_HTTP_MAX_RETRY_DEFAULT;
    @Deprecated
    public static final String GCS_HTTP_CONNECT_TIMEOUT_KEY;
    @Deprecated
    public static final int GCS_HTTP_CONNECT_TIMEOUT_DEFAULT;
    @Deprecated
    public static final String GCS_HTTP_READ_TIMEOUT_KEY;
    @Deprecated
    public static final int GCS_HTTP_READ_TIMEOUT_DEFAULT;
    @Deprecated
    public static final String GCS_PROXY_ADDRESS_KEY;
    @Deprecated
    public static final String GCS_PROXY_ADDRESS_DEFAULT;
    @Deprecated
    public static final String GCS_HTTP_TRANSPORT_KEY;
    @Deprecated
    public static final String GCS_HTTP_TRANSPORT_DEFAULT;
    @Deprecated
    public static final String GCS_APPLICATION_NAME_SUFFIX_KEY;
    @Deprecated
    public static final String GCS_APPLICATION_NAME_SUFFIX_DEFAULT;
    @Deprecated
    public static final String GCS_MAX_WAIT_MILLIS_EMPTY_OBJECT_CREATE_KEY;
    @Deprecated
    public static final int GCS_MAX_WAIT_MILLIS_EMPTY_OBJECT_CREATE_DEFAULT;
    @Deprecated
    public static final String GCS_OUTPUTSTREAM_TYPE_KEY;
    @Deprecated
    public static final String GCS_OUTPUTSTREAM_TYPE_DEFAULT;
    @Deprecated
    public static final String GCS_GENERATION_READ_CONSISTENCY_KEY;
    @Deprecated
    public static final GoogleCloudStorageReadOptions.GenerationReadConsistency GCS_GENERATION_READ_CONSISTENCY_DEFAULT;
    @Deprecated
    public static final String GCS_INPUTSTREAM_FAST_FAIL_ON_NOT_FOUND_ENABLE_KEY;
    @Deprecated
    public static final boolean GCS_INPUTSTREAM_FAST_FAIL_ON_NOT_FOUND_ENABLE_DEFAULT;
    @Deprecated
    public static final String GCS_INPUTSTREAM_INPLACE_SEEK_LIMIT_KEY;
    @Deprecated
    public static final long GCS_INPUTSTREAM_INPLACE_SEEK_LIMIT_DEFAULT;
    @Deprecated
    public static final String GCS_INPUTSTREAM_FADVISE_KEY;
    @Deprecated
    public static final GoogleCloudStorageReadOptions.Fadvise GCS_INPUTSTREAM_FADVISE_DEFAULT;
    @Deprecated
    public static final String GCS_INPUTSTREAM_MIN_RANGE_REQUEST_SIZE_KEY;
    @Deprecated
    public static final int GCS_INPUTSTREAM_MIN_RANGE_REQUEST_SIZE_DEFAULT;
    @Deprecated
    public static final String GCE_BUCKET_DELETE_ENABLE_KEY;
    @Deprecated
    public static final boolean GCE_BUCKET_DELETE_ENABLE_DEFAULT;

    protected ImmutableMap<Counter, AtomicLong> createCounterMap() {
        EnumMap<Counter, AtomicLong> countersMap = new EnumMap<Counter, AtomicLong>(Counter.class);
        for (Counter counter : ALL_COUNTERS) {
            countersMap.put(counter, new AtomicLong());
        }
        return Maps.immutableEnumMap(countersMap);
    }

    @VisibleForTesting
    protected void setListStatusFileNotFoundBehavior(ListStatusFileNotFoundBehavior behavior) {
        this.listStatusFileNotFoundBehavior = behavior;
    }

    public GoogleHadoopFileSystemBase() {
    }

    public GoogleHadoopFileSystemBase(GoogleCloudStorageFileSystem gcsfs) {
        Preconditions.checkArgument((gcsfs != null ? 1 : 0) != 0, (Object)"gcsfs must not be null");
        this.gcsfs = gcsfs;
    }

    protected abstract String getHomeDirectorySubpath();

    public abstract Path getHadoopPath(URI var1);

    @Override
    public abstract URI getGcsPath(Path var1);

    public abstract Path getDefaultWorkingDirectory();

    @Override
    public abstract Path getFileSystemRoot();

    @Override
    public abstract String getScheme();

    @Override
    @Deprecated
    public String getHadoopScheme() {
        return this.getScheme();
    }

    public Path makeQualified(Path path) {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.makeQualified: path: %s", (Object)path);
        Path qualifiedPath = super.makeQualified(path);
        URI uri = qualifiedPath.toUri();
        Preconditions.checkState(("".equals(uri.getPath()) || qualifiedPath.isAbsolute() ? 1 : 0) != 0, (String)"Path '%s' must be fully qualified.", (Object)qualifiedPath);
        StringBuilder sb = new StringBuilder(uri.getPath());
        while (sb.indexOf("/../") == 0) {
            sb.delete(0, 3);
        }
        String strippedPath = sb.toString();
        if (strippedPath.equals("/..") || strippedPath.equals("")) {
            strippedPath = "/";
        }
        Path result = new Path(uri.getScheme(), uri.getAuthority(), strippedPath);
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.makeQualified:=> %s", (Object)result);
        return result;
    }

    protected void checkPath(Path path) {
        URI uri = path.toUri();
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equalsIgnoreCase(this.getScheme())) {
            return;
        }
        String msg = String.format("Wrong FS scheme: %s, in path: %s, expected scheme: %s", scheme, path, this.getScheme());
        throw new IllegalArgumentException(msg);
    }

    public void initialize(URI path, Configuration config) throws IOException {
        this.initialize(path, config, true);
    }

    public void initialize(URI path, Configuration config, boolean initSuperclass) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path must not be null");
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config must not be null");
        Preconditions.checkArgument((path.getScheme() != null ? 1 : 0) != 0, (Object)"scheme of path must not be null");
        if (!path.getScheme().equals(this.getScheme())) {
            throw new IllegalArgumentException("URI scheme not supported: " + path);
        }
        this.initUri = path;
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.initialize: %s", (Object)path);
        if (initSuperclass) {
            super.initialize(path, config);
        } else {
            ((GoogleLogger.Api)logger.atFine()).log("Initializing 'statistics' as an instance not attached to the static FileSystem map");
            this.statistics = new FileSystem.Statistics(this.getScheme());
        }
        this.configure(config);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.INIT);
        this.increment(Counter.INIT_TIME, duration);
    }

    public URI getUri() {
        return this.getFileSystemRoot().toUri();
    }

    protected int getDefaultPort() {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getDefaultPort:");
        int result = -1;
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getDefaultPort:=> %s", result);
        return result;
    }

    public FSDataInputStream open(Path hadoopPath, int bufferSize) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        this.checkOpen();
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.open: %s, bufferSize: %d (ignored)", (Object)hadoopPath, bufferSize);
        URI gcsPath = this.getGcsPath(hadoopPath);
        GoogleCloudStorageReadOptions readChannelOptions = this.getGcsFs().getOptions().getCloudStorageOptions().getReadChannelOptions();
        GoogleHadoopFSInputStream in = new GoogleHadoopFSInputStream(this, gcsPath, readChannelOptions, this.statistics);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.OPEN);
        this.increment(Counter.OPEN_TIME, duration);
        return new FSDataInputStream((InputStream)((Object)in));
    }

    public FSDataOutputStream create(Path hadoopPath, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        OutputStream out;
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        Preconditions.checkArgument((replication > 0 ? 1 : 0) != 0, (String)"replication must be a positive integer: %s", (int)replication);
        Preconditions.checkArgument((blockSize > 0L ? 1 : 0) != 0, (String)"blockSize must be a positive integer: %s", (long)blockSize);
        this.checkOpen();
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.create: %s, overwrite: %s, bufferSize: %d (ignored)", (Object)hadoopPath, (Object)overwrite, (Object)bufferSize);
        URI gcsPath = this.getGcsPath(hadoopPath);
        OutputStreamType type = GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_TYPE.get(this.getConf(), (arg_0, arg_1) -> ((Configuration)this.getConf()).getEnum(arg_0, arg_1));
        switch (type) {
            case BASIC: {
                out = new GoogleHadoopOutputStream(this, gcsPath, this.statistics, new CreateFileOptions(overwrite));
                break;
            }
            case SYNCABLE_COMPOSITE: {
                out = new GoogleHadoopSyncableOutputStream(this, gcsPath, this.statistics, new CreateFileOptions(overwrite));
                break;
            }
            default: {
                throw new IOException(String.format("Unsupported output stream type given for key '%s': '%s'", new Object[]{GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_TYPE.getKey(), type}));
            }
        }
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.CREATE);
        this.increment(Counter.CREATE_TIME, duration);
        return new FSDataOutputStream(out, null);
    }

    public FSDataOutputStream append(Path hadoopPath, int bufferSize, Progressable progress) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.append: %s, bufferSize: %d (ignored)", (Object)hadoopPath, bufferSize);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.APPEND);
        this.increment(Counter.APPEND_TIME, duration);
        throw new IOException("The append operation is not supported.");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        if (src.makeQualified((FileSystem)this).equals((Object)this.getFileSystemRoot())) {
            ((GoogleLogger.Api)logger.atFine()).log("GHFS.rename: src is root: '%s'", (Object)src);
            return false;
        }
        long startTime = System.nanoTime();
        Preconditions.checkArgument((src != null ? 1 : 0) != 0, (Object)"src must not be null");
        Preconditions.checkArgument((dst != null ? 1 : 0) != 0, (Object)"dst must not be null");
        this.checkOpen();
        try {
            ((GoogleLogger.Api)logger.atFine()).log("GHFS.rename: %s -> %s", (Object)src, (Object)dst);
            URI srcPath = this.getGcsPath(src);
            URI dstPath = this.getGcsPath(dst);
            this.gcsfs.rename(srcPath, dstPath);
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause((Throwable)e)).log("GHFS.rename");
            return false;
        }
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.RENAME);
        this.increment(Counter.RENAME_TIME, duration);
        return true;
    }

    @Deprecated
    public boolean delete(Path f) throws IOException {
        return this.delete(f, true);
    }

    public boolean delete(Path hadoopPath, boolean recursive) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        this.checkOpen();
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.delete: %s, recursive: %s", (Object)hadoopPath, recursive);
        URI gcsPath = this.getGcsPath(hadoopPath);
        try {
            this.gcsfs.delete(gcsPath, recursive);
        }
        catch (DirectoryNotEmptyException e) {
            throw e;
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause((Throwable)e)).log("GHFS.delete");
            return false;
        }
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.DELETE);
        this.increment(Counter.DELETE_TIME, duration);
        return true;
    }

    public FileStatus[] listStatus(Path hadoopPath) throws IOException {
        ArrayList<FileStatus> status;
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        this.checkOpen();
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.listStatus: %s", (Object)hadoopPath);
        URI gcsPath = this.getGcsPath(hadoopPath);
        try {
            List fileInfos = this.gcsfs.listFileInfo(gcsPath, this.enableAutoRepairImplicitDirectories);
            status = new ArrayList<FileStatus>(fileInfos.size());
            String userName = GoogleHadoopFileSystemBase.getUgiUserName();
            for (FileInfo fileInfo : fileInfos) {
                status.add(this.getFileStatus(fileInfo, userName));
            }
        }
        catch (FileNotFoundException fnfe) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFine()).withCause((Throwable)fnfe)).log("Got fnfe: ");
            return this.listStatusFileNotFoundBehavior.handle(gcsPath.toString());
        }
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.LIST_STATUS);
        this.increment(Counter.LIST_STATUS_TIME, duration);
        return status.toArray(new FileStatus[0]);
    }

    public void setWorkingDirectory(Path hadoopPath) {
        Path newPath;
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.setWorkingDirectory: %s", (Object)hadoopPath);
        URI gcsPath = this.getGcsPath(hadoopPath);
        gcsPath = FileInfo.convertToDirectoryPath((PathCodec)this.gcsfs.getPathCodec(), (URI)gcsPath);
        this.workingDirectory = newPath = this.getHadoopPath(gcsPath);
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.setWorkingDirectory: => %s", (Object)this.workingDirectory);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.SET_WD);
        this.increment(Counter.SET_WD_TIME, duration);
    }

    public Path getWorkingDirectory() {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getWorkingDirectory: %s", (Object)this.workingDirectory);
        return this.workingDirectory;
    }

    public boolean mkdirs(Path hadoopPath, FsPermission permission) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        this.checkOpen();
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.mkdirs: %s, perm: %s", (Object)hadoopPath, (Object)permission);
        URI gcsPath = this.getGcsPath(hadoopPath);
        try {
            this.gcsfs.mkdirs(gcsPath);
        }
        catch (java.nio.file.FileAlreadyExistsException faee) {
            throw (FileAlreadyExistsException)new FileAlreadyExistsException(faee.getMessage()).initCause((Throwable)faee);
        }
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.MKDIRS);
        this.increment(Counter.MKDIRS_TIME, duration);
        return true;
    }

    public short getDefaultReplication() {
        return 3;
    }

    public FileStatus getFileStatus(Path hadoopPath) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        this.checkOpen();
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getFileStatus: %s", (Object)hadoopPath);
        URI gcsPath = this.getGcsPath(hadoopPath);
        FileInfo fileInfo = this.gcsfs.getFileInfo(gcsPath);
        if (!fileInfo.exists()) {
            ((GoogleLogger.Api)logger.atFine()).log("GHFS.getFileStatus: not found: %s", (Object)gcsPath);
            throw new FileNotFoundException((fileInfo.isDirectory() ? "Directory not found : " : "File not found : ") + hadoopPath);
        }
        String userName = GoogleHadoopFileSystemBase.getUgiUserName();
        FileStatus status = this.getFileStatus(fileInfo, userName);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.GET_FILE_STATUS);
        this.increment(Counter.GET_FILE_STATUS_TIME, duration);
        return status;
    }

    private FileStatus getFileStatus(FileInfo fileInfo, String userName) throws IOException {
        FileStatus status = new FileStatus(fileInfo.getSize(), fileInfo.isDirectory(), 3, this.defaultBlockSize, fileInfo.getModificationTime(), fileInfo.getModificationTime(), this.reportedPermissions, userName, userName, this.getHadoopPath(fileInfo.getPath()));
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getFileStatus: %s => %s", (Object)fileInfo.getPath(), (Object)LazyArgs.lazy(() -> GoogleHadoopFileSystemBase.fileStatusToString(status)));
        return status;
    }

    @VisibleForTesting
    boolean couldUseFlatGlob(Path fixedPath) {
        if (!this.getUri().getScheme().equals("gs")) {
            ((GoogleLogger.Api)logger.atFine()).log("Flat glob is on, but doesn't work for scheme '%s'; using default behavior.", (Object)this.getUri().getScheme());
            return false;
        }
        GlobPattern fullPattern = new GlobPattern(fixedPath.toString());
        if (!fullPattern.hasWildcard()) {
            ((GoogleLogger.Api)logger.atFine()).log("Flat glob is on, but Path '%s' has no wildcard; using default behavior.", (Object)fixedPath);
            return false;
        }
        if (Strings.isNullOrEmpty((String)fixedPath.toUri().getAuthority())) {
            ((GoogleLogger.Api)logger.atInfo()).log("Flat glob is on, but Path '%s' has a empty authority, using default behavior.", (Object)fixedPath);
            return false;
        }
        GlobPattern authorityPattern = new GlobPattern(fixedPath.toUri().getAuthority());
        if (authorityPattern.hasWildcard()) {
            ((GoogleLogger.Api)logger.atInfo()).log("Flat glob is on, but Path '%s' has a wildcard authority, using default behavior.", (Object)fixedPath);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    String trimToPrefixWithoutGlob(String path) {
        char[] wildcardChars = "*?{[".toCharArray();
        int trimIndex = path.length();
        for (char wildcard : wildcardChars) {
            int wildcardIndex = path.indexOf(wildcard);
            if (wildcardIndex < 0 || wildcardIndex >= trimIndex) continue;
            trimIndex = wildcardIndex;
        }
        return path.substring(0, trimIndex);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return this.globStatus(pathPattern, DEFAULT_FILTER);
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        this.checkOpen();
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.globStatus: %s", (Object)pathPattern);
        Path encodedPath = new Path(pathPattern.toUri().toString());
        Path encodedFixedPath = this.getHadoopPath(this.getGcsPath(encodedPath));
        Path fixedPath = new Path(URI.create(encodedFixedPath.toString()));
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.globStatus fixedPath: %s => %s", (Object)pathPattern, (Object)fixedPath);
        if (this.enableConcurrentGlob && this.couldUseFlatGlob(fixedPath)) {
            return this.concurrentGlobInternal(fixedPath, filter, pathPattern);
        }
        if (this.enableFlatGlob && this.couldUseFlatGlob(fixedPath)) {
            return this.flatGlobInternal(fixedPath, filter);
        }
        return this.globInternal(fixedPath, filter, pathPattern);
    }

    private FileStatus[] concurrentGlobInternal(Path fixedPath, PathFilter filter, Path pathPattern) throws IOException {
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Callable<FileStatus[]> flatGlobTask = () -> this.flatGlobInternal(fixedPath, filter);
        Callable<FileStatus[]> nonFlatGlobTask = () -> this.globInternal(fixedPath, filter, pathPattern);
        try {
            FileStatus[] fileStatusArray = (FileStatus[])executorService.invokeAny(Arrays.asList(flatGlobTask, nonFlatGlobTask));
            return fileStatusArray;
        }
        catch (InterruptedException | ExecutionException e) {
            throw e.getCause() instanceof IOException ? (IOException)e.getCause() : new IOException(e);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private FileStatus[] flatGlobInternal(Path fixedPath, PathFilter filter) throws IOException {
        GoogleCloudStorage.ListPage infoPage;
        String pathString = fixedPath.toString();
        String prefixString = this.trimToPrefixWithoutGlob(pathString);
        Path prefixPath = new Path(prefixString);
        URI prefixUri = this.getGcsPath(prefixPath);
        if (prefixString.endsWith("/") && !prefixPath.toString().endsWith("/")) {
            prefixUri = FileInfo.convertToDirectoryPath((PathCodec)this.gcsfs.getPathCodec(), (URI)prefixUri);
        }
        ((GoogleLogger.Api)logger.atFine()).log("Listing everything with prefix '%s'", (Object)prefixUri);
        ArrayList<FileStatus> matchedStatuses = null;
        String pageToken = null;
        do {
            infoPage = this.gcsfs.listAllFileInfoForPrefixPage(prefixUri, pageToken);
            Collection<FileStatus> statusPage = this.toFileStatusesWithImplicitDirectories(infoPage.getItems());
            FileSystem helperFileSystem = InMemoryGlobberFileSystem.createInstance(this.getConf(), this.getWorkingDirectory(), statusPage);
            FileStatus[] matchedStatusPage = helperFileSystem.globStatus(fixedPath, filter);
            if (matchedStatusPage == null) continue;
            Collections.addAll(matchedStatuses == null ? new ArrayList<FileStatus>() : matchedStatuses, matchedStatusPage);
        } while ((pageToken = infoPage.getNextPageToken()) != null);
        if (matchedStatuses == null || matchedStatuses.isEmpty()) {
            return matchedStatuses == null ? null : new FileStatus[]{};
        }
        matchedStatuses.sort(Comparator.naturalOrder().thenComparingInt(f -> GoogleHadoopFileSystemBase.isImplicitDirectory(f) ? 1 : 0));
        ArrayList<FileStatus> filteredStatuses = new ArrayList<FileStatus>(matchedStatuses.size());
        FileStatus lastAdded = null;
        for (FileStatus fileStatus : matchedStatuses) {
            if (lastAdded != null && lastAdded.compareTo(fileStatus) == 0) continue;
            filteredStatuses.add(fileStatus);
            lastAdded = fileStatus;
        }
        FileStatus[] returnList = filteredStatuses.toArray(new FileStatus[0]);
        if (this.enableAutoRepairImplicitDirectories) {
            ArrayList<URI> toRepair = new ArrayList<URI>();
            for (FileStatus status : returnList) {
                if (!GoogleHadoopFileSystemBase.isImplicitDirectory(status)) continue;
                toRepair.add(this.getGcsPath(status.getPath()));
            }
            if (!toRepair.isEmpty()) {
                ((GoogleLogger.Api)logger.atWarning()).log("Discovered %s implicit directories to repair within return values.", toRepair.size());
                this.gcsfs.repairDirs(toRepair);
            }
        }
        return returnList;
    }

    private FileStatus[] globInternal(Path fixedPath, PathFilter filter, Path pathPattern) throws IOException {
        FileStatus[] ret = super.globStatus(fixedPath, filter);
        if (ret == null && this.enableAutoRepairImplicitDirectories) {
            ((GoogleLogger.Api)logger.atFine()).log("GHFS.globStatus returned null for '%s', attempting possible repair.", (Object)pathPattern);
            if (this.gcsfs.repairPossibleImplicitDirectory(this.getGcsPath(fixedPath))) {
                ((GoogleLogger.Api)logger.atWarning()).log("Success repairing '%s', re-globbing.", (Object)pathPattern);
                ret = super.globStatus(fixedPath, filter);
            }
        }
        return ret;
    }

    private static boolean isImplicitDirectory(FileStatus curr) {
        return curr.isDir() && curr.getModificationTime() == 0L;
    }

    private Collection<FileStatus> toFileStatusesWithImplicitDirectories(Collection<FileInfo> fileInfos) throws IOException {
        ArrayList<FileStatus> fileStatuses = new ArrayList<FileStatus>(fileInfos.size());
        HashSet filePaths = Sets.newHashSetWithExpectedSize((int)fileInfos.size());
        String userName = GoogleHadoopFileSystemBase.getUgiUserName();
        for (FileInfo fileInfo : fileInfos) {
            filePaths.add(fileInfo.getPath());
            fileStatuses.add(this.getFileStatus(fileInfo, userName));
        }
        for (FileInfo fileInfo : fileInfos) {
            URI parentPath = this.gcsfs.getParentPath(fileInfo.getPath());
            while (parentPath != null && !parentPath.equals(GoogleCloudStorageFileSystem.GCS_ROOT)) {
                if (!filePaths.contains(parentPath)) {
                    ((GoogleLogger.Api)logger.atFine()).log("Adding fake entry for missing parent path '%s'", (Object)parentPath);
                    StorageResourceId id = this.gcsfs.getPathCodec().validatePathAndGetId(parentPath, true);
                    GoogleCloudStorageItemInfo fakeItemInfo = GoogleCloudStorageItemInfo.createInferredDirectory((StorageResourceId)id);
                    FileInfo fakeFileInfo = FileInfo.fromItemInfo((PathCodec)this.gcsfs.getPathCodec(), (GoogleCloudStorageItemInfo)fakeItemInfo);
                    filePaths.add(parentPath);
                    fileStatuses.add(this.getFileStatus(fakeFileInfo, userName));
                }
                parentPath = this.gcsfs.getParentPath(parentPath);
            }
        }
        return fileStatuses;
    }

    private static String getUgiUserName() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        return ugi.getShortUserName();
    }

    public Path getHomeDirectory() {
        Path result = new Path(this.getFileSystemRoot(), this.getHomeDirectorySubpath());
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getHomeDirectory:=> %s", (Object)result);
        return result;
    }

    private static String fileStatusToString(FileStatus stat) {
        assert (stat != null);
        return String.format("path: %s, isDir: %s, len: %d, owner: %s", stat.getPath().toString(), stat.isDir(), stat.getLen(), stat.getOwner());
    }

    @Deprecated
    @VisibleForTesting
    String getSystemBucketName() {
        return this.systemBucket;
    }

    public String getCanonicalServiceName() {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getCanonicalServiceName:");
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getCanonicalServiceName:=> null");
        return null;
    }

    @Override
    public GoogleCloudStorageFileSystem getGcsFs() {
        return this.gcsfs;
    }

    void increment(Counter key) {
        this.increment(key, 1L);
    }

    void increment(Counter key, long value) {
        ((AtomicLong)this.counters.get((Object)key)).addAndGet(value);
    }

    @VisibleForTesting
    String countersToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        double numNanoSecPerSec = TimeUnit.SECONDS.toNanos(1L);
        String timeSuffix = "_TIME";
        for (Counter c : Counter.values()) {
            String name = c.toString();
            if (name.endsWith(timeSuffix)) continue;
            long count = ((AtomicLong)this.counters.get((Object)c)).get();
            sb.append(String.format("%20s = %d calls\n", name, count));
            String timeCounterName = name + timeSuffix;
            double totalTime = (double)((AtomicLong)this.counters.get((Object)Enum.valueOf(Counter.class, timeCounterName))).get() / numNanoSecPerSec;
            sb.append(String.format("%20s = %.2f sec\n", timeCounterName, totalTime));
            String avgName = name + " avg.";
            double avg = totalTime / (double)count;
            sb.append(String.format("%20s = %.2f sec / call\n\n", avgName, avg));
        }
        return sb.toString();
    }

    private void logCounters() {
        ((GoogleLogger.Api)logger.atFine()).log("%s", (Object)LazyArgs.lazy(this::countersToString));
    }

    private static void copyIfNotPresent(Configuration config, String deprecatedKey, String newKey) {
        String deprecatedValue = config.get(deprecatedKey);
        if (config.get(newKey) == null && deprecatedValue != null) {
            ((GoogleLogger.Api)logger.atWarning()).log("Key %s is deprecated. Copying the value of key %s to new key %s", (Object)deprecatedKey, (Object)deprecatedKey, (Object)newKey);
            config.set(newKey, deprecatedValue);
        }
    }

    private static void copyDeprecatedConfigurationOptions(Configuration config) {
        GoogleHadoopFileSystemBase.copyIfNotPresent(config, GoogleHadoopFileSystemConfiguration.AUTH_SERVICE_ACCOUNT_ENABLE.getKey(), "fs.gs.auth.service.account.enable");
        GoogleHadoopFileSystemBase.copyIfNotPresent(config, GoogleHadoopFileSystemConfiguration.AUTH_SERVICE_ACCOUNT_KEY_FILE.getKey(), "fs.gs.auth.service.account.keyfile");
        GoogleHadoopFileSystemBase.copyIfNotPresent(config, GoogleHadoopFileSystemConfiguration.AUTH_SERVICE_ACCOUNT_EMAIL.getKey(), "fs.gs.auth.service.account.email");
        GoogleHadoopFileSystemBase.copyIfNotPresent(config, GoogleHadoopFileSystemConfiguration.AUTH_CLIENT_ID.getKey(), "fs.gs.auth.client.id");
        GoogleHadoopFileSystemBase.copyIfNotPresent(config, GoogleHadoopFileSystemConfiguration.AUTH_CLIENT_SECRET.getKey(), "fs.gs.auth.client.secret");
        String oauthClientFileKey = "fs.gs.auth.client.file";
        if (config.get(oauthClientFileKey) == null) {
            config.set(oauthClientFileKey, System.getProperty("user.home") + "/.credentials/storage.json");
        }
    }

    private Credential getCredential(AccessTokenProviderClassFromConfigFactory providerClassFactory, Configuration config) throws IOException, GeneralSecurityException {
        Credential credential = CredentialFromAccessTokenProviderClassFactory.credential((AccessTokenProviderClassFromConfigFactory)providerClassFactory, (Configuration)config, (Collection)CredentialFactory.GCS_SCOPES);
        if (credential != null) {
            return credential;
        }
        return ((HadoopCredentialConfiguration)((HadoopCredentialConfiguration.Builder)HadoopCredentialConfiguration.newBuilder().withConfiguration(config).withOverridePrefix(AUTHENTICATION_PREFIX)).build()).getCredential((List)CredentialFactory.GCS_SCOPES);
    }

    private synchronized void configure(Configuration config) throws IOException {
        Path newWorkingDirectory;
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.configure");
        ((GoogleLogger.Api)logger.atFine()).log("GHFS_ID = %s", (Object)GHFS_ID);
        this.overrideConfigFromFile(config);
        if (this.gcsfs == null) {
            PathCodec pathCodec;
            String specifiedPathCodec;
            Credential credential;
            GoogleHadoopFileSystemBase.copyDeprecatedConfigurationOptions(config);
            try {
                credential = this.getCredential(new AccessTokenProviderClassFromConfigFactory().withOverridePrefix(AUTHENTICATION_PREFIX), config);
            }
            catch (GeneralSecurityException gse) {
                throw new IOException(gse);
            }
            this.enableFlatGlob = GoogleHadoopFileSystemConfiguration.GCS_FLAT_GLOB_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1));
            this.enableConcurrentGlob = GoogleHadoopFileSystemConfiguration.GCS_CONCURRENT_GLOB_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1));
            this.checksumType = GoogleHadoopFileSystemConfiguration.GCS_FILE_CHECKSUM_TYPE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1));
            GoogleCloudStorageFileSystemOptions.Builder optionsBuilder = GoogleHadoopFileSystemConfiguration.getGcsFsOptionsBuilder(config);
            switch (specifiedPathCodec = GoogleHadoopFileSystemConfiguration.PATH_CODEC.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1)).toLowerCase()) {
                case "legacy": {
                    pathCodec = GoogleCloudStorageFileSystem.LEGACY_PATH_CODEC;
                    break;
                }
                case "uri-path": {
                    pathCodec = GoogleCloudStorageFileSystem.URI_ENCODED_PATH_CODEC;
                    break;
                }
                default: {
                    pathCodec = GoogleCloudStorageFileSystem.LEGACY_PATH_CODEC;
                    ((GoogleLogger.Api)logger.atWarning()).log("Unknown path codec specified %s. Using default / legacy.", (Object)specifiedPathCodec);
                }
            }
            optionsBuilder.setPathCodec(pathCodec);
            GoogleCloudStorageFileSystemOptions options = optionsBuilder.build();
            this.enableAutoRepairImplicitDirectories = options.getCloudStorageOptions().isAutoRepairImplicitDirectoriesEnabled();
            this.gcsfs = new GoogleCloudStorageFileSystem(credential, options);
        }
        this.defaultBlockSize = GoogleHadoopFileSystemConfiguration.BLOCK_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1));
        this.reportedPermissions = new FsPermission(GoogleHadoopFileSystemConfiguration.PERMISSIONS_TO_REPORT.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1)));
        String systemBucketName = GoogleHadoopFileSystemConfiguration.GCS_SYSTEM_BUCKET.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
        boolean createSystemBucket = GoogleHadoopFileSystemConfiguration.GCS_CREATE_SYSTEM_BUCKET.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1));
        this.configureBuckets(systemBucketName, createSystemBucket);
        this.workingDirectory = this.getFileSystemRoot();
        String configWorkingDirectory = GoogleHadoopFileSystemConfiguration.GCS_WORKING_DIRECTORY.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
        if (Strings.isNullOrEmpty((String)configWorkingDirectory)) {
            newWorkingDirectory = this.getDefaultWorkingDirectory();
            ((GoogleLogger.Api)logger.atWarning()).log("No working directory configured, using default: '%s'", (Object)newWorkingDirectory);
        } else {
            newWorkingDirectory = new Path(configWorkingDirectory);
        }
        this.setWorkingDirectory(newWorkingDirectory);
        ((GoogleLogger.Api)logger.atFine()).log("%s = %s", (Object)GoogleHadoopFileSystemConfiguration.GCS_WORKING_DIRECTORY.getKey(), (Object)this.getWorkingDirectory());
        this.setConf(config);
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.configure: done");
    }

    private void overrideConfigFromFile(Configuration config) throws IOException {
        String configFile = GoogleHadoopFileSystemConfiguration.GCS_CONFIG_OVERRIDE_FILE.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
        if (configFile != null) {
            config.addResource((InputStream)new FileInputStream(configFile));
        }
    }

    @VisibleForTesting
    public void configureBuckets(String systemBucketName, boolean createSystemBucket) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.configureBuckets: %s, %s", (Object)systemBucketName, createSystemBucket);
        this.systemBucket = systemBucketName;
        if (this.systemBucket != null) {
            ((GoogleLogger.Api)logger.atFine()).log("GHFS.configureBuckets: Warning fs.gs.system.bucket is deprecated.");
            URI systemBucketPath = this.gcsfs.getPathCodec().getPath(this.systemBucket, null, true);
            this.checkOpen();
            if (!this.gcsfs.exists(systemBucketPath)) {
                if (createSystemBucket) {
                    this.gcsfs.mkdirs(systemBucketPath);
                } else {
                    throw new FileNotFoundException(String.format("%s: system bucket not found: %s", GoogleHadoopFileSystemConfiguration.GCS_SYSTEM_BUCKET.getKey(), this.systemBucket));
                }
            }
        }
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.configureBuckets:=>");
    }

    private void checkOpen() throws IOException {
        if (this.gcsfs == null) {
            throw new IOException("GoogleHadoopFileSystem has been closed or not initialized.");
        }
    }

    public boolean deleteOnExit(Path f) throws IOException {
        this.checkOpen();
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.deleteOnExit: %s", (Object)f);
        boolean result = super.deleteOnExit(f);
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.deleteOnExit:=> %s", (Object)result);
        return result;
    }

    protected void processDeleteOnExit() {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.processDeleteOnExit:");
        super.processDeleteOnExit();
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getContentSummary: %s", (Object)f);
        ContentSummary result = super.getContentSummary(f);
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getContentSummary:=> %s", (Object)result);
        return result;
    }

    public Token<?> getDelegationToken(String renewer) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getDelegationToken: renewer: %s", (Object)renewer);
        Token result = super.getDelegationToken(renewer);
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getDelegationToken:=> %s", (Object)result);
        return result;
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.copyFromLocalFile: delSrc: %s, overwrite: %s, #srcs: %s, dst: %s", (Object)delSrc, (Object)overwrite, (Object)srcs.length, (Object)dst);
        super.copyFromLocalFile(delSrc, overwrite, srcs, dst);
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.copyFromLocalFile:=> ");
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.copyFromLocalFile: delSrc: %s, overwrite: %s, src: %s, dst: %s", (Object)delSrc, (Object)overwrite, (Object)src, (Object)dst);
        super.copyFromLocalFile(delSrc, overwrite, src, dst);
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.copyFromLocalFile:=> ");
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.copyToLocalFile: delSrc: %s, src: %s, dst: %s", (Object)delSrc, (Object)src, (Object)dst);
        super.copyToLocalFile(delSrc, src, dst);
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.copyToLocalFile:=> ");
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.startLocalOutput: out: %s, tmp: %s", (Object)fsOutputFile, (Object)tmpLocalFile);
        Path result = super.startLocalOutput(fsOutputFile, tmpLocalFile);
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.startLocalOutput:=> %s", (Object)result);
        return result;
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.startLocalOutput: out: %s, tmp: %s", (Object)fsOutputFile, (Object)tmpLocalFile);
        super.completeLocalOutput(fsOutputFile, tmpLocalFile);
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.completeLocalOutput:=> ");
    }

    public void close() throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.close:");
        super.close();
        if (this.gcsfs != null) {
            this.gcsfs.close();
            this.gcsfs = null;
        }
        this.logCounters();
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.close:=> ");
    }

    public long getUsed() throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getUsed:");
        long result = super.getUsed();
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getUsed:=> %s", result);
        return result;
    }

    public long getDefaultBlockSize() {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getDefaultBlockSize:");
        long result = this.defaultBlockSize;
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getDefaultBlockSize:=> %s", result);
        return result;
    }

    public FileChecksum getFileChecksum(Path hadoopPath) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument((hadoopPath != null ? 1 : 0) != 0, (Object)"hadoopPath must not be null");
        this.checkOpen();
        URI gcsPath = this.getGcsPath(hadoopPath);
        FileInfo fileInfo = this.gcsfs.getFileInfo(gcsPath);
        if (!fileInfo.exists()) {
            ((GoogleLogger.Api)logger.atFine()).log("GHFS.getFileStatus: not found: %s", (Object)gcsPath);
            throw new FileNotFoundException((fileInfo.isDirectory() ? "Directory not found : " : "File not found : ") + hadoopPath);
        }
        FileChecksum checksum = GoogleHadoopFileSystemBase.getFileChecksum(this.checksumType, fileInfo);
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.getFileChecksum:=> %s", (Object)checksum);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.GET_FILE_CHECKSUM);
        this.increment(Counter.GET_FILE_CHECKSUM_TIME, duration);
        return checksum;
    }

    private static FileChecksum getFileChecksum(GcsFileChecksumType type, FileInfo fileInfo) throws IOException {
        switch (type) {
            case NONE: {
                return null;
            }
            case CRC32C: {
                return new GcsFileChecksum(type, fileInfo.getItemInfo().getVerificationAttributes().getCrc32c());
            }
            case MD5: {
                return new GcsFileChecksum(type, fileInfo.getItemInfo().getVerificationAttributes().getMd5hash());
            }
        }
        throw new IOException("Unrecognized GcsFileChecksumType: " + (Object)((Object)type));
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.setVerifyChecksum:");
        super.setVerifyChecksum(verifyChecksum);
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.setVerifyChecksum:=> ");
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.setPermission: path: %s, perm: %s", (Object)p, (Object)permission);
        super.setPermission(p, permission);
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.setPermission:=> ");
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.setOwner: path: %s, user: %s, group: %s", (Object)p, (Object)username, (Object)groupname);
        super.setOwner(p, username, groupname);
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.setOwner:=> ");
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.setTimes: path: %s, mtime: %s, atime: %s", (Object)p, (Object)mtime, (Object)atime);
        super.setTimes(p, mtime, atime);
        ((GoogleLogger.Api)logger.atFine()).log("GHFS.setTimes:=> ");
    }

    static {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS version: %s", (Object)VERSION);
        GHFS_ID = String.format("GHFS/%s", VERSION);
        ALL_COUNTERS = Sets.immutableEnumSet(EnumSet.allOf(Counter.class));
        PERMISSIONS_TO_REPORT_KEY = GoogleHadoopFileSystemConfiguration.PERMISSIONS_TO_REPORT.getKey();
        PERMISSIONS_TO_REPORT_DEFAULT = GoogleHadoopFileSystemConfiguration.PERMISSIONS_TO_REPORT.getDefault();
        BUFFERSIZE_KEY = GoogleHadoopFileSystemConfiguration.GCS_INPUT_STREAM_BUFFER_SIZE.getKey();
        BUFFERSIZE_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_INPUT_STREAM_BUFFER_SIZE.getDefault();
        WRITE_BUFFERSIZE_KEY = GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_UPLOAD_CHUNK_SIZE.getKey();
        WRITE_BUFFERSIZE_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_UPLOAD_CHUNK_SIZE.getDefault();
        BLOCK_SIZE_KEY = GoogleHadoopFileSystemConfiguration.BLOCK_SIZE.getKey();
        BLOCK_SIZE_DEFAULT = GoogleHadoopFileSystemConfiguration.BLOCK_SIZE.getDefault().intValue();
        ENABLE_GCE_SERVICE_ACCOUNT_AUTH_KEY = GoogleHadoopFileSystemConfiguration.AUTH_SERVICE_ACCOUNT_ENABLE.getKey();
        SERVICE_ACCOUNT_AUTH_EMAIL_KEY = GoogleHadoopFileSystemConfiguration.AUTH_SERVICE_ACCOUNT_EMAIL.getKey();
        SERVICE_ACCOUNT_AUTH_KEYFILE_KEY = GoogleHadoopFileSystemConfiguration.AUTH_SERVICE_ACCOUNT_KEY_FILE.getKey();
        GCS_PROJECT_ID_KEY = GoogleHadoopFileSystemConfiguration.GCS_PROJECT_ID.getKey();
        GCS_REQUESTER_PAYS_MODE_KEY = GoogleHadoopFileSystemConfiguration.GCS_REQUESTER_PAYS_MODE.getKey();
        GCS_REQUESTER_PAYS_PROJECT_ID_KEY = GoogleHadoopFileSystemConfiguration.GCS_REQUESTER_PAYS_PROJECT_ID.getKey();
        GCS_REQUESTER_PAYS_BUCKETS_KEY = GoogleHadoopFileSystemConfiguration.GCS_REQUESTER_PAYS_BUCKETS.getKey();
        GCS_CLIENT_ID_KEY = GoogleHadoopFileSystemConfiguration.AUTH_CLIENT_ID.getKey();
        GCS_CLIENT_SECRET_KEY = GoogleHadoopFileSystemConfiguration.AUTH_CLIENT_SECRET.getKey();
        GCS_SYSTEM_BUCKET_KEY = GoogleHadoopFileSystemConfiguration.GCS_SYSTEM_BUCKET.getKey();
        GCS_CREATE_SYSTEM_BUCKET_KEY = GoogleHadoopFileSystemConfiguration.GCS_CREATE_SYSTEM_BUCKET.getKey();
        GCS_CREATE_SYSTEM_BUCKET_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_CREATE_SYSTEM_BUCKET.getDefault();
        GCS_WORKING_DIRECTORY_KEY = GoogleHadoopFileSystemConfiguration.GCS_WORKING_DIRECTORY.getKey();
        GCS_FILE_SIZE_LIMIT_250GB = GoogleHadoopFileSystemConfiguration.GCS_FILE_SIZE_LIMIT_250GB.getKey();
        GCS_FILE_SIZE_LIMIT_250GB_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_FILE_SIZE_LIMIT_250GB.getDefault();
        GCS_MARKER_FILE_PATTERN_KEY = GoogleHadoopFileSystemConfiguration.GCS_MARKER_FILE_PATTERN.getKey();
        GCS_ENABLE_PERFORMANCE_CACHE_KEY = GoogleHadoopFileSystemConfiguration.GCS_PERFORMANCE_CACHE_ENABLE.getKey();
        GCS_ENABLE_PERFORMANCE_CACHE_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_PERFORMANCE_CACHE_ENABLE.getDefault();
        GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE_MILLIS_KEY = GoogleHadoopFileSystemConfiguration.GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE_MILLIS.getKey();
        GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE_MILLIS_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE_MILLIS.getDefault();
        GCS_PERFORMANCE_CACHE_LIST_CACHING_ENABLE_KEY = GoogleHadoopFileSystemConfiguration.GCS_PERFORMANCE_CACHE_LIST_CACHING_ENABLE.getKey();
        GCS_PERFORMANCE_CACHE_LIST_CACHING_ENABLE_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_PERFORMANCE_CACHE_LIST_CACHING_ENABLE.getDefault();
        GCS_PERFORMANCE_CACHE_DIR_METADATA_PREFETCH_LIMIT_KEY = GoogleHadoopFileSystemConfiguration.GCS_PERFORMANCE_CACHE_DIR_METADATA_PREFETCH_LIMIT.getKey();
        GCS_PERFORMANCE_CACHE_DIR_METADATA_PREFETCH_LIMIT_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_PERFORMANCE_CACHE_DIR_METADATA_PREFETCH_LIMIT.getDefault();
        GCS_PARENT_TIMESTAMP_UPDATE_ENABLE_KEY = GoogleHadoopFileSystemConfiguration.GCS_PARENT_TIMESTAMP_UPDATE_ENABLE.getKey();
        GCS_PARENT_TIMESTAMP_UPDATE_ENABLE_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_PARENT_TIMESTAMP_UPDATE_ENABLE.getDefault();
        GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_KEY = GoogleHadoopFileSystemConfiguration.GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES.getKey();
        GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES_DEFAULT = Joiner.on((char)',').join((Iterable)GoogleHadoopFileSystemConfiguration.GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES.getDefault());
        GCS_PARENT_TIMESTAMP_UPDATE_INCLUDES_KEY = GoogleHadoopFileSystemConfiguration.GCS_PARENT_TIMESTAMP_UPDATE_INCLUDES.getKey();
        GCS_PARENT_TIMESTAMP_UPDATE_INCLUDES_DEFAULT = Joiner.on((char)',').join((Iterable)GoogleHadoopFileSystemConfiguration.GCS_PARENT_TIMESTAMP_UPDATE_INCLUDES.getDefault());
        GCS_ENABLE_REPAIR_IMPLICIT_DIRECTORIES_KEY = GoogleHadoopFileSystemConfiguration.GCS_REPAIR_IMPLICIT_DIRECTORIES_ENABLE.getKey();
        GCS_ENABLE_REPAIR_IMPLICIT_DIRECTORIES_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_REPAIR_IMPLICIT_DIRECTORIES_ENABLE.getDefault();
        PATH_CODEC_KEY = GoogleHadoopFileSystemConfiguration.PATH_CODEC.getKey();
        PATH_CODEC_DEFAULT = GoogleHadoopFileSystemConfiguration.PATH_CODEC.getDefault();
        GCS_ENABLE_INFER_IMPLICIT_DIRECTORIES_KEY = GoogleHadoopFileSystemConfiguration.GCS_INFER_IMPLICIT_DIRECTORIES_ENABLE.getKey();
        GCS_ENABLE_INFER_IMPLICIT_DIRECTORIES_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_INFER_IMPLICIT_DIRECTORIES_ENABLE.getDefault();
        GCS_ENABLE_FLAT_GLOB_KEY = GoogleHadoopFileSystemConfiguration.GCS_FLAT_GLOB_ENABLE.getKey();
        GCS_ENABLE_FLAT_GLOB_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_FLAT_GLOB_ENABLE.getDefault();
        GCS_ENABLE_MARKER_FILE_CREATION_KEY = GoogleHadoopFileSystemConfiguration.GCS_MARKER_FILE_CREATION_ENABLE.getKey();
        GCS_ENABLE_MARKER_FILE_CREATION_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_MARKER_FILE_CREATION_ENABLE.getDefault();
        GCS_ENABLE_COPY_WITH_REWRITE_KEY = GoogleHadoopFileSystemConfiguration.GCS_COPY_WITH_REWRITE_ENABLE.getKey();
        GCS_ENABLE_COPY_WITH_REWRITE_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_COPY_WITH_REWRITE_ENABLE.getDefault();
        GCS_COPY_MAX_REQUESTS_PER_BATCH = GoogleHadoopFileSystemConfiguration.GCS_COPY_MAX_REQUESTS_PER_BATCH.getKey();
        GCS_COPY_MAX_REQUESTS_PER_BATCH_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_COPY_MAX_REQUESTS_PER_BATCH.getDefault();
        GCS_COPY_BATCH_THREADS = GoogleHadoopFileSystemConfiguration.GCS_COPY_BATCH_THREADS.getKey();
        GCS_COPY_BATCH_THREADS_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_COPY_BATCH_THREADS.getDefault();
        GCS_MAX_LIST_ITEMS_PER_CALL = GoogleHadoopFileSystemConfiguration.GCS_MAX_LIST_ITEMS_PER_CALL.getKey();
        GCS_MAX_LIST_ITEMS_PER_CALL_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_MAX_LIST_ITEMS_PER_CALL.getDefault();
        GCS_MAX_REQUESTS_PER_BATCH = GoogleHadoopFileSystemConfiguration.GCS_MAX_REQUESTS_PER_BATCH.getKey();
        GCS_MAX_REQUESTS_PER_BATCH_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_MAX_REQUESTS_PER_BATCH.getDefault();
        GCS_BATCH_THREADS = GoogleHadoopFileSystemConfiguration.GCS_BATCH_THREADS.getKey();
        GCS_BATCH_THREADS_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_BATCH_THREADS.getDefault();
        GCS_HTTP_MAX_RETRY_KEY = GoogleHadoopFileSystemConfiguration.GCS_HTTP_MAX_RETRY.getKey();
        GCS_HTTP_MAX_RETRY_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_HTTP_MAX_RETRY.getDefault();
        GCS_HTTP_CONNECT_TIMEOUT_KEY = GoogleHadoopFileSystemConfiguration.GCS_HTTP_CONNECT_TIMEOUT.getKey();
        GCS_HTTP_CONNECT_TIMEOUT_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_HTTP_CONNECT_TIMEOUT.getDefault();
        GCS_HTTP_READ_TIMEOUT_KEY = GoogleHadoopFileSystemConfiguration.GCS_HTTP_READ_TIMEOUT.getKey();
        GCS_HTTP_READ_TIMEOUT_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_HTTP_READ_TIMEOUT.getDefault();
        GCS_PROXY_ADDRESS_KEY = GoogleHadoopFileSystemConfiguration.GCS_PROXY_ADDRESS.getKey();
        GCS_PROXY_ADDRESS_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_PROXY_ADDRESS.getDefault();
        GCS_HTTP_TRANSPORT_KEY = GoogleHadoopFileSystemConfiguration.GCS_HTTP_TRANSPORT.getKey();
        GCS_HTTP_TRANSPORT_DEFAULT = null;
        GCS_APPLICATION_NAME_SUFFIX_KEY = GoogleHadoopFileSystemConfiguration.GCS_APPLICATION_NAME_SUFFIX.getKey();
        GCS_APPLICATION_NAME_SUFFIX_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_APPLICATION_NAME_SUFFIX.getDefault();
        GCS_MAX_WAIT_MILLIS_EMPTY_OBJECT_CREATE_KEY = GoogleHadoopFileSystemConfiguration.GCS_MAX_WAIT_MILLIS_EMPTY_OBJECT_CREATE.getKey();
        GCS_MAX_WAIT_MILLIS_EMPTY_OBJECT_CREATE_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_MAX_WAIT_MILLIS_EMPTY_OBJECT_CREATE.getDefault();
        GCS_OUTPUTSTREAM_TYPE_KEY = GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_TYPE.getKey();
        GCS_OUTPUTSTREAM_TYPE_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_TYPE.getDefault().toString();
        GCS_GENERATION_READ_CONSISTENCY_KEY = GoogleHadoopFileSystemConfiguration.GCS_GENERATION_READ_CONSISTENCY.getKey();
        GCS_GENERATION_READ_CONSISTENCY_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_GENERATION_READ_CONSISTENCY.getDefault();
        GCS_INPUTSTREAM_FAST_FAIL_ON_NOT_FOUND_ENABLE_KEY = GoogleHadoopFileSystemConfiguration.GCS_INPUT_STREAM_FAST_FAIL_ON_NOT_FOUND_ENABLE.getKey();
        GCS_INPUTSTREAM_FAST_FAIL_ON_NOT_FOUND_ENABLE_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_INPUT_STREAM_FAST_FAIL_ON_NOT_FOUND_ENABLE.getDefault();
        GCS_INPUTSTREAM_INPLACE_SEEK_LIMIT_KEY = GoogleHadoopFileSystemConfiguration.GCS_INPUT_STREAM_INPLACE_SEEK_LIMIT.getKey();
        GCS_INPUTSTREAM_INPLACE_SEEK_LIMIT_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_INPUT_STREAM_INPLACE_SEEK_LIMIT.getDefault();
        GCS_INPUTSTREAM_FADVISE_KEY = GoogleHadoopFileSystemConfiguration.GCS_INPUT_STREAM_FADVISE.getKey();
        GCS_INPUTSTREAM_FADVISE_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_INPUT_STREAM_FADVISE.getDefault();
        GCS_INPUTSTREAM_MIN_RANGE_REQUEST_SIZE_KEY = GoogleHadoopFileSystemConfiguration.GCS_INPUT_STREAM_MIN_RANGE_REQUEST_SIZE.getKey();
        GCS_INPUTSTREAM_MIN_RANGE_REQUEST_SIZE_DEFAULT = GoogleHadoopFileSystemConfiguration.GCS_INPUT_STREAM_MIN_RANGE_REQUEST_SIZE.getDefault();
        GCE_BUCKET_DELETE_ENABLE_KEY = GoogleHadoopFileSystemConfiguration.GCE_BUCKET_DELETE_ENABLE.getKey();
        GCE_BUCKET_DELETE_ENABLE_DEFAULT = GoogleHadoopFileSystemConfiguration.GCE_BUCKET_DELETE_ENABLE.getDefault();
    }

    public static class ParentTimestampUpdateIncludePredicate
    implements GoogleCloudStorageFileSystemOptions.TimestampUpdatePredicate {
        private final Collection<String> includeSubstrings;
        private final Collection<String> excludeSubstrings;
        private final boolean enableTimestampUpdates;

        public static ParentTimestampUpdateIncludePredicate create(Configuration config) {
            return new ParentTimestampUpdateIncludePredicate(GoogleHadoopFileSystemConfiguration.GCS_PARENT_TIMESTAMP_UPDATE_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1)), GoogleHadoopFileSystemConfiguration.GCS_PARENT_TIMESTAMP_UPDATE_INCLUDES.getStringCollection(config), GoogleHadoopFileSystemConfiguration.GCS_PARENT_TIMESTAMP_UPDATE_EXCLUDES.getStringCollection(config));
        }

        public ParentTimestampUpdateIncludePredicate(boolean enableTimestampUpdates, Collection<String> includeSubstrings, Collection<String> excludeSubstrings) {
            this.includeSubstrings = includeSubstrings;
            this.excludeSubstrings = excludeSubstrings;
            this.enableTimestampUpdates = enableTimestampUpdates;
        }

        public boolean shouldUpdateTimestamp(URI uri) {
            if (!this.enableTimestampUpdates) {
                ((GoogleLogger.Api)logger.atFine()).log("Timestamp updating disabled. Not updating uri %s", (Object)uri);
                return false;
            }
            for (String include : this.includeSubstrings) {
                if (!uri.toString().contains(include)) continue;
                ((GoogleLogger.Api)logger.atFine()).log("Path %s matched included path %s. Updating timestamps.", (Object)uri, (Object)include);
                return true;
            }
            for (String exclude : this.excludeSubstrings) {
                if (!uri.toString().contains(exclude)) continue;
                ((GoogleLogger.Api)logger.atFine()).log("Path %s matched excluded path %s. Not updating timestamps.", (Object)uri, (Object)exclude);
                return false;
            }
            return true;
        }
    }

    private static class GcsFileChecksum
    extends FileChecksum {
        private final GcsFileChecksumType checksumType;
        private final byte[] bytes;

        public GcsFileChecksum(GcsFileChecksumType checksumType, byte[] bytes) {
            this.checksumType = checksumType;
            this.bytes = bytes;
            Preconditions.checkState((bytes == null || bytes.length == checksumType.getByteLength() ? 1 : 0) != 0, (String)"Checksum value length (%s) should be equal to the algorithm byte length (%s)", (int)checksumType.getByteLength(), (int)bytes.length);
        }

        public String getAlgorithmName() {
            return this.checksumType.getAlgorithmName();
        }

        public int getLength() {
            return this.checksumType.getByteLength();
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public void readFields(DataInput in) throws IOException {
            in.readFully(this.bytes);
        }

        public void write(DataOutput out) throws IOException {
            out.write(this.bytes);
        }

        public String toString() {
            return this.getAlgorithmName() + ": " + (this.bytes == null ? null : new String(Hex.encodeHex((byte[])this.bytes)));
        }
    }

    public static enum Counter {
        APPEND,
        APPEND_TIME,
        CREATE,
        CREATE_TIME,
        DELETE,
        DELETE_TIME,
        GET_FILE_CHECKSUM,
        GET_FILE_CHECKSUM_TIME,
        GET_FILE_STATUS,
        GET_FILE_STATUS_TIME,
        INIT,
        INIT_TIME,
        INPUT_STREAM,
        INPUT_STREAM_TIME,
        LIST_STATUS,
        LIST_STATUS_TIME,
        MKDIRS,
        MKDIRS_TIME,
        OPEN,
        OPEN_TIME,
        OUTPUT_STREAM,
        OUTPUT_STREAM_TIME,
        READ1,
        READ1_TIME,
        READ,
        READ_TIME,
        READ_FROM_CHANNEL,
        READ_FROM_CHANNEL_TIME,
        READ_CLOSE,
        READ_CLOSE_TIME,
        READ_POS,
        READ_POS_TIME,
        RENAME,
        RENAME_TIME,
        SEEK,
        SEEK_TIME,
        SET_WD,
        SET_WD_TIME,
        WRITE1,
        WRITE1_TIME,
        WRITE,
        WRITE_TIME,
        WRITE_CLOSE,
        WRITE_CLOSE_TIME;

    }

    protected static enum ListStatusFileNotFoundBehavior {
        Hadoop1{

            @Override
            public FileStatus[] handle(String path) throws IOException {
                return null;
            }
        }
        ,
        Hadoop2{

            @Override
            public FileStatus[] handle(String path) throws IOException {
                throw new FileNotFoundException(String.format("Path '%s' does not exist.", path));
            }
        };


        public abstract FileStatus[] handle(String var1) throws IOException;

        public static ListStatusFileNotFoundBehavior get() {
            return ListStatusFileNotFoundBehavior.get(HadoopVersionInfo.getInstance());
        }

        public static ListStatusFileNotFoundBehavior get(HadoopVersionInfo hadoopVersionInfo) {
            if (hadoopVersionInfo.isGreaterThan(2, 0) || hadoopVersionInfo.isEqualTo(2, 0) || hadoopVersionInfo.isEqualTo(0, 23)) {
                return Hadoop2;
            }
            return Hadoop1;
        }
    }

    public static enum GcsFileChecksumType {
        NONE(null, 0),
        CRC32C("COMPOSITE-CRC32C", 4),
        MD5("MD5", 16);

        private final String algorithmName;
        private final int byteLength;

        private GcsFileChecksumType(String algorithmName, int byteLength) {
            this.algorithmName = algorithmName;
            this.byteLength = byteLength;
        }

        public String getAlgorithmName() {
            return this.algorithmName;
        }

        public int getByteLength() {
            return this.byteLength;
        }
    }

    public static enum OutputStreamType {
        BASIC,
        SYNCABLE_COMPOSITE;

    }
}

