/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.BlobProperties;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.BlobType;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.CloudBlob;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.CloudBlobContainer;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.CopyState;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.CopyStatus;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.LeaseDuration;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.LeaseState;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.LeaseStatus;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.ListBlobsResponse;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class BlobListHandler
extends DefaultHandler {
    private final Stack<String> elementStack = new Stack();
    private StringBuilder bld = new StringBuilder();
    private final ListBlobsResponse response = new ListBlobsResponse();
    private final CloudBlobContainer container;
    private BlobProperties properties;
    private HashMap<String, String> metadata;
    private CopyState copyState;
    private String blobName;
    private String snapshotID;

    private BlobListHandler(CloudBlobContainer container) {
        this.container = container;
    }

    public static ListBlobsResponse getBlobList(InputStream stream, CloudBlobContainer container) throws ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = Utility.getSAXParser();
        BlobListHandler handler = new BlobListHandler(container);
        saxParser.parse(stream, (DefaultHandler)handler);
        return handler.response;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementStack.push(localName);
        if ("Blob".equals(localName) || "BlobPrefix".equals(localName)) {
            this.blobName = "";
            this.snapshotID = null;
            this.properties = new BlobProperties();
            this.metadata = new HashMap();
            this.copyState = null;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String value;
        String currentNode = this.elementStack.pop();
        if (!localName.equals(currentNode)) {
            throw new SAXException("The response received is invalid or improperly formatted.");
        }
        String parentNode = null;
        if (!this.elementStack.isEmpty()) {
            parentNode = this.elementStack.peek();
        }
        if ((value = this.bld.toString()).isEmpty()) {
            value = null;
        }
        if ("Blob".equals(currentNode)) {
            CloudBlob retBlob;
            block39: {
                retBlob = null;
                try {
                    if (this.properties.getBlobType() == BlobType.BLOCK_BLOB) {
                        retBlob = this.container.getBlockBlobReference(this.blobName);
                        break block39;
                    }
                    if (this.properties.getBlobType() == BlobType.PAGE_BLOB) {
                        retBlob = this.container.getPageBlobReference(this.blobName);
                        break block39;
                    }
                    throw new SAXException("The response received is invalid or improperly formatted.");
                }
                catch (StorageException e) {
                    throw new SAXException(e);
                }
                catch (URISyntaxException e) {
                    throw new SAXException(e);
                }
            }
            retBlob.snapshotID = this.snapshotID;
            retBlob.properties = this.properties;
            retBlob.metadata = this.metadata;
            retBlob.properties.setCopyState(this.copyState);
            this.response.getResults().add(retBlob);
        } else if ("BlobPrefix".equals(currentNode)) {
            try {
                this.response.getResults().add(this.container.getDirectoryReference(this.blobName));
            }
            catch (URISyntaxException e) {
                throw new SAXException(e);
            }
        } else if ("EnumerationResults".equals(parentNode)) {
            if ("Prefix".equals(currentNode)) {
                this.response.setPrefix(value);
            } else if ("Marker".equals(currentNode)) {
                this.response.setMarker(value);
            } else if ("NextMarker".equals(currentNode)) {
                this.response.setNextMarker(value);
            } else if ("MaxResults".equals(currentNode)) {
                this.response.setMaxResults(Integer.parseInt(value));
            } else if ("Delimiter".equals(currentNode)) {
                this.response.setDelimiter(value);
            }
        } else if ("Blob".equals(parentNode)) {
            if ("Name".equals(currentNode)) {
                this.blobName = value;
            } else if ("Snapshot".equals(currentNode)) {
                this.snapshotID = value;
            }
        } else if ("BlobPrefix".equals(parentNode)) {
            if ("Name".equals(currentNode)) {
                this.blobName = value;
            }
        } else if ("Properties".equals(parentNode)) {
            try {
                this.setProperties(currentNode, value);
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
            catch (URISyntaxException e) {
                throw new SAXException(e);
            }
        } else if ("Metadata".equals(parentNode)) {
            this.metadata.put(currentNode, value);
        }
        this.bld = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.bld.append(ch, start, length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setProperties(String currentNode, String value) throws ParseException, URISyntaxException, SAXException {
        if ("Last-Modified".equals(currentNode)) {
            this.properties.setLastModified(Utility.parseRFC1123DateFromStringInGMT(value));
            return;
        } else if ("Etag".equals(currentNode)) {
            this.properties.setEtag(Utility.formatETag(value));
            return;
        } else if ("Content-Length".equals(currentNode)) {
            this.properties.setLength(Long.parseLong(value));
            return;
        } else if ("Content-Type".equals(currentNode)) {
            this.properties.setContentType(value);
            return;
        } else if ("Content-Encoding".equals(currentNode)) {
            this.properties.setContentEncoding(value);
            return;
        } else if ("Content-Language".equals(currentNode)) {
            this.properties.setContentLanguage(value);
            return;
        } else if ("Content-MD5".equals(currentNode)) {
            this.properties.setContentMD5(value);
            return;
        } else if ("Cache-Control".equals(currentNode)) {
            this.properties.setCacheControl(value);
            return;
        } else if ("Content-Disposition".equals(currentNode)) {
            this.properties.setContentDisposition(value);
            return;
        } else if ("BlobType".equals(currentNode)) {
            String tempString = value;
            if (tempString.equals("BlockBlob")) {
                this.properties.setBlobType(BlobType.BLOCK_BLOB);
                return;
            } else {
                if (!tempString.equals("PageBlob".toString())) throw new SAXException("The response received is invalid or improperly formatted.");
                this.properties.setBlobType(BlobType.PAGE_BLOB);
            }
            return;
        } else if ("LeaseStatus".equals(currentNode)) {
            LeaseStatus tempStatus = LeaseStatus.parse(value);
            if (tempStatus.equals((Object)LeaseStatus.UNSPECIFIED)) throw new SAXException("The response received is invalid or improperly formatted.");
            this.properties.setLeaseStatus(tempStatus);
            return;
        } else if ("LeaseState".equals(currentNode)) {
            LeaseState tempState = LeaseState.parse(value);
            if (tempState.equals((Object)LeaseState.UNSPECIFIED)) throw new SAXException("The response received is invalid or improperly formatted.");
            this.properties.setLeaseState(tempState);
            return;
        } else if ("LeaseDuration".equals(currentNode)) {
            LeaseDuration tempDuration = LeaseDuration.parse(value);
            if (tempDuration.equals((Object)LeaseDuration.UNSPECIFIED)) throw new SAXException("The response received is invalid or improperly formatted.");
            this.properties.setLeaseDuration(tempDuration);
            return;
        } else if ("CopyId".equals(currentNode)) {
            if (this.copyState == null) {
                this.copyState = new CopyState();
            }
            this.copyState.setCopyId(value);
            return;
        } else if ("CopyCompletionTime".equals(currentNode)) {
            if (this.copyState == null) {
                this.copyState = new CopyState();
            }
            this.copyState.setCompletionTime(Utility.parseRFC1123DateFromStringInGMT(value));
            return;
        } else if ("CopyStatus".equals(currentNode)) {
            if (this.copyState == null) {
                this.copyState = new CopyState();
            }
            this.copyState.setStatus(CopyStatus.parse(value));
            return;
        } else if ("CopySource".equals(currentNode)) {
            if (this.copyState == null) {
                this.copyState = new CopyState();
            }
            this.copyState.setSource(new URI(value));
            return;
        } else if ("CopyProgress".equals(currentNode)) {
            if (this.copyState == null) {
                this.copyState = new CopyState();
            }
            String tempString = value;
            String[] progressSequence = tempString.split("/");
            this.copyState.setBytesCopied(Long.parseLong(progressSequence[0]));
            this.copyState.setTotalBytes(Long.parseLong(progressSequence[1]));
            return;
        } else {
            if (!"CopyStatusDescription".equals(currentNode)) return;
            if (this.copyState == null) {
                this.copyState = new CopyState();
            }
            this.copyState.setStatusDescription(value);
        }
    }
}

