/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop;

import java.lang.reflect.Field;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.PrestoFileSystemCache;

public final class HadoopFileSystemCache {
    private static PrestoFileSystemCache cache;

    private HadoopFileSystemCache() {
    }

    public static synchronized void initialize() {
        if (cache == null) {
            cache = HadoopFileSystemCache.setFinalStatic(FileSystem.class, "CACHE", new PrestoFileSystemCache());
        }
    }

    private static <T> T setFinalStatic(Class<?> clazz, String name, T value) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(null, value);
            return value;
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

