/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.SendingRequestEvent;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageCredentials;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageEvent;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.StorageCredentialsHelper;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.Log;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.net.HttpURLConnection;
import java.security.InvalidKeyException;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public final class SendRequestIntercept
extends StorageEvent<SendingRequestEvent> {
    public static final Log LOG = LogFactory.getLog(SendRequestIntercept.class);
    private static final String ALLOW_ALL_REQUEST_PRECONDITIONS = "*";
    private final StorageCredentials storageCreds;
    private final boolean allowConcurrentOOBIo;
    private final OperationContext opContext;

    private StorageCredentials getCredentials() {
        return this.storageCreds;
    }

    private boolean isOutOfBandIoAllowed() {
        return this.allowConcurrentOOBIo;
    }

    private OperationContext getOperationContext() {
        return this.opContext;
    }

    private SendRequestIntercept(StorageCredentials storageCreds, boolean allowConcurrentOOBIo, OperationContext opContext) {
        this.storageCreds = storageCreds;
        this.allowConcurrentOOBIo = allowConcurrentOOBIo;
        this.opContext = opContext;
    }

    public static void bind(StorageCredentials storageCreds, OperationContext opContext, boolean allowConcurrentOOBIo) {
        SendRequestIntercept sendListener = new SendRequestIntercept(storageCreds, allowConcurrentOOBIo, opContext);
        opContext.getSendingRequestEventHandler().addListener(sendListener);
    }

    @Override
    public void eventOccurred(SendingRequestEvent sendEvent) {
        if (!(sendEvent.getConnectionObject() instanceof HttpURLConnection)) {
            return;
        }
        HttpURLConnection urlConnection = (HttpURLConnection)sendEvent.getConnectionObject();
        if (urlConnection.getRequestMethod().equalsIgnoreCase("GET") && this.isOutOfBandIoAllowed()) {
            urlConnection.setRequestProperty("If-Match", ALLOW_ALL_REQUEST_PRECONDITIONS);
            try {
                StorageCredentialsHelper.signBlobAndQueueRequest(this.getCredentials(), urlConnection, -1L, this.getOperationContext());
            }
            catch (InvalidKeyException e) {
                String errString = String.format("Received invalid key exception when attempting sign packet. Cause: %s", e.getCause().toString());
                LOG.error(errString);
            }
            catch (StorageException e) {
                String errString = String.format("Received storage exception when attempting to sign packet. Cause: %s", e.getCause().toString());
                LOG.error(errString);
            }
        }
    }
}

