/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import io.prestosql.hadoop.$internal.org.apache.commons.logging.Log;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.BlockReaderUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.shortcircuit.ClientMmap;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.DirectBufferPool;
import org.apache.htrace.Sampler;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;

class BlockReaderLocalLegacy
implements BlockReader {
    private static final Log LOG = LogFactory.getLog(BlockReaderLocalLegacy.class);
    private static final Map<Integer, LocalDatanodeInfo> localDatanodeInfoMap = new HashMap<Integer, LocalDatanodeInfo>();
    private final FileInputStream dataIn;
    private final FileInputStream checksumIn;
    private int offsetFromChunkBoundary;
    private byte[] skipBuf = null;
    private ByteBuffer slowReadBuff = null;
    private ByteBuffer checksumBuff = null;
    private DataChecksum checksum;
    private final boolean verifyChecksum;
    private static final DirectBufferPool bufferPool = new DirectBufferPool();
    private final int bytesPerChecksum;
    private final int checksumSize;
    private long startOffset;
    private final String filename;
    private long blockId;

    static BlockReaderLocalLegacy newBlockReader(DFSClient.Conf conf, UserGroupInformation userGroupInformation, Configuration configuration, String file, ExtendedBlock blk, Token<BlockTokenIdentifier> token, DatanodeInfo node, long startOffset, long length, StorageType storageType) throws IOException {
        LocalDatanodeInfo localDatanodeInfo = BlockReaderLocalLegacy.getLocalDatanodeInfo(node.getIpcPort());
        BlockLocalPathInfo pathinfo = localDatanodeInfo.getBlockLocalPathInfo(blk);
        if (pathinfo == null) {
            if (userGroupInformation == null) {
                userGroupInformation = UserGroupInformation.getCurrentUser();
            }
            pathinfo = BlockReaderLocalLegacy.getBlockPathInfo(userGroupInformation, blk, node, configuration, conf.socketTimeout, token, conf.connectToDnViaHostname, storageType);
        }
        FileInputStream dataIn = null;
        FileInputStream checksumIn = null;
        BlockReaderLocalLegacy localBlockReader = null;
        boolean skipChecksumCheck = conf.skipShortCircuitChecksums || storageType.isTransient();
        try {
            File blkfile = new File(pathinfo.getBlockPath());
            dataIn = new FileInputStream(blkfile);
            if (LOG.isDebugEnabled()) {
                LOG.debug("New BlockReaderLocalLegacy for file " + blkfile + " of size " + blkfile.length() + " startOffset " + startOffset + " length " + length + " short circuit checksum " + !skipChecksumCheck);
            }
            if (!skipChecksumCheck) {
                File metafile = new File(pathinfo.getMetaPath());
                checksumIn = new FileInputStream(metafile);
                DataChecksum checksum = BlockMetadataHeader.readDataChecksum(new DataInputStream(checksumIn), blk);
                long firstChunkOffset = startOffset - startOffset % (long)checksum.getBytesPerChecksum();
                localBlockReader = new BlockReaderLocalLegacy(conf, file, blk, token, startOffset, length, pathinfo, checksum, true, dataIn, firstChunkOffset, checksumIn);
            } else {
                localBlockReader = new BlockReaderLocalLegacy(conf, file, blk, token, startOffset, length, pathinfo, dataIn);
            }
        }
        catch (IOException e) {
            localDatanodeInfo.removeBlockLocalPathInfo(blk);
            DFSClient.LOG.warn("BlockReaderLocalLegacy: Removing " + blk + " from cache because local file " + pathinfo.getBlockPath() + " could not be opened.");
            throw e;
        }
        finally {
            if (localBlockReader == null) {
                if (dataIn != null) {
                    dataIn.close();
                }
                if (checksumIn != null) {
                    checksumIn.close();
                }
            }
        }
        return localBlockReader;
    }

    private static synchronized LocalDatanodeInfo getLocalDatanodeInfo(int port) {
        LocalDatanodeInfo ldInfo = localDatanodeInfoMap.get(port);
        if (ldInfo == null) {
            ldInfo = new LocalDatanodeInfo();
            localDatanodeInfoMap.put(port, ldInfo);
        }
        return ldInfo;
    }

    private static BlockLocalPathInfo getBlockPathInfo(UserGroupInformation ugi, ExtendedBlock blk, DatanodeInfo node, Configuration conf, int timeout, Token<BlockTokenIdentifier> token, boolean connectToDnViaHostname, StorageType storageType) throws IOException {
        LocalDatanodeInfo localDatanodeInfo = BlockReaderLocalLegacy.getLocalDatanodeInfo(node.getIpcPort());
        BlockLocalPathInfo pathinfo = null;
        ClientDatanodeProtocol proxy = localDatanodeInfo.getDatanodeProxy(ugi, node, conf, timeout, connectToDnViaHostname);
        try {
            pathinfo = proxy.getBlockLocalPathInfo(blk, token);
            if (pathinfo != null && !storageType.isTransient()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cached location of block " + blk + " as " + pathinfo);
                }
                localDatanodeInfo.setBlockLocalPathInfo(blk, pathinfo);
            }
        }
        catch (IOException e) {
            localDatanodeInfo.resetDatanodeProxy();
            throw e;
        }
        return pathinfo;
    }

    private static int getSlowReadBufferNumChunks(int bufferSizeBytes, int bytesPerChecksum) {
        if (bufferSizeBytes < bytesPerChecksum) {
            throw new IllegalArgumentException("Configured BlockReaderLocalLegacy buffer size (" + bufferSizeBytes + ") is not large enough to hold " + "a single chunk (" + bytesPerChecksum + "). Please configure " + "dfs.client.read.shortcircuit.buffer.size" + " appropriately");
        }
        return bufferSizeBytes / bytesPerChecksum;
    }

    private BlockReaderLocalLegacy(DFSClient.Conf conf, String hdfsfile, ExtendedBlock block, Token<BlockTokenIdentifier> token, long startOffset, long length, BlockLocalPathInfo pathinfo, FileInputStream dataIn) throws IOException {
        this(conf, hdfsfile, block, token, startOffset, length, pathinfo, DataChecksum.newDataChecksum(DataChecksum.Type.NULL, 4), false, dataIn, startOffset, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockReaderLocalLegacy(DFSClient.Conf conf, String hdfsfile, ExtendedBlock block, Token<BlockTokenIdentifier> token, long startOffset, long length, BlockLocalPathInfo pathinfo, DataChecksum checksum, boolean verifyChecksum, FileInputStream dataIn, long firstChunkOffset, FileInputStream checksumIn) throws IOException {
        this.filename = hdfsfile;
        this.checksum = checksum;
        this.verifyChecksum = verifyChecksum;
        this.startOffset = Math.max(startOffset, 0L);
        this.blockId = block.getBlockId();
        this.bytesPerChecksum = this.checksum.getBytesPerChecksum();
        this.checksumSize = this.checksum.getChecksumSize();
        this.dataIn = dataIn;
        this.checksumIn = checksumIn;
        this.offsetFromChunkBoundary = (int)(startOffset - firstChunkOffset);
        int chunksPerChecksumRead = BlockReaderLocalLegacy.getSlowReadBufferNumChunks(conf.shortCircuitBufferSize, this.bytesPerChecksum);
        this.slowReadBuff = bufferPool.getBuffer(this.bytesPerChecksum * chunksPerChecksumRead);
        this.checksumBuff = bufferPool.getBuffer(this.checksumSize * chunksPerChecksumRead);
        this.slowReadBuff.flip();
        this.checksumBuff.flip();
        boolean success = false;
        try {
            IOUtils.skipFully(dataIn, firstChunkOffset);
            if (checksumIn != null) {
                long checkSumOffset = firstChunkOffset / (long)this.bytesPerChecksum * (long)this.checksumSize;
                IOUtils.skipFully(checksumIn, checkSumOffset);
            }
            success = true;
        }
        finally {
            if (!success) {
                bufferPool.returnBuffer(this.slowReadBuff);
                bufferPool.returnBuffer(this.checksumBuff);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fillBuffer(FileInputStream stream, ByteBuffer buf) throws IOException {
        try (TraceScope scope = Trace.startSpan("BlockReaderLocalLegacy#fillBuffer(" + this.blockId + ")", Sampler.NEVER);){
            int bytesRead = stream.getChannel().read(buf);
            if (bytesRead < 0) {
                int n = bytesRead;
                return n;
            }
            while (buf.remaining() > 0) {
                int n = stream.getChannel().read(buf);
                if (n < 0) {
                    int n2 = bytesRead;
                    return n2;
                }
                bytesRead += n;
            }
            int n = bytesRead;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSlice(ByteBuffer from, ByteBuffer to, int length) {
        int oldLimit = from.limit();
        from.limit(from.position() + length);
        try {
            to.put(from);
        }
        finally {
            from.limit(oldLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(ByteBuffer buf) throws IOException {
        int nRead = 0;
        if (this.verifyChecksum) {
            if (this.slowReadBuff.hasRemaining()) {
                int fromSlowReadBuff = Math.min(buf.remaining(), this.slowReadBuff.remaining());
                this.writeSlice(this.slowReadBuff, buf, fromSlowReadBuff);
                nRead += fromSlowReadBuff;
            }
            if (buf.remaining() >= this.bytesPerChecksum && this.offsetFromChunkBoundary == 0) {
                int len = buf.remaining() - buf.remaining() % this.bytesPerChecksum;
                len = Math.min(len, this.slowReadBuff.capacity());
                int oldlimit = buf.limit();
                buf.limit(buf.position() + len);
                int readResult = 0;
                try {
                    readResult = this.doByteBufferRead(buf);
                }
                finally {
                    buf.limit(oldlimit);
                }
                if (readResult == -1) {
                    return nRead;
                }
                nRead += readResult;
                buf.position(buf.position() + readResult);
            }
            if (buf.remaining() > 0 && buf.remaining() < this.bytesPerChecksum || this.offsetFromChunkBoundary > 0) {
                int toRead = Math.min(buf.remaining(), this.bytesPerChecksum - this.offsetFromChunkBoundary);
                int readResult = this.fillSlowReadBuffer(toRead);
                if (readResult == -1) {
                    return nRead;
                }
                int fromSlowReadBuff = Math.min(readResult, buf.remaining());
                this.writeSlice(this.slowReadBuff, buf, fromSlowReadBuff);
                nRead += fromSlowReadBuff;
            }
        } else {
            nRead = this.doByteBufferRead(buf);
            if (nRead > 0) {
                buf.position(buf.position() + nRead);
            }
        }
        return nRead;
    }

    private synchronized int doByteBufferRead(ByteBuffer buf) throws IOException {
        if (this.verifyChecksum) assert (buf.remaining() % this.bytesPerChecksum == 0);
        int dataRead = -1;
        int oldpos = buf.position();
        dataRead = this.fillBuffer(this.dataIn, buf);
        if (dataRead == -1) {
            return -1;
        }
        if (this.verifyChecksum) {
            ByteBuffer toChecksum = buf.duplicate();
            toChecksum.position(oldpos);
            toChecksum.limit(oldpos + dataRead);
            this.checksumBuff.clear();
            int numChunks = (toChecksum.remaining() + this.bytesPerChecksum - 1) / this.bytesPerChecksum;
            this.checksumBuff.limit(this.checksumSize * numChunks);
            this.fillBuffer(this.checksumIn, this.checksumBuff);
            this.checksumBuff.flip();
            this.checksum.verifyChunkedSums(toChecksum, this.checksumBuff, this.filename, this.startOffset);
        }
        if (dataRead >= 0) {
            buf.position(oldpos + Math.min(this.offsetFromChunkBoundary, dataRead));
        }
        if (dataRead < this.offsetFromChunkBoundary) {
            this.offsetFromChunkBoundary -= dataRead;
            dataRead = 0;
        } else {
            dataRead -= this.offsetFromChunkBoundary;
            this.offsetFromChunkBoundary = 0;
        }
        return dataRead;
    }

    private synchronized int fillSlowReadBuffer(int len) throws IOException {
        int nRead = -1;
        if (this.slowReadBuff.hasRemaining()) {
            nRead = Math.min(len, this.slowReadBuff.remaining());
        } else {
            int nextChunk = len + this.offsetFromChunkBoundary + (this.bytesPerChecksum - (len + this.offsetFromChunkBoundary) % this.bytesPerChecksum);
            int limit = Math.min(nextChunk, this.slowReadBuff.capacity());
            assert (limit % this.bytesPerChecksum == 0);
            this.slowReadBuff.clear();
            this.slowReadBuff.limit(limit);
            nRead = this.doByteBufferRead(this.slowReadBuff);
            if (nRead > 0) {
                this.slowReadBuff.limit(nRead + this.slowReadBuff.position());
            }
        }
        return nRead;
    }

    @Override
    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("read off " + off + " len " + len);
        }
        if (!this.verifyChecksum) {
            return this.dataIn.read(buf, off, len);
        }
        int nRead = this.fillSlowReadBuffer(this.slowReadBuff.capacity());
        if (nRead > 0) {
            nRead = Math.min(len, nRead);
            this.slowReadBuff.get(buf, off, nRead);
        }
        return nRead;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("skip " + n);
        }
        if (n <= 0L) {
            return 0L;
        }
        if (!this.verifyChecksum) {
            return this.dataIn.skip(n);
        }
        int remaining = this.slowReadBuff.remaining();
        int position = this.slowReadBuff.position();
        int newPosition = position + (int)n;
        if (n <= (long)remaining) {
            assert (this.offsetFromChunkBoundary == 0);
            this.slowReadBuff.position(newPosition);
            return n;
        }
        if (n - (long)remaining <= (long)this.bytesPerChecksum) {
            this.slowReadBuff.position(position + remaining);
            if (this.skipBuf == null) {
                this.skipBuf = new byte[this.bytesPerChecksum];
            }
            int ret = this.read(this.skipBuf, 0, (int)(n - (long)remaining));
            return remaining + ret;
        }
        int myOffsetFromChunkBoundary = newPosition % this.bytesPerChecksum;
        long toskip = n - (long)remaining - (long)myOffsetFromChunkBoundary;
        this.slowReadBuff.position(this.slowReadBuff.limit());
        this.checksumBuff.position(this.checksumBuff.limit());
        IOUtils.skipFully(this.dataIn, toskip);
        long checkSumOffset = toskip / (long)this.bytesPerChecksum * (long)this.checksumSize;
        IOUtils.skipFully(this.checksumIn, checkSumOffset);
        if (this.skipBuf == null) {
            this.skipBuf = new byte[this.bytesPerChecksum];
        }
        assert (this.skipBuf.length == this.bytesPerChecksum);
        assert (myOffsetFromChunkBoundary < this.bytesPerChecksum);
        int ret = this.read(this.skipBuf, 0, myOffsetFromChunkBoundary);
        if (ret == -1) {
            return toskip + (long)remaining;
        }
        return toskip + (long)remaining + (long)ret;
    }

    @Override
    public synchronized void close() throws IOException {
        IOUtils.cleanup(LOG, this.dataIn, this.checksumIn);
        if (this.slowReadBuff != null) {
            bufferPool.returnBuffer(this.slowReadBuff);
            this.slowReadBuff = null;
        }
        if (this.checksumBuff != null) {
            bufferPool.returnBuffer(this.checksumBuff);
            this.checksumBuff = null;
        }
        this.startOffset = -1L;
        this.checksum = null;
    }

    @Override
    public int readAll(byte[] buf, int offset, int len) throws IOException {
        return BlockReaderUtil.readAll(this, buf, offset, len);
    }

    @Override
    public void readFully(byte[] buf, int off, int len) throws IOException {
        BlockReaderUtil.readFully(this, buf, off, len);
    }

    @Override
    public int available() throws IOException {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isShortCircuit() {
        return true;
    }

    @Override
    public ClientMmap getClientMmap(EnumSet<ReadOption> opts) {
        return null;
    }

    private static class LocalDatanodeInfo {
        private ClientDatanodeProtocol proxy = null;
        private final Map<ExtendedBlock, BlockLocalPathInfo> cache;

        LocalDatanodeInfo() {
            int cacheSize = 10000;
            float hashTableLoadFactor = 0.75f;
            int hashTableCapacity = (int)Math.ceil(13333.3330078125) + 1;
            this.cache = Collections.synchronizedMap(new LinkedHashMap<ExtendedBlock, BlockLocalPathInfo>(hashTableCapacity, 0.75f, true){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<ExtendedBlock, BlockLocalPathInfo> eldest) {
                    return this.size() > 10000;
                }
            });
        }

        private synchronized ClientDatanodeProtocol getDatanodeProxy(UserGroupInformation ugi, final DatanodeInfo node, final Configuration conf, final int socketTimeout, final boolean connectToDnViaHostname) throws IOException {
            if (this.proxy == null) {
                try {
                    this.proxy = ugi.doAs(new PrivilegedExceptionAction<ClientDatanodeProtocol>(){

                        @Override
                        public ClientDatanodeProtocol run() throws Exception {
                            return DFSUtil.createClientDatanodeProtocolProxy(node, conf, socketTimeout, connectToDnViaHostname);
                        }
                    });
                }
                catch (InterruptedException e) {
                    LOG.warn("encountered exception ", e);
                }
            }
            return this.proxy;
        }

        private synchronized void resetDatanodeProxy() {
            if (null != this.proxy) {
                RPC.stopProxy(this.proxy);
                this.proxy = null;
            }
        }

        private BlockLocalPathInfo getBlockLocalPathInfo(ExtendedBlock b) {
            return this.cache.get(b);
        }

        private void setBlockLocalPathInfo(ExtendedBlock b, BlockLocalPathInfo info) {
            this.cache.put(b, info);
        }

        private void removeBlockLocalPathInfo(ExtendedBlock b) {
            this.cache.remove(b);
        }
    }
}

