/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import io.prestosql.hadoop.$internal.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class LocatedBlock {
    private final ExtendedBlock b;
    private long offset;
    private final DatanodeInfoWithStorage[] locs;
    private String[] storageIDs;
    private StorageType[] storageTypes;
    private boolean corrupt;
    private Token<BlockTokenIdentifier> blockToken = new Token();
    private DatanodeInfo[] cachedLocs;
    private static final DatanodeInfoWithStorage[] EMPTY_LOCS = new DatanodeInfoWithStorage[0];

    public LocatedBlock(ExtendedBlock b, DatanodeInfo[] locs) {
        this(b, locs, -1L, false);
    }

    public LocatedBlock(ExtendedBlock b, DatanodeInfo[] locs, long startOffset, boolean corrupt) {
        this(b, locs, null, null, startOffset, corrupt, EMPTY_LOCS);
    }

    public LocatedBlock(ExtendedBlock b, DatanodeStorageInfo[] storages) {
        this(b, storages, -1L, false);
    }

    public LocatedBlock(ExtendedBlock b, DatanodeInfo[] locs, String[] storageIDs, StorageType[] storageTypes) {
        this(b, locs, storageIDs, storageTypes, -1L, false, EMPTY_LOCS);
    }

    public LocatedBlock(ExtendedBlock b, DatanodeStorageInfo[] storages, long startOffset, boolean corrupt) {
        this(b, DatanodeStorageInfo.toDatanodeInfos(storages), DatanodeStorageInfo.toStorageIDs(storages), DatanodeStorageInfo.toStorageTypes(storages), startOffset, corrupt, EMPTY_LOCS);
    }

    public LocatedBlock(ExtendedBlock b, DatanodeInfo[] locs, String[] storageIDs, StorageType[] storageTypes, long startOffset, boolean corrupt, DatanodeInfo[] cachedLocs) {
        this.b = b;
        this.offset = startOffset;
        this.corrupt = corrupt;
        if (locs == null) {
            this.locs = EMPTY_LOCS;
        } else {
            this.locs = new DatanodeInfoWithStorage[locs.length];
            for (int i = 0; i < locs.length; ++i) {
                DatanodeInfoWithStorage storage;
                DatanodeInfo di = locs[i];
                this.locs[i] = storage = new DatanodeInfoWithStorage(di, storageIDs != null ? storageIDs[i] : null, storageTypes != null ? storageTypes[i] : null);
            }
        }
        this.storageIDs = storageIDs;
        this.storageTypes = storageTypes;
        this.cachedLocs = cachedLocs == null || cachedLocs.length == 0 ? EMPTY_LOCS : cachedLocs;
    }

    public Token<BlockTokenIdentifier> getBlockToken() {
        return this.blockToken;
    }

    public void setBlockToken(Token<BlockTokenIdentifier> token) {
        this.blockToken = token;
    }

    public ExtendedBlock getBlock() {
        return this.b;
    }

    public DatanodeInfo[] getLocations() {
        return this.locs;
    }

    public StorageType[] getStorageTypes() {
        return this.storageTypes;
    }

    public String[] getStorageIDs() {
        return this.storageIDs;
    }

    public void updateCachedStorageInfo() {
        int i;
        if (this.storageIDs != null) {
            for (i = 0; i < this.locs.length; ++i) {
                this.storageIDs[i] = this.locs[i].getStorageID();
            }
        }
        if (this.storageTypes != null) {
            for (i = 0; i < this.locs.length; ++i) {
                this.storageTypes[i] = this.locs[i].getStorageType();
            }
        }
    }

    public long getStartOffset() {
        return this.offset;
    }

    public long getBlockSize() {
        return this.b.getNumBytes();
    }

    void setStartOffset(long value) {
        this.offset = value;
    }

    void setCorrupt(boolean corrupt) {
        this.corrupt = corrupt;
    }

    public boolean isCorrupt() {
        return this.corrupt;
    }

    public void addCachedLoc(DatanodeInfo loc) {
        ArrayList<DatanodeInfo> cachedList = Lists.newArrayList(this.cachedLocs);
        if (cachedList.contains(loc)) {
            return;
        }
        for (DatanodeInfoWithStorage di : this.locs) {
            if (!loc.equals(di)) continue;
            cachedList.add(di);
            this.cachedLocs = cachedList.toArray(this.cachedLocs);
            return;
        }
        cachedList.add(loc);
        this.cachedLocs = cachedList.toArray(this.cachedLocs);
    }

    public DatanodeInfo[] getCachedLocations() {
        return this.cachedLocs;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.b + "; getBlockSize()=" + this.getBlockSize() + "; corrupt=" + this.corrupt + "; offset=" + this.offset + "; locs=" + Arrays.asList(this.locs) + "}";
    }
}

