/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineEditsViewer;

import io.prestosql.hadoop.$internal.org.apache.commons.cli.CommandLine;
import io.prestosql.hadoop.$internal.org.apache.commons.cli.OptionBuilder;
import io.prestosql.hadoop.$internal.org.apache.commons.cli.Options;
import io.prestosql.hadoop.$internal.org.apache.commons.cli.ParseException;
import io.prestosql.hadoop.$internal.org.apache.commons.cli.PosixParser;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsLoader;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsVisitor;
import org.apache.hadoop.hdfs.tools.offlineEditsViewer.OfflineEditsVisitorFactory;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class OfflineEditsViewer
extends Configured
implements Tool {
    private static final String defaultProcessor = "xml";

    private void printHelp() {
        String summary = "Usage: bin/hdfs oev [OPTIONS] -i INPUT_FILE -o OUTPUT_FILE\nOffline edits viewer\nParse a Hadoop edits log file INPUT_FILE and save results\nin OUTPUT_FILE.\nRequired command line arguments:\n-i,--inputFile <arg>   edits file to process, xml (case\n                       insensitive) extension means XML format,\n                       any other filename means binary format\n-o,--outputFile <arg>  Name of output file. If the specified\n                       file exists, it will be overwritten,\n                       format of the file is determined\n                       by -p option\n\nOptional command line arguments:\n-p,--processor <arg>   Select which type of processor to apply\n                       against image file, currently supported\n                       processors are: binary (native binary format\n                       that Hadoop uses), xml (default, XML\n                       format), stats (prints statistics about\n                       edits file)\n-h,--help              Display usage information and exit\n-f,--fix-txids         Renumber the transaction IDs in the input,\n                       so that there are no gaps or invalid                        transaction IDs.\n-r,--recover           When reading binary edit logs, use recovery \n                       mode.  This will give you the chance to skip \n                       corrupt parts of the edit log.\n-v,--verbose           More verbose output, prints the input and\n                       output filenames, for processors that write\n                       to a file, also output to screen. On large\n                       image files this will dramatically increase\n                       processing time (default is false).\n";
        System.out.println(summary);
        System.out.println();
        ToolRunner.printGenericCommandUsage(System.out);
    }

    public static Options buildOptions() {
        Options options = new Options();
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt("outputFilename");
        options.addOption(OptionBuilder.create("o"));
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt("inputFilename");
        options.addOption(OptionBuilder.create("i"));
        options.addOption("p", "processor", true, "");
        options.addOption("v", "verbose", false, "");
        options.addOption("f", "fix-txids", false, "");
        options.addOption("r", "recover", false, "");
        options.addOption("h", "help", false, "");
        return options;
    }

    public int go(String inputFileName, String outputFileName, String processor, Flags flags, OfflineEditsVisitor visitor) {
        if (flags.getPrintToScreen()) {
            System.out.println("input  [" + inputFileName + "]");
            System.out.println("output [" + outputFileName + "]");
        }
        try {
            if (visitor == null) {
                visitor = OfflineEditsVisitorFactory.getEditsVisitor(outputFileName, processor, flags.getPrintToScreen());
            }
            boolean xmlInput = inputFileName.endsWith(".xml");
            OfflineEditsLoader loader = OfflineEditsLoader.OfflineEditsLoaderFactory.createLoader(visitor, inputFileName, xmlInput, flags);
            loader.loadEdits();
        }
        catch (Exception e) {
            System.err.println("Encountered exception. Exiting: " + e.getMessage());
            e.printStackTrace(System.err);
            return -1;
        }
        return 0;
    }

    @Override
    public int run(String[] argv) throws Exception {
        CommandLine cmd;
        Options options = OfflineEditsViewer.buildOptions();
        if (argv.length == 0) {
            this.printHelp();
            return -1;
        }
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, argv);
        }
        catch (ParseException e) {
            System.out.println("Error parsing command-line options: " + e.getMessage());
            this.printHelp();
            return -1;
        }
        if (cmd.hasOption("h")) {
            this.printHelp();
            return -1;
        }
        String inputFileName = cmd.getOptionValue("i");
        String outputFileName = cmd.getOptionValue("o");
        String processor = cmd.getOptionValue("p");
        if (processor == null) {
            processor = defaultProcessor;
        }
        Flags flags = new Flags();
        if (cmd.hasOption("r")) {
            flags.setRecoveryMode();
        }
        if (cmd.hasOption("f")) {
            flags.setFixTxIds();
        }
        if (cmd.hasOption("v")) {
            flags.setPrintToScreen();
        }
        return this.go(inputFileName, outputFileName, processor, flags, null);
    }

    public static void main(String[] argv) throws Exception {
        int res = ToolRunner.run(new OfflineEditsViewer(), argv);
        System.exit(res);
    }

    public static class Flags {
        private boolean printToScreen = false;
        private boolean fixTxIds = false;
        private boolean recoveryMode = false;

        public boolean getPrintToScreen() {
            return this.printToScreen;
        }

        public void setPrintToScreen() {
            this.printToScreen = true;
        }

        public boolean getFixTxIds() {
            return this.fixTxIds;
        }

        public void setFixTxIds() {
            this.fixTxIds = true;
        }

        public boolean getRecoveryMode() {
            return this.recoveryMode;
        }

        public void setRecoveryMode() {
            this.recoveryMode = true;
        }
    }
}

