/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import io.prestosql.hadoop.$internal.org.apache.commons.logging.Log;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.filecache.ClientDistributedCacheManager;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class JobResourceUploader {
    protected static final Log LOG = LogFactory.getLog(JobResourceUploader.class);
    private FileSystem jtFs;

    JobResourceUploader(FileSystem submitFs) {
        this.jtFs = submitFs;
    }

    public void uploadFiles(Job job, Path submitJobDir) throws IOException {
        URI pathURI;
        Path newPath;
        Path tmp;
        URI tmpURI;
        Configuration conf = job.getConfiguration();
        short replication = (short)conf.getInt("mapreduce.client.submit.file.replication", 10);
        if (!conf.getBoolean("mapreduce.client.genericoptionsparser.used", false)) {
            LOG.warn("Hadoop command-line option parsing not performed. Implement the Tool interface and execute your application with ToolRunner to remedy this.");
        }
        String files = conf.get("tmpfiles");
        String libjars = conf.get("tmpjars");
        String archives = conf.get("tmparchives");
        String jobJar = job.getJar();
        LOG.debug("default FileSystem: " + this.jtFs.getUri());
        if (this.jtFs.exists(submitJobDir)) {
            throw new IOException("Not submitting job. Job directory " + submitJobDir + " already exists!! This is unexpected.Please check what's there in" + " that directory");
        }
        submitJobDir = this.jtFs.makeQualified(submitJobDir);
        submitJobDir = new Path(submitJobDir.toUri().getPath());
        FsPermission mapredSysPerms = new FsPermission(JobSubmissionFiles.JOB_DIR_PERMISSION);
        FileSystem.mkdirs(this.jtFs, submitJobDir, mapredSysPerms);
        Path filesDir = JobSubmissionFiles.getJobDistCacheFiles(submitJobDir);
        Path archivesDir = JobSubmissionFiles.getJobDistCacheArchives(submitJobDir);
        Path libjarsDir = JobSubmissionFiles.getJobDistCacheLibjars(submitJobDir);
        if (files != null) {
            String[] fileArr;
            FileSystem.mkdirs(this.jtFs, filesDir, mapredSysPerms);
            for (String tmpFile : fileArr = files.split(",")) {
                tmpURI = null;
                try {
                    tmpURI = new URI(tmpFile);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                tmp = new Path(tmpURI);
                newPath = this.copyRemoteFiles(filesDir, tmp, conf, replication);
                try {
                    pathURI = this.getPathURI(newPath, tmpURI.getFragment());
                    DistributedCache.addCacheFile(pathURI, conf);
                }
                catch (URISyntaxException ue) {
                    throw new IOException("Failed to create uri for " + tmpFile, ue);
                }
            }
        }
        if (libjars != null) {
            String[] libjarsArr;
            FileSystem.mkdirs(this.jtFs, libjarsDir, mapredSysPerms);
            for (String tmpjars : libjarsArr = libjars.split(",")) {
                Path tmp2 = new Path(tmpjars);
                Path newPath2 = this.copyRemoteFiles(libjarsDir, tmp2, conf, replication);
                DistributedCache.addFileToClassPath(new Path(newPath2.toUri().getPath()), conf, this.jtFs);
            }
        }
        if (archives != null) {
            String[] archivesArr;
            FileSystem.mkdirs(this.jtFs, archivesDir, mapredSysPerms);
            for (String tmpArchives : archivesArr = archives.split(",")) {
                try {
                    tmpURI = new URI(tmpArchives);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
                tmp = new Path(tmpURI);
                newPath = this.copyRemoteFiles(archivesDir, tmp, conf, replication);
                try {
                    pathURI = this.getPathURI(newPath, tmpURI.getFragment());
                    DistributedCache.addCacheArchive(pathURI, conf);
                }
                catch (URISyntaxException ue) {
                    throw new IOException("Failed to create uri for " + tmpArchives, ue);
                }
            }
        }
        if (jobJar != null) {
            Path jobJarPath;
            URI jobJarURI;
            if ("".equals(job.getJobName())) {
                job.setJobName(new Path(jobJar).getName());
            }
            if ((jobJarURI = (jobJarPath = new Path(jobJar)).toUri()).getScheme() == null || jobJarURI.getScheme().equals("file")) {
                this.copyJar(jobJarPath, JobSubmissionFiles.getJobJar(submitJobDir), replication);
                job.setJar(JobSubmissionFiles.getJobJar(submitJobDir).toString());
            }
        } else {
            LOG.warn("No job jar file set.  User classes may not be found. See Job or Job#setJar(String).");
        }
        this.addLog4jToDistributedCache(job, submitJobDir);
        ClientDistributedCacheManager.determineTimestampsAndCacheVisibilities(conf);
        ClientDistributedCacheManager.getDelegationTokens(conf, job.getCredentials());
    }

    private Path copyRemoteFiles(Path parentDir, Path originalPath, Configuration conf, short replication) throws IOException {
        FileSystem remoteFs = null;
        remoteFs = originalPath.getFileSystem(conf);
        if (this.compareFs(remoteFs, this.jtFs)) {
            return originalPath;
        }
        Path newPath = new Path(parentDir, originalPath.getName());
        FileUtil.copy(remoteFs, originalPath, this.jtFs, newPath, false, conf);
        this.jtFs.setReplication(newPath, replication);
        return newPath;
    }

    private boolean compareFs(FileSystem srcFs, FileSystem destFs) {
        URI srcUri = srcFs.getUri();
        URI dstUri = destFs.getUri();
        if (srcUri.getScheme() == null) {
            return false;
        }
        if (!srcUri.getScheme().equals(dstUri.getScheme())) {
            return false;
        }
        String srcHost = srcUri.getHost();
        String dstHost = dstUri.getHost();
        if (srcHost != null && dstHost != null) {
            try {
                srcHost = InetAddress.getByName(srcHost).getCanonicalHostName();
                dstHost = InetAddress.getByName(dstHost).getCanonicalHostName();
            }
            catch (UnknownHostException ue) {
                return false;
            }
            if (!srcHost.equals(dstHost)) {
                return false;
            }
        } else {
            if (srcHost == null && dstHost != null) {
                return false;
            }
            if (srcHost != null && dstHost == null) {
                return false;
            }
        }
        return srcUri.getPort() == dstUri.getPort();
    }

    private void copyJar(Path originalJarPath, Path submitJarFile, short replication) throws IOException {
        this.jtFs.copyFromLocalFile(originalJarPath, submitJarFile);
        this.jtFs.setReplication(submitJarFile, replication);
        this.jtFs.setPermission(submitJarFile, new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION));
    }

    private void addLog4jToDistributedCache(Job job, Path jobSubmitDir) throws IOException {
        Configuration conf = job.getConfiguration();
        String log4jPropertyFile = conf.get("mapreduce.job.log4j-properties-file", "");
        if (!log4jPropertyFile.isEmpty()) {
            short replication = (short)conf.getInt("mapreduce.client.submit.file.replication", 10);
            this.copyLog4jPropertyFile(job, jobSubmitDir, replication);
        }
    }

    private URI getPathURI(Path destPath, String fragment) throws URISyntaxException {
        URI pathURI = destPath.toUri();
        if (pathURI.getFragment() == null) {
            pathURI = fragment == null ? new URI(pathURI.toString() + "#" + destPath.getName()) : new URI(pathURI.toString() + "#" + fragment);
        }
        return pathURI;
    }

    private void copyLog4jPropertyFile(Job job, Path submitJobDir, short replication) throws IOException {
        Configuration conf = job.getConfiguration();
        String file = this.validateFilePath(conf.get("mapreduce.job.log4j-properties-file"), conf);
        LOG.debug("default FileSystem: " + this.jtFs.getUri());
        FsPermission mapredSysPerms = new FsPermission(JobSubmissionFiles.JOB_DIR_PERMISSION);
        if (!this.jtFs.exists(submitJobDir)) {
            throw new IOException("Cannot find job submission directory! It should just be created, so something wrong here.");
        }
        Path fileDir = JobSubmissionFiles.getJobLog4jFile(submitJobDir);
        if (file != null) {
            FileSystem.mkdirs(this.jtFs, fileDir, mapredSysPerms);
            URI tmpURI = null;
            try {
                tmpURI = new URI(file);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            Path tmp = new Path(tmpURI);
            Path newPath = this.copyRemoteFiles(fileDir, tmp, conf, replication);
            DistributedCache.addFileToClassPath(new Path(newPath.toUri().getPath()), conf);
        }
    }

    private String validateFilePath(String file, Configuration conf) throws IOException {
        String finalPath;
        URI pathURI;
        if (file == null) {
            return null;
        }
        if (file.isEmpty()) {
            throw new IllegalArgumentException("File name can't be empty string");
        }
        try {
            pathURI = new URI(file);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        Path path = new Path(pathURI);
        LocalFileSystem localFs = FileSystem.getLocal(conf);
        if (pathURI.getScheme() == null) {
            if (!localFs.exists(path)) {
                throw new FileNotFoundException("File " + file + " does not exist.");
            }
            finalPath = path.makeQualified(((FileSystem)localFs).getUri(), ((FileSystem)localFs).getWorkingDirectory()).toString();
        } else {
            FileSystem fs = path.getFileSystem(conf);
            if (!fs.exists(path)) {
                throw new FileNotFoundException("File " + file + " does not exist.");
            }
            finalPath = path.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString();
        }
        return finalPath;
    }
}

