/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import io.prestosql.hadoop.$internal.org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobInfoChange;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobInfoChangeEvent
implements HistoryEvent {
    private JobInfoChange datum = new JobInfoChange();

    public JobInfoChangeEvent(JobID id, long submitTime, long launchTime) {
        this.datum.jobid = new Utf8(id.toString());
        this.datum.submitTime = submitTime;
        this.datum.launchTime = launchTime;
    }

    JobInfoChangeEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (JobInfoChange)datum;
    }

    public JobID getJobId() {
        return JobID.forName(this.datum.jobid.toString());
    }

    public long getSubmitTime() {
        return this.datum.submitTime;
    }

    public long getLaunchTime() {
        return this.datum.launchTime;
    }

    @Override
    public EventType getEventType() {
        return EventType.JOB_INFO_CHANGED;
    }
}

