/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import io.prestosql.hadoop.$internal.org.apache.commons.logging.Log;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleScheduler;

class EventFetcher<K, V>
extends Thread {
    private static final long SLEEP_TIME = 1000L;
    private static final int MAX_RETRIES = 10;
    private static final int RETRY_PERIOD = 5000;
    private static final Log LOG = LogFactory.getLog(EventFetcher.class);
    private final TaskAttemptID reduce;
    private final TaskUmbilicalProtocol umbilical;
    private final ShuffleScheduler<K, V> scheduler;
    private int fromEventIdx = 0;
    private final int maxEventsToFetch;
    private final ExceptionReporter exceptionReporter;
    private volatile boolean stopped = false;

    public EventFetcher(TaskAttemptID reduce, TaskUmbilicalProtocol umbilical, ShuffleScheduler<K, V> scheduler, ExceptionReporter reporter, int maxEventsToFetch) {
        this.setName("EventFetcher for fetching Map Completion Events");
        this.setDaemon(true);
        this.reduce = reduce;
        this.umbilical = umbilical;
        this.scheduler = scheduler;
        this.exceptionReporter = reporter;
        this.maxEventsToFetch = maxEventsToFetch;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        int failures = 0;
        LOG.info(this.reduce + " Thread started: " + this.getName());
        try {
            while (!this.stopped && !Thread.currentThread().isInterrupted()) {
                try {
                    int numNewMaps = this.getMapCompletionEvents();
                    failures = 0;
                    if (numNewMaps > 0) {
                        LOG.info(this.reduce + ": " + "Got " + numNewMaps + " new map-outputs");
                    }
                    LOG.debug("GetMapEventsThread about to sleep for 1000");
                    if (Thread.currentThread().isInterrupted()) continue;
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOG.info("EventFetcher is interrupted.. Returning");
                    return;
                }
                catch (IOException ie) {
                    LOG.info("Exception in getting events", ie);
                    if (++failures >= 10) {
                        throw new IOException("too many failures downloading events", ie);
                    }
                    if (Thread.currentThread().isInterrupted()) continue;
                    Thread.sleep(5000L);
                }
            }
            return;
        }
        catch (InterruptedException e) {
            return;
        }
        catch (Throwable t) {
            this.exceptionReporter.reportException(t);
            return;
        }
    }

    public void shutDown() {
        this.stopped = true;
        this.interrupt();
        try {
            this.join(5000L);
        }
        catch (InterruptedException ie) {
            LOG.warn("Got interrupted while joining " + this.getName(), ie);
        }
    }

    protected int getMapCompletionEvents() throws IOException, InterruptedException {
        int numNewMaps = 0;
        TaskCompletionEvent[] events = null;
        do {
            MapTaskCompletionEventsUpdate update = this.umbilical.getMapCompletionEvents((JobID)this.reduce.getJobID(), this.fromEventIdx, this.maxEventsToFetch, (org.apache.hadoop.mapred.TaskAttemptID)this.reduce);
            events = update.getMapTaskCompletionEvents();
            LOG.debug("Got " + events.length + " map completion events from " + this.fromEventIdx);
            assert (!update.shouldReset()) : "Unexpected legacy state";
            this.fromEventIdx += events.length;
            for (TaskCompletionEvent event : events) {
                this.scheduler.resolve(event);
                if (TaskCompletionEvent.Status.SUCCEEDED != event.getTaskStatus()) continue;
                ++numNewMaps;
            }
        } while (events.length == this.maxEventsToFetch);
        return numNewMaps;
    }
}

