/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import io.prestosql.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.authentication.util.KerberosUtil;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class KerberosName {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosName.class);
    private final String serviceName;
    private final String hostName;
    private final String realm;
    private static final Pattern nameParser = Pattern.compile("([^/@]*)(/([^/@]*))?@([^/@]*)");
    private static Pattern parameterPattern = Pattern.compile("([^$]*)(\\$(\\d*))?");
    private static final Pattern ruleParser = Pattern.compile("\\s*((DEFAULT)|(RULE:\\[(\\d*):([^\\]]*)](\\(([^)]*)\\))?(s/([^/]*)/([^/]*)/(g)?)?))/?(L)?");
    private static final Pattern nonSimplePattern = Pattern.compile("[/@]");
    private static List<Rule> rules;
    private static String defaultRealm;

    @VisibleForTesting
    public static void resetDefaultRealm() {
        try {
            defaultRealm = KerberosUtil.getDefaultRealm();
        }
        catch (Exception ke) {
            LOG.debug("resetting default realm failed, current default realm will still be used.", ke);
        }
    }

    public KerberosName(String name) {
        Matcher match = nameParser.matcher(name);
        if (!match.matches()) {
            if (name.contains("@")) {
                throw new IllegalArgumentException("Malformed Kerberos name: " + name);
            }
            this.serviceName = name;
            this.hostName = null;
            this.realm = null;
        } else {
            this.serviceName = match.group(1);
            this.hostName = match.group(3);
            this.realm = match.group(4);
        }
    }

    public String getDefaultRealm() {
        return defaultRealm;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.serviceName);
        if (this.hostName != null) {
            result.append('/');
            result.append(this.hostName);
        }
        if (this.realm != null) {
            result.append('@');
            result.append(this.realm);
        }
        return result.toString();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getRealm() {
        return this.realm;
    }

    static List<Rule> parseRules(String rules) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        String remaining = rules.trim();
        while (remaining.length() > 0) {
            Matcher matcher = ruleParser.matcher(remaining);
            if (!matcher.lookingAt()) {
                throw new IllegalArgumentException("Invalid rule: " + remaining);
            }
            if (matcher.group(2) != null) {
                result.add(new Rule());
            } else {
                result.add(new Rule(Integer.parseInt(matcher.group(4)), matcher.group(5), matcher.group(7), matcher.group(9), matcher.group(10), "g".equals(matcher.group(11)), "L".equals(matcher.group(12))));
            }
            remaining = remaining.substring(matcher.end());
        }
        return result;
    }

    public String getShortName() throws IOException {
        String[] params;
        if (this.hostName == null) {
            if (this.realm == null) {
                return this.serviceName;
            }
            params = new String[]{this.realm, this.serviceName};
        } else {
            params = new String[]{this.realm, this.serviceName, this.hostName};
        }
        for (Rule r : rules) {
            String result = r.apply(params);
            if (result == null) continue;
            return result;
        }
        LOG.info("No auth_to_local rules applied to {}", (Object)this);
        return this.toString();
    }

    public static void setRules(String ruleString) {
        rules = ruleString != null ? KerberosName.parseRules(ruleString) : null;
    }

    public static String getRules() {
        String ruleString = null;
        if (rules != null) {
            StringBuilder sb = new StringBuilder();
            for (Rule rule : rules) {
                sb.append(rule.toString()).append("\n");
            }
            ruleString = sb.toString().trim();
        }
        return ruleString;
    }

    public static boolean hasRulesBeenSet() {
        return rules != null;
    }

    static void printRules() throws IOException {
        int i = 0;
        for (Rule r : rules) {
            System.out.println(++i + " " + r);
        }
    }

    static {
        try {
            defaultRealm = KerberosUtil.getDefaultRealm();
        }
        catch (Exception ke) {
            LOG.debug("Kerberos krb5 configuration not found, setting default realm to empty");
            defaultRealm = "";
        }
    }

    public static class NoMatchingRule
    extends IOException {
        NoMatchingRule(String msg) {
            super(msg);
        }
    }

    public static class BadFormatString
    extends IOException {
        BadFormatString(String msg) {
            super(msg);
        }

        BadFormatString(String msg, Throwable err) {
            super(msg, err);
        }
    }

    private static class Rule {
        private final boolean isDefault;
        private final int numOfComponents;
        private final String format;
        private final Pattern match;
        private final Pattern fromPattern;
        private final String toPattern;
        private final boolean repeat;
        private final boolean toLowerCase;

        Rule() {
            this.isDefault = true;
            this.numOfComponents = 0;
            this.format = null;
            this.match = null;
            this.fromPattern = null;
            this.toPattern = null;
            this.repeat = false;
            this.toLowerCase = false;
        }

        Rule(int numOfComponents, String format, String match, String fromPattern, String toPattern, boolean repeat, boolean toLowerCase) {
            this.isDefault = false;
            this.numOfComponents = numOfComponents;
            this.format = format;
            this.match = match == null ? null : Pattern.compile(match);
            this.fromPattern = fromPattern == null ? null : Pattern.compile(fromPattern);
            this.toPattern = toPattern;
            this.repeat = repeat;
            this.toLowerCase = toLowerCase;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.isDefault) {
                buf.append("DEFAULT");
            } else {
                buf.append("RULE:[");
                buf.append(this.numOfComponents);
                buf.append(':');
                buf.append(this.format);
                buf.append(']');
                if (this.match != null) {
                    buf.append('(');
                    buf.append(this.match);
                    buf.append(')');
                }
                if (this.fromPattern != null) {
                    buf.append("s/");
                    buf.append(this.fromPattern);
                    buf.append('/');
                    buf.append(this.toPattern);
                    buf.append('/');
                    if (this.repeat) {
                        buf.append('g');
                    }
                }
                if (this.toLowerCase) {
                    buf.append("/L");
                }
            }
            return buf.toString();
        }

        static String replaceParameters(String format, String[] params) throws BadFormatString {
            Matcher match = parameterPattern.matcher(format);
            int start = 0;
            StringBuilder result = new StringBuilder();
            while (start < format.length() && match.find(start)) {
                result.append(match.group(1));
                String paramNum = match.group(3);
                if (paramNum != null) {
                    try {
                        int num = Integer.parseInt(paramNum);
                        if (num < 0 || num > params.length) {
                            throw new BadFormatString("index " + num + " from " + format + " is outside of the valid range 0 to " + (params.length - 1));
                        }
                        result.append(params[num]);
                    }
                    catch (NumberFormatException nfe) {
                        throw new BadFormatString("bad format in username mapping in " + paramNum, nfe);
                    }
                }
                start = match.end();
            }
            return result.toString();
        }

        static String replaceSubstitution(String base, Pattern from, String to, boolean repeat) {
            Matcher match = from.matcher(base);
            if (repeat) {
                return match.replaceAll(to);
            }
            return match.replaceFirst(to);
        }

        String apply(String[] params) throws IOException {
            String result = null;
            if (this.isDefault) {
                if (defaultRealm.equals(params[0])) {
                    result = params[1];
                }
            } else if (params.length - 1 == this.numOfComponents) {
                String base = Rule.replaceParameters(this.format, params);
                if (this.match == null || this.match.matcher(base).matches()) {
                    result = this.fromPattern == null ? base : Rule.replaceSubstitution(base, this.fromPattern, this.toPattern, this.repeat);
                }
            }
            if (result != null && nonSimplePattern.matcher(result).find()) {
                LOG.info("Non-simple name {} after auth_to_local rule {}", (Object)result, (Object)this);
            }
            if (this.toLowerCase && result != null) {
                result = result.toLowerCase(Locale.ENGLISH);
            }
            return result;
        }
    }
}

