/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace;

import io.prestosql.hadoop.$internal.htrace.shaded.commons.logging.Log;
import io.prestosql.hadoop.$internal.htrace.shaded.commons.logging.LogFactory;
import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.htrace.Span;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.TraceInfo;
import org.apache.htrace.TraceScope;
import org.apache.htrace.impl.MilliSpan;

public class Tracer {
    public static final Log LOG = LogFactory.getLog(Tracer.class);
    private static final Random random = new SecureRandom();
    private final List<SpanReceiver> receivers = new CopyOnWriteArrayList<SpanReceiver>();
    private static final ThreadLocal<Span> currentSpan = new ThreadLocal<Span>(){

        @Override
        protected Span initialValue() {
            return null;
        }
    };
    public static final TraceInfo DONT_TRACE = new TraceInfo(-1L, -1L);
    protected static String processId = null;

    public static Tracer getInstance() {
        return TracerHolder.INSTANCE;
    }

    protected Span createNew(String description) {
        Span parent = currentSpan.get();
        if (parent == null) {
            return new MilliSpan(description, random.nextLong(), 477902L, random.nextLong(), Tracer.getProcessId());
        }
        return parent.child(description);
    }

    protected boolean isTracing() {
        return currentSpan.get() != null;
    }

    protected Span currentSpan() {
        return currentSpan.get();
    }

    public void deliver(Span span) {
        for (SpanReceiver receiver : this.receivers) {
            receiver.receiveSpan(span);
        }
    }

    protected void addReceiver(SpanReceiver receiver) {
        this.receivers.add(receiver);
    }

    protected void removeReceiver(SpanReceiver receiver) {
        this.receivers.remove(receiver);
    }

    protected Span setCurrentSpan(Span span) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("setting current span " + span);
        }
        currentSpan.set(span);
        return span;
    }

    public TraceScope continueSpan(Span s) {
        Span oldCurrent = this.currentSpan();
        this.setCurrentSpan(s);
        return new TraceScope(s, oldCurrent);
    }

    protected int numReceivers() {
        return this.receivers.size();
    }

    static String getProcessId() {
        if (processId == null) {
            String cmdLine = System.getProperty("sun.java.command");
            if (cmdLine != null && !cmdLine.isEmpty()) {
                String fullClassName = cmdLine.split("\\s+")[0];
                String[] classParts = fullClassName.split("\\.");
                cmdLine = classParts[classParts.length - 1];
            }
            processId = cmdLine == null || cmdLine.isEmpty() ? "Unknown" : cmdLine;
        }
        return processId;
    }

    private static class TracerHolder {
        private static final Tracer INSTANCE = new Tracer();

        private TracerHolder() {
        }
    }
}

