/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import com.google.api.client.auth.oauth2.TokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.extensions.java6.auth.oauth2.AuthorizationCodeInstalledApp;
import com.google.api.client.extensions.java6.auth.oauth2.FileCredentialStore;
import com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.compute.ComputeCredential;
import com.google.api.client.googleapis.extensions.java6.auth.oauth2.GooglePromptReceiver;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpBackOffIOExceptionHandler;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.json.webtoken.JsonWebToken;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.ObjectParser;
import com.google.api.client.util.PemReader;
import com.google.api.client.util.SecurityUtils;
import com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.List;

public class CredentialFactory {
    static final String CREDENTIAL_ENV_VAR = "GOOGLE_APPLICATION_CREDENTIALS";
    private static final String TOKEN_SERVER_URL_ENV_VAR = "GOOGLE_OAUTH_TOKEN_SERVER_URL";
    private static final String TOKEN_SERVER_URL_DEFAULT = "https://oauth2.googleapis.com/token";
    private static final String TOKEN_SERVER_URL = (String)MoreObjects.firstNonNull((Object)System.getenv("GOOGLE_OAUTH_TOKEN_SERVER_URL"), (Object)"https://oauth2.googleapis.com/token");
    public static final ImmutableList<String> GCS_SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/devstorage.full_control");
    public static final ImmutableList<String> DATASTORE_SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/datastore", (Object)"https://www.googleapis.com/auth/userinfo.email");
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private static HttpTransport staticHttpTransport = null;

    private static synchronized HttpTransport getStaticHttpTransport() throws IOException, GeneralSecurityException {
        if (staticHttpTransport == null) {
            staticHttpTransport = HttpTransportFactory.newTrustedTransport();
        }
        return staticHttpTransport;
    }

    public Credential getCredentialFromMetadataServiceAccount() throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("getCredentialFromMetadataServiceAccount()");
        ComputeCredentialWithRetry cred = new ComputeCredentialWithRetry(new ComputeCredential.Builder(CredentialFactory.getStaticHttpTransport(), JSON_FACTORY).setRequestInitializer((HttpRequestInitializer)new CredentialHttpRetryInitializer()));
        try {
            cred.refreshToken();
        }
        catch (IOException e) {
            throw new IOException("Error getting access token from metadata server at: " + cred.getTokenServerEncodedUrl(), e);
        }
        return cred;
    }

    public Credential getCredentialFromPrivateKeyServiceAccount(String serviceAccountEmail, String privateKeyFile, List<String> scopes, HttpTransport transport) throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("getCredentialFromPrivateKeyServiceAccount(%s, %s, %s)", (Object)serviceAccountEmail, (Object)privateKeyFile, scopes);
        return new GoogleCredentialWithRetry(new GoogleCredential.Builder().setTransport(transport).setJsonFactory(JSON_FACTORY).setServiceAccountId(serviceAccountEmail).setServiceAccountScopes(scopes).setServiceAccountPrivateKeyFromP12File(new File(privateKeyFile)).setRequestInitializer((HttpRequestInitializer)new CredentialHttpRetryInitializer()));
    }

    public Credential getCredentialFromJsonKeyFile(String serviceAccountJsonKeyFile, List<String> scopes, HttpTransport transport) throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("getCredentialFromJsonKeyFile(%s, %s)", (Object)serviceAccountJsonKeyFile, scopes);
        try (FileInputStream fis = new FileInputStream(serviceAccountJsonKeyFile);){
            GoogleCredentialWithRetry googleCredentialWithRetry = GoogleCredentialWithRetry.fromGoogleCredential(GoogleCredential.fromStream((InputStream)fis, (HttpTransport)transport, (JsonFactory)JSON_FACTORY).createScoped(scopes));
            return googleCredentialWithRetry;
        }
    }

    public Credential getCredentialsFromSAParameters(String privateKeyId, String privateKeyPem, String serviceAccountEmail, List<String> scopes, HttpTransport transport) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("getServiceAccountCredentialFromHadoopConfiguration(%s)", (Object)serviceAccountEmail);
        if (serviceAccountEmail == null || privateKeyPem == null || privateKeyId == null) {
            throw new IOException("Error reading service account credential from stream, expecting, 'client_email', 'private_key' and 'private_key_id'.");
        }
        PrivateKey privateKey = CredentialFactory.privateKeyFromPkcs8(privateKeyPem);
        GoogleCredential.Builder builder = new GoogleCredential.Builder().setTransport(transport).setJsonFactory(JSON_FACTORY).setServiceAccountId(serviceAccountEmail).setServiceAccountScopes(scopes).setServiceAccountPrivateKey(privateKey).setServiceAccountPrivateKeyId(privateKeyId);
        return new GoogleCredentialWithRetry(builder);
    }

    public Credential getCredentialFromFileCredentialStoreForInstalledApp(String clientId, String clientSecret, String filePath, List<String> scopes, HttpTransport transport) throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("getCredentialFromFileCredentialStoreForInstalledApp(%s, %s, %s, %s)", (Object)clientId, (Object)clientSecret, (Object)filePath, scopes);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)clientId) ? 1 : 0) != 0, (Object)"clientId must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)clientSecret) ? 1 : 0) != 0, (Object)"clientSecret must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)filePath) ? 1 : 0) != 0, (Object)"filePath must not be null or empty");
        Preconditions.checkNotNull(scopes, (Object)"scopes must not be null");
        GoogleClientSecrets.Details details = new GoogleClientSecrets.Details().setClientId(clientId).setClientSecret(clientSecret);
        GoogleClientSecrets clientSecrets = new GoogleClientSecrets().setInstalled(details);
        FileCredentialStore credentialStore = new FileCredentialStore(new File(filePath), JSON_FACTORY);
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder(transport, JSON_FACTORY, clientSecrets, scopes).setCredentialStore((CredentialStore)credentialStore).setRequestInitializer((HttpRequestInitializer)new CredentialHttpRetryInitializer()).setTokenServerUrl(new GenericUrl(TOKEN_SERVER_URL)).build();
        return new AuthorizationCodeInstalledApp((AuthorizationCodeFlow)flow, (VerificationCodeReceiver)new GooglePromptReceiver()).authorize("user");
    }

    @Deprecated
    public Credential getStorageCredential(String clientId, String clientSecret) throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("getStorageCredential(%s, %s)", (Object)clientId, (Object)clientSecret);
        String filePath = System.getProperty("user.home") + "/.credentials/storage.json";
        return this.getCredentialFromFileCredentialStoreForInstalledApp(clientId, clientSecret, filePath, (List<String>)GCS_SCOPES, CredentialFactory.getStaticHttpTransport());
    }

    @Deprecated
    public Credential getDatastoreCredential(String clientId, String clientSecret) throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("getStorageCredential(%s, %s)", (Object)clientId, (Object)clientSecret);
        String filePath = System.getProperty("user.home") + "/.credentials/datastore.json";
        return this.getCredentialFromFileCredentialStoreForInstalledApp(clientId, clientSecret, filePath, (List<String>)DATASTORE_SCOPES);
    }

    @Deprecated
    public Credential getCredentialFromPrivateKeyServiceAccount(String serviceAccountEmail, String privateKeyFile, List<String> scopes) throws IOException, GeneralSecurityException {
        return this.getCredentialFromPrivateKeyServiceAccount(serviceAccountEmail, privateKeyFile, scopes, CredentialFactory.getStaticHttpTransport());
    }

    @Deprecated
    public Credential getCredentialFromJsonKeyFile(String file, List<String> scopes) throws IOException, GeneralSecurityException {
        return this.getCredentialFromJsonKeyFile(file, scopes, CredentialFactory.getStaticHttpTransport());
    }

    @Deprecated
    public Credential getCredentialFromFileCredentialStoreForInstalledApp(String clientId, String clientSecret, String filePath, List<String> scopes) throws IOException, GeneralSecurityException {
        return this.getCredentialFromFileCredentialStoreForInstalledApp(clientId, clientSecret, filePath, scopes, CredentialFactory.getStaticHttpTransport());
    }

    boolean hasApplicationDefaultCredentialsConfigured() {
        return System.getenv(CREDENTIAL_ENV_VAR) != null;
    }

    public Credential getApplicationDefaultCredentials(List<String> scopes, HttpTransport transport) throws IOException, GeneralSecurityException {
        ((GoogleLogger.Api)logger.atFine()).log("getApplicationDefaultCredential(%s)", scopes);
        return GoogleCredentialWithRetry.fromGoogleCredential(GoogleCredential.getApplicationDefault((HttpTransport)transport, (JsonFactory)JSON_FACTORY).createScoped(scopes));
    }

    private static PrivateKey privateKeyFromPkcs8(String privateKeyPem) throws IOException {
        StringReader reader = new StringReader(privateKeyPem);
        PemReader.Section section = PemReader.readFirstSectionAndClose((Reader)reader, (String)"PRIVATE KEY");
        if (section == null) {
            throw new IOException("Invalid PKCS8 data.");
        }
        byte[] bytes = section.getBase64DecodedBytes();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        try {
            KeyFactory keyFactory = SecurityUtils.getRsaKeyFactory();
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException exception) {
            throw new IOException("Unexpected expcetion reading PKCS data", exception);
        }
    }

    public static class ComputeCredentialWithRetry
    extends ComputeCredential {
        public ComputeCredentialWithRetry(ComputeCredential.Builder builder) {
            super(builder);
        }

        protected TokenResponse executeRefreshToken() throws IOException {
            HttpRequest request = this.getTransport().createRequestFactory(this.getRequestInitializer()).buildGetRequest(new GenericUrl(this.getTokenServerEncodedUrl())).setParser((ObjectParser)new JsonObjectParser(this.getJsonFactory()));
            request.getHeaders().set("Metadata-Flavor", (Object)"Google");
            return (TokenResponse)request.execute().parseAs(TokenResponse.class);
        }
    }

    public static class GoogleCredentialWithRetry
    extends GoogleCredential {
        private static final int DEFAULT_TOKEN_EXPIRATION_SECONDS = 3600;

        public static GoogleCredentialWithRetry fromGoogleCredential(GoogleCredential credential) {
            GoogleCredential.Builder builder = new GoogleCredential.Builder().setServiceAccountPrivateKey(credential.getServiceAccountPrivateKey()).setServiceAccountPrivateKeyId(credential.getServiceAccountPrivateKeyId()).setServiceAccountId(credential.getServiceAccountId()).setServiceAccountUser(credential.getServiceAccountUser()).setServiceAccountScopes(credential.getServiceAccountScopes()).setTokenServerEncodedUrl(credential.getTokenServerEncodedUrl()).setTransport(credential.getTransport()).setClientAuthentication(credential.getClientAuthentication()).setJsonFactory(credential.getJsonFactory()).setClock(credential.getClock()).setRequestInitializer((HttpRequestInitializer)new CredentialHttpRetryInitializer());
            GoogleCredentialWithRetry withRetry = new GoogleCredentialWithRetry(builder);
            if (credential.getRefreshToken() != null) {
                withRetry.setRefreshToken(credential.getRefreshToken());
            }
            return withRetry;
        }

        public GoogleCredentialWithRetry(GoogleCredential.Builder builder) {
            super(builder.setTokenServerEncodedUrl(TOKEN_SERVER_URL));
        }

        protected TokenResponse executeRefreshToken() throws IOException {
            if (this.getServiceAccountPrivateKey() == null) {
                return super.executeRefreshToken();
            }
            JsonWebSignature.Header header = new JsonWebSignature.Header().setAlgorithm("RS256").setType("JWT").setKeyId(this.getServiceAccountPrivateKeyId());
            long currentTime = this.getClock().currentTimeMillis();
            JsonWebToken.Payload payload = new JsonWebToken.Payload().setIssuer(this.getServiceAccountId()).setAudience((Object)this.getTokenServerEncodedUrl()).setIssuedAtTimeSeconds(Long.valueOf(currentTime / 1000L)).setExpirationTimeSeconds(Long.valueOf(currentTime / 1000L + 3600L)).setSubject(this.getServiceAccountUser());
            payload.put("scope", (Object)Joiner.on((char)' ').join((Iterable)this.getServiceAccountScopes()));
            try {
                String assertion = JsonWebSignature.signUsingRsaSha256((PrivateKey)this.getServiceAccountPrivateKey(), (JsonFactory)this.getJsonFactory(), (JsonWebSignature.Header)header, (JsonWebToken.Payload)payload);
                TokenRequest request = new TokenRequest(this.getTransport(), this.getJsonFactory(), new GenericUrl(this.getTokenServerEncodedUrl()), "urn:ietf:params:oauth:grant-type:jwt-bearer").setRequestInitializer(this.getRequestInitializer());
                request.put("assertion", (Object)assertion);
                return request.execute();
            }
            catch (GeneralSecurityException exception) {
                throw (IOException)new IOException().initCause(exception);
            }
        }
    }

    public static class CredentialHttpRetryInitializer
    implements HttpRequestInitializer {
        public void initialize(HttpRequest httpRequest) throws IOException {
            httpRequest.setIOExceptionHandler((HttpIOExceptionHandler)new HttpBackOffIOExceptionHandler((BackOff)new ExponentialBackOff()));
            httpRequest.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)new HttpBackOffUnsuccessfulResponseHandler((BackOff)new ExponentialBackOff()));
        }
    }
}

