/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.jodd.cache;

import io.prestosql.hive.$internal.jodd.cache.LFUCache;
import io.prestosql.hive.$internal.jodd.io.FileUtil;
import java.io.File;
import java.io.IOException;

public class FileLFUCache {
    protected final LFUCache<File, byte[]> cache;
    protected final int maxSize;
    protected final int maxFileSize;
    protected int usedSize;

    public FileLFUCache(int maxSize) {
        this(maxSize, maxSize / 2, 0L);
    }

    public FileLFUCache(int maxSize, int maxFileSize) {
        this(maxSize, maxFileSize, 0L);
    }

    public FileLFUCache(int maxSize, int maxFileSize, long timeout) {
        this.cache = new LFUCache<File, byte[]>(0, timeout){

            @Override
            public boolean isFull() {
                return FileLFUCache.this.usedSize > FileLFUCache.this.maxSize;
            }

            @Override
            protected void onRemove(File key, byte[] cachedObject) {
                FileLFUCache.this.usedSize -= cachedObject.length;
            }
        };
        this.maxSize = maxSize;
        this.maxFileSize = maxFileSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getUsedSize() {
        return this.usedSize;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public int getCachedFilesCount() {
        return this.cache.size();
    }

    public long getCacheTimeout() {
        return this.cache.getCacheTimeout();
    }

    public void clear() {
        this.cache.clear();
        this.usedSize = 0;
    }

    public byte[] getFileBytes(String fileName) throws IOException {
        return this.getFileBytes(new File(fileName));
    }

    public byte[] getFileBytes(File file) throws IOException {
        byte[] bytes = (byte[])this.cache.get(file);
        if (bytes != null) {
            return bytes;
        }
        bytes = FileUtil.readBytes(file);
        if (this.maxFileSize != 0 && file.length() > (long)this.maxFileSize) {
            return bytes;
        }
        this.usedSize += bytes.length;
        this.cache.put(file, bytes);
        return bytes;
    }
}

