/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.jodd.typeconverter.impl;

import io.prestosql.hive.$internal.jodd.datetime.JDateTime;
import io.prestosql.hive.$internal.jodd.typeconverter.TypeConversionException;
import io.prestosql.hive.$internal.jodd.typeconverter.TypeConverter;
import io.prestosql.hive.$internal.jodd.util.StringUtil;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateConverter
implements TypeConverter<Date> {
    @Override
    public Date convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Calendar) {
            return new Date(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof JDateTime) {
            return ((JDateTime)value).convertToDate();
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        String stringValue = value.toString().trim();
        if (!StringUtil.containsOnlyDigits(stringValue)) {
            JDateTime jdt = new JDateTime(stringValue, "YYYY-MM-DD hh:mm:ss.mss");
            return jdt.convertToDate();
        }
        try {
            long milliseconds = Long.parseLong(stringValue);
            return new Date(milliseconds);
        }
        catch (NumberFormatException nfex) {
            throw new TypeConversionException(value, (Throwable)nfex);
        }
    }
}

