/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MaterializationsInvalidationCache;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;

public class MaterializationsCacheCleanerTask
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(MaterializationsCacheCleanerTask.class);
    private Configuration conf;

    @Override
    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.MATERIALIZATIONS_INVALIDATION_CACHE_CLEAN_FREQUENCY, unit);
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void run() {
        long removedCnt = MaterializationsInvalidationCache.get().cleanup(System.currentTimeMillis() - MetastoreConf.getTimeVar(this.conf, MetastoreConf.ConfVars.MATERIALIZATIONS_INVALIDATION_CACHE_EXPIRY_DURATION, TimeUnit.MILLISECONDS));
        if (removedCnt > 0L && LOG.isDebugEnabled()) {
            LOG.debug("Number of transaction entries deleted from materializations cache: " + removedCnt);
        }
    }
}

