/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import io.prestosql.hive.$internal.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.api.ClientCapabilities;
import org.apache.hadoop.hive.metastore.api.ClientCapability;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.InsertEventRequestData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.thrift.TException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class InsertEvent
extends ListenerEvent {
    private final Table tableObj;
    private final Partition ptnObj;
    private final boolean replace;
    private final List<String> files;
    private List<String> fileChecksums = new ArrayList<String>();

    public InsertEvent(String catName, String db, String table, List<String> partVals, InsertEventRequestData insertData, boolean status, IHMSHandler handler) throws MetaException, NoSuchObjectException {
        super(status, handler);
        GetTableRequest req = new GetTableRequest(db, table);
        req.setCatName(catName);
        req.setCapabilities(new ClientCapabilities(Lists.newArrayList(ClientCapability.TEST_CAPABILITY)));
        try {
            this.tableObj = handler.get_table_req(req).getTable();
            this.ptnObj = partVals != null ? handler.get_partition(MetaStoreUtils.prependNotNullCatToDbName(catName, db), table, partVals) : null;
        }
        catch (NoSuchObjectException e) {
            throw e;
        }
        catch (TException e) {
            throw MetaStoreUtils.newMetaException((Exception)((Object)e));
        }
        this.replace = insertData.isSetReplace() ? insertData.isReplace() : true;
        this.files = insertData.getFilesAdded();
        if (insertData.isSetFilesAddedChecksum()) {
            this.fileChecksums = insertData.getFilesAddedChecksum();
        }
    }

    public Table getTableObj() {
        return this.tableObj;
    }

    public Partition getPartitionObj() {
        return this.ptnObj;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public List<String> getFileChecksums() {
        return this.fileChecksums;
    }
}

