/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.plan.CopyWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.util.StringUtils;

public class CopyTask
extends Task<CopyWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Logger LOG = LoggerFactory.getLogger(CopyTask.class);

    @Override
    public int execute(DriverContext driverContext) {
        Path[] from = ((CopyWork)this.work).getFromPaths();
        Path[] to = ((CopyWork)this.work).getToPaths();
        for (int i = 0; i < from.length; ++i) {
            int result = this.copyOnePath(from[i], to[i]);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    protected int copyOnePath(Path fromPath, Path toPath) {
        FileSystem dstFs = null;
        try {
            Utilities.FILE_OP_LOGGER.trace("Copying data from {} to {} " + fromPath);
            this.console.printInfo("Copying data from " + fromPath.toString(), " to " + toPath.toString());
            FileSystem srcFs = fromPath.getFileSystem((Configuration)this.conf);
            dstFs = toPath.getFileSystem((Configuration)this.conf);
            FileStatus[] srcs = CopyTask.matchFilesOrDir(srcFs, fromPath, ((CopyWork)this.work).doSkipSourceMmDirs());
            if (srcs == null || srcs.length == 0) {
                if (((CopyWork)this.work).isErrorOnSrcEmpty()) {
                    this.console.printError("No files matching path: " + fromPath.toString());
                    return 3;
                }
                return 0;
            }
            if (!FileUtils.mkdir(dstFs, toPath, this.conf)) {
                this.console.printError("Cannot make target directory: " + toPath.toString());
                return 2;
            }
            for (FileStatus oneSrc : srcs) {
                String oneSrcPathStr = oneSrc.getPath().toString();
                this.console.printInfo("Copying file: " + oneSrcPathStr);
                Utilities.FILE_OP_LOGGER.debug("Copying file {} to {}", (Object)oneSrcPathStr, (Object)toPath);
                if (FileUtils.copy(srcFs, oneSrc.getPath(), dstFs, toPath, false, true, this.conf)) continue;
                this.console.printError("Failed to copy: '" + oneSrcPathStr + "to: '" + toPath.toString() + "'");
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            this.console.printError("Failed with exception " + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e));
            return 1;
        }
    }

    private static FileStatus[] matchFilesOrDir(FileSystem fs, Path path, boolean isSourceMm) throws IOException {
        if (!fs.exists(path)) {
            return null;
        }
        if (!isSourceMm) {
            return CopyTask.matchFilesOneDir(fs, path, null);
        }
        FileStatus[] mmDirs = fs.listStatus(path, (PathFilter)new AcidUtils.AnyIdDirFilter());
        if (mmDirs == null || mmDirs.length == 0) {
            return null;
        }
        ArrayList<FileStatus> allFiles = new ArrayList<FileStatus>();
        for (FileStatus mmDir : mmDirs) {
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("Found source MM directory " + mmDir.getPath());
            }
            CopyTask.matchFilesOneDir(fs, mmDir.getPath(), allFiles);
        }
        return allFiles.toArray(new FileStatus[allFiles.size()]);
    }

    private static FileStatus[] matchFilesOneDir(FileSystem fs, Path path, List<FileStatus> result) throws IOException {
        FileStatus[] srcs = fs.globStatus(path, (PathFilter)new EximPathFilter());
        if (srcs != null && srcs.length == 1 && srcs[0].isDirectory()) {
            srcs = fs.listStatus(srcs[0].getPath(), FileUtils.HIDDEN_FILES_PATH_FILTER);
        }
        if (result != null && srcs != null) {
            for (int i = 0; i < srcs.length; ++i) {
                result.add(srcs[i]);
            }
        }
        return srcs;
    }

    @Override
    public StageType getType() {
        return StageType.COPY;
    }

    @Override
    public String getName() {
        return "COPY";
    }

    private static final class EximPathFilter
    implements PathFilter {
        private EximPathFilter() {
        }

        public boolean accept(Path p) {
            String name = p.getName();
            return name.equals("_metadata") ? true : !name.startsWith("_") && !name.startsWith(".");
        }
    }
}

