/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OpTraits;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.fs.FSStatsPublisher;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public abstract class Operator<T extends OperatorDesc>
implements Serializable,
Cloneable,
Node {
    private static final long serialVersionUID = 1L;
    public static final String HIVE_COUNTER_CREATED_FILES = "CREATED_FILES";
    public static final String HIVE_COUNTER_CREATED_DYNAMIC_PARTITIONS = "CREATED_DYNAMIC_PARTITIONS";
    public static final String HIVE_COUNTER_FATAL = "FATAL_ERROR";
    public static final String CONTEXT_NAME_KEY = "__hive.context.name";
    private transient Configuration configuration;
    protected transient CompilationOpContext cContext;
    protected List<Operator<? extends OperatorDesc>> childOperators;
    protected List<Operator<? extends OperatorDesc>> parentOperators;
    protected String operatorId;
    protected final AtomicBoolean abortOp;
    private transient ExecMapperContext execContext;
    private transient boolean rootInitializeCalled = false;
    protected transient long numRows = 0L;
    protected transient long runTimeNumRows = 0L;
    protected int indexForTezUnion = -1;
    private transient Configuration hconf;
    protected final transient Collection<Future<?>> asyncInitOperations = new HashSet();
    protected int bucketingVersion = -1;
    protected transient State state = State.UNINIT;
    private boolean useBucketizedHiveInputFormat;
    private transient boolean multiChildren;
    private transient int[] selected;
    protected T conf;
    protected boolean done;
    private RowSchema rowSchema;
    protected transient Map<String, LongWritable> statsMap = new HashMap<String, LongWritable>();
    protected transient OutputCollector out;
    protected final transient Logger LOG = LoggerFactory.getLogger(this.getClass().getName());
    protected transient String alias;
    protected transient Reporter reporter;
    protected String id;
    protected transient ObjectInspector[] inputObjInspectors = new ObjectInspector[1];
    protected transient ObjectInspector outputObjInspector;
    private boolean jobCloseDone = false;
    protected transient Operator<? extends OperatorDesc>[] childOperatorsArray = null;
    protected transient int[] childOperatorsTag;
    protected transient Object groupKeyObject;

    protected Operator(String name, CompilationOpContext cContext) {
        this();
        this.cContext = cContext;
        this.id = name;
        this.initOperatorId();
    }

    protected Operator() {
        this.childOperators = new ArrayList<Operator<? extends OperatorDesc>>();
        this.parentOperators = new ArrayList<Operator<? extends OperatorDesc>>();
        this.abortOp = new AtomicBoolean(false);
    }

    public Operator(CompilationOpContext cContext) {
        this(String.valueOf(cContext.nextOperatorId()), cContext);
    }

    public void setChildOperators(List<Operator<? extends OperatorDesc>> childOperators) {
        if (childOperators == null) {
            childOperators = new ArrayList<Operator<? extends OperatorDesc>>();
        }
        this.childOperators = childOperators;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public List<Operator<? extends OperatorDesc>> getChildOperators() {
        return this.childOperators;
    }

    public int getNumChild() {
        return this.childOperators == null ? 0 : this.childOperators.size();
    }

    public ArrayList<Node> getChildren() {
        if (this.getChildOperators() == null) {
            return null;
        }
        ArrayList<Node> ret_vec = new ArrayList<Node>();
        for (Operator<OperatorDesc> op : this.getChildOperators()) {
            ret_vec.add(op);
        }
        return ret_vec;
    }

    public void setParentOperators(List<Operator<? extends OperatorDesc>> parentOperators) {
        if (parentOperators == null) {
            parentOperators = new ArrayList<Operator<? extends OperatorDesc>>();
        }
        this.parentOperators = parentOperators;
    }

    public List<Operator<? extends OperatorDesc>> getParentOperators() {
        return this.parentOperators;
    }

    public int getNumParent() {
        return this.parentOperators == null ? 0 : this.parentOperators.size();
    }

    public void setConf(T conf) {
        this.conf = conf;
    }

    @Explain
    public T getConf() {
        return this.conf;
    }

    public boolean getDone() {
        return this.done;
    }

    protected final void setDone(boolean done) {
        this.done = done;
    }

    public void setSchema(RowSchema rowSchema) {
        this.rowSchema = rowSchema;
    }

    public RowSchema getSchema() {
        return this.rowSchema;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIdentifier() {
        return this.id;
    }

    public void setReporter(Reporter rep) {
        this.reporter = rep;
        for (Operator<? extends OperatorDesc> op : this.childOperators) {
            op.setReporter(rep);
        }
    }

    public void setOutputCollector(OutputCollector out) {
        this.out = out;
        for (Operator<? extends OperatorDesc> op : this.childOperators) {
            op.setOutputCollector(out);
        }
    }

    public void setAlias(String alias) {
        this.alias = alias;
        for (Operator<? extends OperatorDesc> op : this.childOperators) {
            op.setAlias(alias);
        }
    }

    public Map<String, Long> getStats() {
        HashMap<String, Long> ret = new HashMap<String, Long>();
        for (String one : this.statsMap.keySet()) {
            ret.put(one, this.statsMap.get(one).get());
        }
        return ret;
    }

    protected boolean areAllParentsInitialized() {
        for (Operator<? extends OperatorDesc> parent : this.parentOperators) {
            if (parent == null || parent.state == State.INIT) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize(Configuration hconf, ObjectInspector[] inputOIs) throws HiveException {
        int i;
        this.done = false;
        this.runTimeNumRows = 0L;
        this.selected = new int[1024];
        if (this.state == State.INIT) {
            return;
        }
        this.configuration = hconf;
        if (!this.areAllParentsInitialized()) {
            return;
        }
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info("Initializing operator " + this);
        }
        if (inputOIs != null) {
            this.inputObjInspectors = inputOIs;
        }
        this.childOperatorsArray = new Operator[this.childOperators.size()];
        for (i = 0; i < this.childOperatorsArray.length; ++i) {
            this.childOperatorsArray[i] = this.childOperators.get(i);
        }
        this.multiChildren = this.childOperatorsArray.length > 1;
        this.childOperatorsTag = new int[this.childOperatorsArray.length];
        for (i = 0; i < this.childOperatorsArray.length; ++i) {
            List<Operator<OperatorDesc>> parentOperators = this.childOperatorsArray[i].getParentOperators();
            this.childOperatorsTag[i] = parentOperators.indexOf(this);
            if (this.childOperatorsTag[i] != -1) continue;
            throw new HiveException("Hive internal error: cannot find parent in the child operator!");
        }
        if (this.inputObjInspectors.length == 0) {
            throw new HiveException("Internal Error during operator initialization.");
        }
        this.outputObjInspector = this.inputObjInspectors[0];
        boolean isInitOk = false;
        try {
            this.initializeOp(hconf);
            if (!this.rootInitializeCalled || this.childOperatorsArray.length != this.childOperators.size()) {
                throw new AssertionError((Object)"Internal error during operator initialization");
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Initialization Done " + this.id + " " + this.getName());
            }
            this.initializeChildren(hconf);
            isInitOk = true;
        }
        finally {
            if (!isInitOk) {
                this.cancelAsyncInitOps();
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Initialization Done " + this.id + " " + this.getName() + " done is reset.");
        }
        this.completeInitialization(this.asyncInitOperations);
    }

    private void cancelAsyncInitOps() {
        for (Future<?> f : this.asyncInitOperations) {
            f.cancel(true);
        }
        this.asyncInitOperations.clear();
    }

    private void completeInitialization(Collection<Future<?>> fs) throws HiveException {
        Object[] os = new Object[fs.size()];
        int i = 0;
        Throwable asyncEx = null;
        boolean cancelAll = false;
        block4: for (Future<?> f : fs) {
            if (cancelAll) break;
            if (this.abortOp.get()) {
                cancelAll = true;
                break;
            }
            while (true) {
                if (this.abortOp.get()) {
                    cancelAll = true;
                    continue block4;
                }
                try {
                    Object futureResult = f.get(200L, TimeUnit.MILLISECONDS);
                    os[i++] = futureResult;
                    continue block4;
                }
                catch (TimeoutException futureResult) {
                    continue;
                }
                catch (InterruptedException | CancellationException e) {
                    asyncEx = e;
                    cancelAll = true;
                    continue block4;
                }
                catch (ExecutionException e) {
                    asyncEx = e.getCause() == null ? e : e.getCause();
                    cancelAll = true;
                    continue block4;
                }
                break;
            }
        }
        if (cancelAll || asyncEx != null) {
            for (Future<?> f : fs) {
                f.cancel(true);
            }
            throw new HiveException("Async Initialization failed. abortRequested=" + this.abortOp.get(), asyncEx);
        }
        this.completeInitializationOp(os);
    }

    protected void completeInitializationOp(Object[] os) throws HiveException {
    }

    public void initializeLocalWork(Configuration hconf) throws HiveException {
        if (this.childOperators != null) {
            for (int i = 0; i < this.childOperators.size(); ++i) {
                Operator<? extends OperatorDesc> childOp = this.childOperators.get(i);
                childOp.initializeLocalWork(hconf);
            }
        }
    }

    protected void initializeOp(Configuration hconf) throws HiveException {
        this.hconf = hconf;
        this.rootInitializeCalled = true;
    }

    public String getCounterName(Counter counter, Configuration hconf) {
        String context = hconf.get(CONTEXT_NAME_KEY, "");
        if (context != null && !context.isEmpty()) {
            context = "_" + context.replace(" ", "_");
        }
        return (Object)((Object)counter) + context;
    }

    protected void initializeChildren(Configuration hconf) throws HiveException {
        this.state = State.INIT;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Operator " + this.id + " " + this.getName() + " initialized");
        }
        if (this.childOperators == null || this.childOperators.isEmpty()) {
            return;
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Initializing children of " + this.id + " " + this.getName());
        }
        for (int i = 0; i < this.childOperatorsArray.length; ++i) {
            this.childOperatorsArray[i].initialize(hconf, this.outputObjInspector, this.childOperatorsTag[i]);
            if (this.reporter == null) continue;
            this.childOperatorsArray[i].setReporter(this.reporter);
        }
    }

    public void abort() {
        this.LOG.info("Received abort in operator: {}", (Object)this.getName());
        this.abortOp.set(true);
    }

    public void passExecContext(ExecMapperContext execContext) {
        this.setExecContext(execContext);
        for (int i = 0; i < this.childOperators.size(); ++i) {
            this.childOperators.get(i).passExecContext(execContext);
        }
    }

    protected void initialize(Configuration hconf, ObjectInspector inputOI, int parentId) throws HiveException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Initializing child " + this.id + " " + this.getName());
        }
        if (parentId >= this.inputObjInspectors.length) {
            int newLength;
            for (newLength = this.inputObjInspectors.length * 2; parentId >= newLength; newLength *= 2) {
            }
            this.inputObjInspectors = Arrays.copyOf(this.inputObjInspectors, newLength);
        }
        this.inputObjInspectors[parentId] = inputOI;
        this.initialize(hconf, null);
    }

    public ObjectInspector[] getInputObjInspectors() {
        return this.inputObjInspectors;
    }

    public void setInputObjInspectors(ObjectInspector[] inputObjInspectors) {
        this.inputObjInspectors = inputObjInspectors;
    }

    public ObjectInspector getOutputObjInspector() {
        return this.outputObjInspector;
    }

    public abstract void process(Object var1, int var2) throws HiveException;

    protected final void defaultStartGroup() throws HiveException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Starting group");
        }
        if (this.childOperators == null) {
            return;
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Starting group for children:");
        }
        for (Operator<? extends OperatorDesc> op : this.childOperators) {
            op.startGroup();
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Start group Done");
        }
    }

    protected final void defaultEndGroup() throws HiveException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Ending group");
        }
        if (this.childOperators == null) {
            return;
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Ending group for children:");
        }
        for (Operator<? extends OperatorDesc> op : this.childOperators) {
            op.endGroup();
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("End group Done");
        }
    }

    public void startGroup() throws HiveException {
        this.defaultStartGroup();
    }

    public void endGroup() throws HiveException {
        this.defaultEndGroup();
    }

    public void setNextVectorBatchGroupStatus(boolean isLastGroupBatch) throws HiveException {
    }

    public void flush() throws HiveException {
    }

    public void processGroup(int tag) throws HiveException {
        if (this.childOperators == null || this.childOperators.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.childOperatorsArray.length; ++i) {
            this.childOperatorsArray[i].processGroup(this.childOperatorsTag[i]);
        }
    }

    protected boolean allInitializedParentsAreClosed() {
        if (this.parentOperators != null) {
            for (Operator<? extends OperatorDesc> parent : this.parentOperators) {
                if (parent == null) continue;
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("allInitializedParentsAreClosed? parent.state = " + (Object)((Object)parent.state));
                }
                if (parent.state == State.CLOSE || parent.state == State.UNINIT) continue;
                return false;
            }
        }
        return true;
    }

    public void close(boolean abort) throws HiveException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("close called for operator " + this);
        }
        if (this.state == State.CLOSE) {
            return;
        }
        if (!this.allInitializedParentsAreClosed()) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Not all parent operators are closed. Not closing.");
            }
            return;
        }
        this.state = State.CLOSE;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.info("Closing operator " + this);
        }
        this.closeOp(abort |= this.abortOp.get());
        if (this.conf != null && this.conf.getRuntimeStatsTmpDir() != null) {
            this.publishRunTimeStats();
        }
        LongWritable runTimeRowsWritable = new LongWritable(this.runTimeNumRows);
        LongWritable recordCounter = new LongWritable(this.numRows);
        this.statsMap.put(Counter.RECORDS_OUT_OPERATOR.name() + "_" + this.getOperatorId(), runTimeRowsWritable);
        this.statsMap.put(this.getCounterName(Counter.RECORDS_OUT_INTERMEDIATE, this.hconf), recordCounter);
        this.runTimeNumRows = 0L;
        this.reporter = null;
        try {
            this.logStats();
            if (this.childOperators == null) {
                return;
            }
            for (Operator<? extends OperatorDesc> op : this.childOperators) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("Closing child = " + op);
                }
                op.close(abort);
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug(this.id + " Close done");
            }
        }
        catch (HiveException e) {
            this.LOG.warn("Caught exception while closing operator: " + e.getMessage(), e);
            throw e;
        }
    }

    protected void closeOp(boolean abort) throws HiveException {
    }

    public void jobCloseOp(Configuration conf, boolean success) throws HiveException {
    }

    public void jobClose(Configuration conf, boolean success) throws HiveException {
        if (this.jobCloseDone) {
            return;
        }
        this.jobCloseOp(conf, success);
        this.jobCloseDone = true;
        if (this.childOperators != null) {
            for (Operator<? extends OperatorDesc> op : this.childOperators) {
                op.jobClose(conf, success);
            }
        }
    }

    public void replaceChild(Operator<? extends OperatorDesc> child, Operator<? extends OperatorDesc> newChild) {
        int childIndex = this.childOperators.indexOf(child);
        assert (childIndex != -1);
        this.childOperators.set(childIndex, newChild);
    }

    public void removeChild(Operator<? extends OperatorDesc> child) {
        int childIndex = this.childOperators.indexOf(child);
        assert (childIndex != -1);
        if (this.childOperators.size() == 1) {
            this.setChildOperators(null);
        } else {
            this.childOperators.remove(childIndex);
        }
        int parentIndex = child.getParentOperators().indexOf(this);
        assert (parentIndex != -1);
        if (child.getParentOperators().size() == 1) {
            child.setParentOperators(null);
        } else {
            child.getParentOperators().remove(parentIndex);
        }
    }

    public void removeChildAndAdoptItsChildren(Operator<? extends OperatorDesc> child) throws SemanticException {
        int childIndex = this.childOperators.indexOf(child);
        if (childIndex == -1) {
            throw new SemanticException("Exception when trying to remove partition predicates: fail to find child from parent");
        }
        this.childOperators.remove(childIndex);
        if (child.getChildOperators() != null && child.getChildOperators().size() > 0) {
            this.childOperators.addAll(childIndex, child.getChildOperators());
        }
        for (Operator<OperatorDesc> gc : child.getChildOperators()) {
            List<Operator<OperatorDesc>> parents = gc.getParentOperators();
            int index = parents.indexOf(child);
            if (index == -1) {
                throw new SemanticException("Exception when trying to remove partition predicates: fail to find parent from child");
            }
            parents.set(index, this);
        }
    }

    public void removeParent(Operator<? extends OperatorDesc> parent) {
        int parentIndex = this.parentOperators.indexOf(parent);
        assert (parentIndex != -1);
        if (this.parentOperators.size() == 1) {
            this.setParentOperators(null);
        } else {
            this.parentOperators.remove(parentIndex);
        }
        int childIndex = parent.getChildOperators().indexOf(this);
        assert (childIndex != -1);
        if (parent.getChildOperators().size() == 1) {
            parent.setChildOperators(null);
        } else {
            parent.getChildOperators().remove(childIndex);
        }
    }

    public void replaceParent(Operator<? extends OperatorDesc> parent, Operator<? extends OperatorDesc> newParent) {
        int parentIndex = this.parentOperators.indexOf(parent);
        assert (parentIndex != -1);
        this.parentOperators.set(parentIndex, newParent);
    }

    protected long getNextCntr(long cntr) {
        if (cntr >= 1000000L) {
            return cntr + 1000000L;
        }
        return 10L * cntr;
    }

    protected void forward(Object row, ObjectInspector rowInspector) throws HiveException {
        this.forward(row, rowInspector, false);
    }

    protected void forward(VectorizedRowBatch vrg, ObjectInspector rowInspector) throws HiveException {
        this.forward(vrg, rowInspector, true);
    }

    protected void forward(Object row, ObjectInspector rowInspector, boolean isVectorized) throws HiveException {
        if (isVectorized) {
            this.vectorForward((VectorizedRowBatch)row, rowInspector);
        } else {
            this.baseForward(row, rowInspector);
        }
    }

    private void vectorForward(VectorizedRowBatch vrg, ObjectInspector rowInspector) throws HiveException {
        boolean saveState;
        this.runTimeNumRows += vrg.count();
        if (this.getDone()) {
            return;
        }
        int size = vrg.size;
        boolean selectedInUse = vrg.selectedInUse;
        boolean bl = saveState = selectedInUse && this.multiChildren;
        if (saveState) {
            System.arraycopy(vrg.selected, 0, this.selected, 0, size);
        }
        int childrenDone = 0;
        for (int i = 0; i < this.childOperatorsArray.length; ++i) {
            Operator<? extends OperatorDesc> o = this.childOperatorsArray[i];
            if (o.getDone()) {
                ++childrenDone;
                continue;
            }
            o.process(vrg, this.childOperatorsTag[i]);
            vrg.size = size;
            vrg.selectedInUse = selectedInUse;
            if (!saveState) continue;
            System.arraycopy(this.selected, 0, vrg.selected, 0, size);
        }
        if (childrenDone != 0 && childrenDone == this.childOperatorsArray.length) {
            this.setDone(true);
        }
    }

    private void baseForward(Object row, ObjectInspector rowInspector) throws HiveException {
        ++this.runTimeNumRows;
        if (this.getDone()) {
            return;
        }
        int childrenDone = 0;
        for (int i = 0; i < this.childOperatorsArray.length; ++i) {
            Operator<? extends OperatorDesc> o = this.childOperatorsArray[i];
            if (o.getDone()) {
                ++childrenDone;
                continue;
            }
            o.process(row, this.childOperatorsTag[i]);
        }
        if (childrenDone != 0 && childrenDone == this.childOperatorsArray.length) {
            this.setDone(true);
        }
    }

    public void reset() {
        this.state = State.INIT;
        if (this.childOperators != null) {
            for (Operator<? extends OperatorDesc> o : this.childOperators) {
                o.reset();
            }
        }
    }

    public void preorderMap(OperatorFunc opFunc) {
        opFunc.func(this);
        if (this.childOperators != null) {
            for (Operator<? extends OperatorDesc> o : this.childOperators) {
                o.preorderMap(opFunc);
            }
        }
    }

    public void logStats() {
        if (this.LOG.isInfoEnabled() && !this.statsMap.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, LongWritable> e : this.statsMap.entrySet()) {
                sb.append(e.getKey()).append(":").append(e.getValue()).append(", ");
            }
            this.LOG.info(sb.toString());
        }
    }

    @Override
    public abstract String getName();

    public static String getOperatorName() {
        return "OP";
    }

    public Map<String, ExprNodeDesc> getColumnExprMap() {
        if (this.getConf() == null) {
            return null;
        }
        return this.getConf().getColumnExprMap();
    }

    public void setColumnExprMap(Map<String, ExprNodeDesc> colExprMap) {
        if (this.getConf() != null) {
            this.getConf().setColumnExprMap(colExprMap);
        }
    }

    private String getLevelString(int level) {
        if (level == 0) {
            return "\n";
        }
        StringBuilder s = new StringBuilder();
        s.append("\n");
        while (level > 0) {
            s.append("  ");
            --level;
        }
        return s.toString();
    }

    public String dump(int level) {
        return this.dump(level, new HashSet<Integer>());
    }

    public String dump(int level, HashSet<Integer> seenOpts) {
        if (seenOpts.contains(new Integer(this.id))) {
            return null;
        }
        seenOpts.add(new Integer(this.id));
        StringBuilder s = new StringBuilder();
        String ls = this.getLevelString(level);
        s.append(ls);
        s.append("<" + this.getName() + ">");
        s.append("Id =" + this.id);
        if (this.childOperators != null) {
            s.append(ls);
            s.append("  <Children>");
            for (Operator<? extends OperatorDesc> o : this.childOperators) {
                s.append(o.dump(level + 2, seenOpts));
            }
            s.append(ls);
            s.append("  <\\Children>");
        }
        if (this.parentOperators != null) {
            s.append(ls);
            s.append("  <Parent>");
            for (Operator<? extends OperatorDesc> o : this.parentOperators) {
                s.append("Id = " + o.id + " ");
                s.append(o.dump(level, seenOpts));
            }
            s.append("<\\Parent>");
        }
        s.append(ls);
        s.append("<\\" + this.getName() + ">");
        return s.toString();
    }

    protected static ObjectInspector[] initEvaluators(ExprNodeEvaluator<?>[] evals, ObjectInspector rowInspector) throws HiveException {
        ObjectInspector[] result = new ObjectInspector[evals.length];
        for (int i = 0; i < evals.length; ++i) {
            result[i] = evals[i].initialize(rowInspector);
        }
        return result;
    }

    protected static ObjectInspector[] initEvaluators(ExprNodeEvaluator<?>[] evals, int start, int length, ObjectInspector rowInspector) throws HiveException {
        ObjectInspector[] result = new ObjectInspector[length];
        for (int i = 0; i < length; ++i) {
            result[i] = evals[start + i].initialize(rowInspector);
        }
        return result;
    }

    protected static StructObjectInspector initEvaluatorsAndReturnStruct(ExprNodeEvaluator<?>[] evals, List<String> outputColName, ObjectInspector rowInspector) throws HiveException {
        ObjectInspector[] fieldObjectInspectors = Operator.initEvaluators(evals, rowInspector);
        return ObjectInspectorFactory.getStandardStructObjectInspector(outputColName, Arrays.asList(fieldObjectInspectors));
    }

    public String getOperatorId() {
        return this.operatorId;
    }

    public void initOperatorId() {
        this.setOperatorId(this.getName() + "_" + this.id);
    }

    public void setOperatorId(String operatorId) {
        this.operatorId = operatorId;
    }

    protected List<String> getAdditionalCounters() {
        return null;
    }

    public abstract OperatorType getType();

    public void setGroupKeyObject(Object keyObject) {
        this.groupKeyObject = keyObject;
    }

    public Object getGroupKeyObject() {
        return this.groupKeyObject;
    }

    public void augmentPlan() {
    }

    public ExecMapperContext getExecContext() {
        return this.execContext;
    }

    public void setExecContext(ExecMapperContext execContext) {
        this.execContext = execContext;
    }

    public void cleanUpInputFileChanged() throws HiveException {
        this.cleanUpInputFileChangedOp();
        if (this.childOperators != null) {
            for (int i = 0; i < this.childOperators.size(); ++i) {
                Operator<? extends OperatorDesc> op = this.childOperators.get(i);
                op.cleanUpInputFileChanged();
            }
        }
    }

    public void cleanUpInputFileChangedOp() throws HiveException {
    }

    public void setInputContext(String tableName, String partitionName) {
        if (this.childOperators != null) {
            for (Operator<? extends OperatorDesc> child : this.childOperators) {
                if (child.getNumParent() != 1) continue;
                child.setInputContext(tableName, partitionName);
            }
        }
    }

    public boolean supportSkewJoinOptimization() {
        return false;
    }

    public Operator<? extends OperatorDesc> clone() throws CloneNotSupportedException {
        List<Operator<OperatorDesc>> parents = this.getParentOperators();
        ArrayList<Operator<? extends OperatorDesc>> parentClones = new ArrayList<Operator<? extends OperatorDesc>>();
        if (parents != null) {
            for (Operator<OperatorDesc> parent : parents) {
                parentClones.add((Operator<? extends OperatorDesc>)parent.clone());
            }
        }
        OperatorDesc descClone = (OperatorDesc)this.conf.clone();
        ArrayList<ColumnInfo> colInfos = new ArrayList<ColumnInfo>();
        colInfos.addAll(this.getSchema().getSignature());
        HashMap<String, ExprNodeDesc> map = null;
        if (this.getColumnExprMap() != null) {
            map = new HashMap<String, ExprNodeDesc>();
            map.putAll(this.getColumnExprMap());
        }
        Operator<OperatorDesc> ret = OperatorFactory.getAndMakeChild(this.cContext, descClone, new RowSchema(colInfos), map, parentClones);
        return ret;
    }

    public Operator<? extends OperatorDesc> cloneOp() throws CloneNotSupportedException {
        OperatorDesc descClone = (OperatorDesc)this.conf.clone();
        Operator<OperatorDesc> ret = OperatorFactory.getAndMakeChild(this.cContext, descClone, this.getSchema());
        return ret;
    }

    public Operator<? extends OperatorDesc> cloneRecursiveChildren() throws CloneNotSupportedException {
        Operator<OperatorDesc> newOp = this.cloneOp();
        newOp.setParentOperators(this.parentOperators);
        ArrayList<Operator<? extends OperatorDesc>> newChildren = new ArrayList<Operator<? extends OperatorDesc>>();
        for (Operator<OperatorDesc> childOp : this.getChildOperators()) {
            ArrayList<Operator<? extends OperatorDesc>> parentList = new ArrayList<Operator<? extends OperatorDesc>>();
            for (Operator<OperatorDesc> parent : childOp.getParentOperators()) {
                if (parent.equals(this)) {
                    parentList.add(newOp);
                    continue;
                }
                parentList.add(parent);
            }
            Operator<OperatorDesc> clonedChildOp = childOp.cloneRecursiveChildren();
            clonedChildOp.setParentOperators(parentList);
        }
        newOp.setChildOperators(newChildren);
        return newOp;
    }

    public boolean columnNamesRowResolvedCanBeObtained() {
        return false;
    }

    public boolean isUseBucketizedHiveInputFormat() {
        return this.useBucketizedHiveInputFormat;
    }

    public void setUseBucketizedHiveInputFormat(boolean useBucketizedHiveInputFormat) {
        this.useBucketizedHiveInputFormat = useBucketizedHiveInputFormat;
    }

    public boolean supportAutomaticSortMergeJoin() {
        return false;
    }

    public boolean supportUnionRemoveOptimization() {
        return false;
    }

    public boolean opAllowedBeforeMapJoin() {
        return true;
    }

    public boolean opAllowedAfterMapJoin() {
        return true;
    }

    public boolean opAllowedConvertMapJoin() {
        return true;
    }

    public boolean opAllowedBeforeSortMergeJoin() {
        return true;
    }

    public boolean acceptLimitPushdown() {
        return false;
    }

    public String toString() {
        return this.getName() + "[" + this.getIdentifier() + "]";
    }

    public static String toString(Collection<TableScanOperator> top) {
        StringBuilder builder = new StringBuilder();
        HashSet<String> visited = new HashSet<String>();
        for (Operator operator : top) {
            if (builder.length() > 0) {
                builder.append('\n');
            }
            Operator.toString(builder, visited, operator, 0);
        }
        return builder.toString();
    }

    static boolean toString(StringBuilder builder, Set<String> visited, Operator<?> op, int start) {
        String name = op.toString();
        boolean added = visited.add(name);
        if (start > 0) {
            builder.append("-");
            ++start;
        }
        builder.append(name);
        start += name.length();
        if (added) {
            if (op.getNumChild() > 0) {
                List<Operator<OperatorDesc>> children = op.getChildOperators();
                for (int i = 0; i < children.size(); ++i) {
                    if (i > 0) {
                        builder.append('\n');
                        for (int j = 0; j < start; ++j) {
                            builder.append(' ');
                        }
                    }
                    Operator.toString(builder, visited, children.get(i), start);
                }
            }
            return true;
        }
        return false;
    }

    public Statistics getStatistics() {
        if (this.conf != null) {
            return this.conf.getStatistics();
        }
        return null;
    }

    public OpTraits getOpTraits() {
        if (this.conf != null) {
            return this.conf.getTraits();
        }
        return null;
    }

    public void setOpTraits(OpTraits metaInfo) {
        if (this.LOG.isInfoEnabled()) {
            this.LOG.debug("Setting traits (" + metaInfo + ") on " + this);
        }
        if (this.conf != null) {
            this.conf.setTraits(metaInfo);
        } else {
            this.LOG.warn("Cannot set traits when there's no descriptor: " + this);
        }
    }

    public void setStatistics(Statistics stats) {
        if (this.LOG.isInfoEnabled()) {
            this.LOG.debug("Setting stats (" + stats + ") on " + this);
        }
        if (this.conf != null) {
            this.conf.setStatistics(stats);
        } else {
            this.LOG.warn("Cannot set stats when there's no descriptor: " + this);
        }
    }

    public static Operator createDummy() {
        return new DummyOperator();
    }

    public void removeParents() {
        for (Operator<OperatorDesc> parent : new ArrayList<Operator<OperatorDesc>>(this.getParentOperators())) {
            this.removeParent(parent);
        }
    }

    public boolean getIsReduceSink() {
        return false;
    }

    public String getReduceOutputName() {
        return null;
    }

    public void setCompilationOpContext(CompilationOpContext ctx) {
        this.cContext = ctx;
    }

    public CompilationOpContext getCompilationOpContext() {
        return this.cContext;
    }

    private void publishRunTimeStats() throws HiveException {
        FSStatsPublisher statsPublisher = new FSStatsPublisher();
        StatsCollectionContext sContext = new StatsCollectionContext(this.hconf);
        sContext.setIndexForTezUnion(this.indexForTezUnion);
        sContext.setStatsTmpDir(this.conf.getRuntimeStatsTmpDir());
        if (!statsPublisher.connect(sContext)) {
            this.LOG.error("StatsPublishing error: cannot connect to database");
            throw new HiveException(ErrorMsg.STATSPUBLISHER_CONNECTION_ERROR.getErrorCodedMsg());
        }
        String prefix = "";
        HashMap<String, String> statsToPublish = new HashMap<String, String>();
        statsToPublish.put("runTimeNumRows", Long.toString(this.runTimeNumRows));
        if (!statsPublisher.publishStat(prefix, statsToPublish)) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_PUBLISHING_ERROR.getErrorCodedMsg());
        }
        if (!statsPublisher.closeConnection(sContext)) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_CLOSING_ERROR.getErrorCodedMsg());
        }
    }

    public int getIndexForTezUnion() {
        return this.indexForTezUnion;
    }

    public void setIndexForTezUnion(int indexForTezUnion) {
        this.indexForTezUnion = indexForTezUnion;
    }

    public boolean logicalEquals(Operator other) {
        return this.getClass().getName().equals(other.getClass().getName()) && (this.conf == other.getConf() || this.conf != null && other.getConf() != null && this.conf.isSame((OperatorDesc)other.getConf()));
    }

    public final boolean logicalEqualsTree(Operator<?> o) {
        if (!this.logicalEquals(o)) {
            return false;
        }
        if (o.getNumParent() != this.getNumParent()) {
            return false;
        }
        for (int i = 0; i < this.getNumParent(); ++i) {
            Operator<? extends OperatorDesc> copR;
            Operator<? extends OperatorDesc> copL = this.parentOperators.get(i);
            if (copL.logicalEquals(copR = o.parentOperators.get(i))) continue;
            return false;
        }
        return true;
    }

    public void setBucketingVersion(int bucketingVersion) {
        this.bucketingVersion = bucketingVersion;
    }

    public int getBucketingVersion() {
        return this.bucketingVersion;
    }

    private static class DummyOperator
    extends Operator {
        public DummyOperator() {
            super("dummy", null);
        }

        @Override
        public void process(Object row, int tag) {
        }

        @Override
        public OperatorType getType() {
            return null;
        }

        @Override
        public String getName() {
            return DummyOperator.getOperatorName();
        }

        public static String getOperatorName() {
            return "DUMMY";
        }

        @Override
        protected void initializeOp(Configuration conf) {
        }
    }

    public static interface OperatorFunc {
        public void func(Operator<? extends OperatorDesc> var1);
    }

    public static enum Counter {
        RECORDS_OUT_OPERATOR,
        RECORDS_OUT_INTERMEDIATE;

    }

    public static enum State {
        UNINIT,
        INIT,
        CLOSE;

    }
}

