/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.mr;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.MapRedStats;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskHandle;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHook;
import org.apache.hadoop.hive.ql.exec.mr.JobDebugger;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.plan.ReducerTimeStatsPerJob;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.ClientStatsPublisher;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;

public class HadoopJobExecHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopJobExecHelper.class.getName());
    protected transient JobConf job;
    protected Task<? extends Serializable> task;
    protected transient int mapProgress = -1;
    protected transient int reduceProgress = -1;
    protected transient int lastMapProgress;
    protected transient int lastReduceProgress;
    public transient JobID jobId;
    private final SessionState.LogHelper console;
    private final HadoopJobExecHook callBackObj;
    private final String queryId;
    public static List<RunningJob> runningJobs = Collections.synchronizedList(new LinkedList());

    private void updateCounters(Counters ctrs, RunningJob rj) throws IOException {
        this.lastMapProgress = this.mapProgress;
        this.lastReduceProgress = this.reduceProgress;
        this.mapProgress = Math.round(rj.mapProgress() * 100.0f);
        this.mapProgress = this.mapProgress == 100 ? (int)Math.floor(rj.mapProgress() * 100.0f) : this.mapProgress;
        this.reduceProgress = Math.round(rj.reduceProgress() * 100.0f);
        this.reduceProgress = this.reduceProgress == 100 ? (int)Math.floor(rj.reduceProgress() * 100.0f) : this.reduceProgress;
        this.task.taskCounters.put("CNTR_NAME_" + this.task.getId() + "_MAP_PROGRESS", Long.valueOf(this.mapProgress));
        this.task.taskCounters.put("CNTR_NAME_" + this.task.getId() + "_REDUCE_PROGRESS", Long.valueOf(this.reduceProgress));
        if (SessionState.get() != null) {
            float progress = (rj.mapProgress() + rj.reduceProgress()) * 0.5f;
            SessionState.get().updateProgressedPercentage(progress);
        }
    }

    private static String getJobStartMsg(JobID jobId) {
        return "Starting Job = " + jobId;
    }

    public static String getJobEndMsg(JobID jobId) {
        return "Ended Job = " + jobId;
    }

    public boolean mapStarted() {
        return this.mapProgress > 0;
    }

    public boolean reduceStarted() {
        return this.reduceProgress > 0;
    }

    public boolean mapDone() {
        return this.mapProgress == 100;
    }

    public boolean reduceDone() {
        return this.reduceProgress == 100;
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public void setJobId(JobID jobId) {
        this.jobId = jobId;
    }

    public HadoopJobExecHelper(JobConf job, SessionState.LogHelper console, Task<? extends Serializable> task, HadoopJobExecHook hookCallBack) {
        this.queryId = HiveConf.getVar((Configuration)job, HiveConf.ConfVars.HIVEQUERYID, "unknown-" + System.currentTimeMillis());
        this.job = job;
        this.console = console;
        this.task = task;
        this.callBackObj = hookCallBack;
        if (job != null) {
            HiveConf.setVar((Configuration)job, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, "mr");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killRunningJobs() {
        List<RunningJob> list = runningJobs;
        synchronized (list) {
            for (RunningJob rj : runningJobs) {
                try {
                    System.err.println("killing job with: " + rj.getID());
                    rj.killJob();
                }
                catch (Exception e) {
                    LOG.warn("Failed to kill job", e);
                    System.err.println("Failed to kill job: " + rj.getID());
                }
            }
        }
    }

    public boolean checkFatalErrors(Counters ctrs, StringBuilder errMsg) {
        long upperLimit;
        if (ctrs == null) {
            return false;
        }
        Counters.Counter cntr = ctrs.findCounter(HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HIVECOUNTERGROUP), "CREATED_FILES");
        long numFiles = cntr != null ? cntr.getValue() : 0L;
        if (numFiles > (upperLimit = HiveConf.getLongVar((Configuration)this.job, HiveConf.ConfVars.MAXCREATEDFILES))) {
            errMsg.append("total number of created files now is " + numFiles + ", which exceeds ").append(upperLimit);
            return true;
        }
        return this.callBackObj.checkFatalErrors(ctrs, errMsg);
    }

    private MapRedStats progress(ExecDriverTaskHandle th) throws IOException, LockException {
        boolean success;
        long newCpuMSec;
        Counters.Counter counterCpuMsec;
        SessionState ss;
        Counters ctrs;
        JobClient jc = th.getJobClient();
        RunningJob rj = th.getRunningJob();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        long reportTime = System.currentTimeMillis();
        long maxReportInterval = HiveConf.getTimeVar((Configuration)this.job, HiveConf.ConfVars.HIVE_LOG_INCREMENTAL_PLAN_PROGRESS_INTERVAL, TimeUnit.MILLISECONDS);
        boolean fatal = false;
        StringBuilder errMsg = new StringBuilder();
        long pullInterval = HiveConf.getLongVar((Configuration)this.job, HiveConf.ConfVars.HIVECOUNTERSPULLINTERVAL);
        boolean initializing = true;
        boolean initOutputPrinted = false;
        long cpuMsec = -1L;
        int numMap = -1;
        int numReduce = -1;
        List<ClientStatsPublisher> clientStatPublishers = this.getClientStatPublishers();
        boolean localMode = ShimLoader.getHadoopShims().isLocalMode((Configuration)this.job);
        while (!rj.isComplete()) {
            long newCpuMSec2;
            Counters.Counter counterCpuMsec2;
            if (th.getContext() != null) {
                th.getContext().checkHeartbeaterLockException();
            }
            try {
                Thread.sleep(pullInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (initializing && rj.getJobState() == JobStatus.PREP) continue;
            initializing = false;
            if (!localMode) {
                RunningJob newRj;
                if (!initOutputPrinted) {
                    Object logReducer;
                    String logMapper;
                    SessionState ss2 = SessionState.get();
                    TaskReport[] mappers = jc.getMapTaskReports(rj.getID());
                    if (mappers == null) {
                        logMapper = "no information for number of mappers; ";
                    } else {
                        numMap = mappers.length;
                        if (ss2 != null) {
                            ss2.getHiveHistory().setTaskProperty(this.queryId, this.getId(), HiveHistory.Keys.TASK_NUM_MAPPERS, Integer.toString(numMap));
                        }
                        logMapper = "number of mappers: " + numMap + "; ";
                    }
                    TaskReport[] reducers = jc.getReduceTaskReports(rj.getID());
                    if (reducers == null) {
                        logReducer = "no information for number of reducers. ";
                    } else {
                        numReduce = reducers.length;
                        if (ss2 != null) {
                            ss2.getHiveHistory().setTaskProperty(this.queryId, this.getId(), HiveHistory.Keys.TASK_NUM_REDUCERS, Integer.toString(numReduce));
                        }
                        logReducer = "number of reducers: " + numReduce;
                    }
                    this.console.printInfo("Hadoop job information for " + this.getId() + ": " + logMapper + (String)logReducer);
                    initOutputPrinted = true;
                }
                if ((newRj = jc.getJob(rj.getID())) == null) {
                    throw new IOException("Could not find status of job:" + rj.getID());
                }
                th.setRunningJob(newRj);
                rj = newRj;
            }
            if (fatal) continue;
            ctrs = th.getCounters();
            fatal = this.checkFatalErrors(ctrs, errMsg);
            if (fatal) {
                this.console.printError("[Fatal Error] " + errMsg.toString() + ". Killing the job.");
                rj.killJob();
                continue;
            }
            errMsg.setLength(0);
            this.updateCounters(ctrs, rj);
            if (clientStatPublishers.size() > 0 && ctrs != null) {
                Map<String, Double> exctractedCounters = this.extractAllCounterValues(ctrs);
                for (ClientStatsPublisher clientStatPublisher : clientStatPublishers) {
                    try {
                        clientStatPublisher.run(exctractedCounters, rj.getID().toString());
                    }
                    catch (RuntimeException runtimeException) {
                        LOG.error("Exception " + runtimeException.getClass().getCanonicalName() + " thrown when running clientStatsPublishers. The stack trace is: ", runtimeException);
                    }
                }
            }
            if (this.mapProgress == this.lastMapProgress && this.reduceProgress == this.lastReduceProgress && System.currentTimeMillis() < reportTime + maxReportInterval) continue;
            StringBuilder report = new StringBuilder();
            report.append(dateFormat.format(Calendar.getInstance().getTime()));
            report.append(' ').append(this.getId());
            report.append(" map = ").append(this.mapProgress).append("%, ");
            report.append(" reduce = ").append(this.reduceProgress).append('%');
            if (ctrs != null && (counterCpuMsec2 = ctrs.findCounter("org.apache.hadoop.mapred.Task$Counter", "CPU_MILLISECONDS")) != null && (newCpuMSec2 = counterCpuMsec2.getValue()) > 0L) {
                cpuMsec = newCpuMSec2;
                report.append(", Cumulative CPU ").append((double)cpuMsec / 1000.0).append(" sec");
            }
            String output = report.toString();
            ss = SessionState.get();
            if (ss != null) {
                ss.getHiveHistory().setTaskCounters(this.queryId, this.getId(), ctrs);
                ss.getHiveHistory().setTaskProperty(this.queryId, this.getId(), HiveHistory.Keys.TASK_HADOOP_PROGRESS, output);
                if (ss.getConf().getBoolVar(HiveConf.ConfVars.HIVE_LOG_INCREMENTAL_PLAN_PROGRESS)) {
                    ss.getHiveHistory().progressTask(this.queryId, this.task);
                    this.callBackObj.logPlanProgress(ss);
                }
            }
            this.console.printInfo(output);
            this.task.setStatusMessage(output);
            reportTime = System.currentTimeMillis();
        }
        ctrs = th.getCounters();
        if (ctrs != null && (counterCpuMsec = ctrs.findCounter("org.apache.hadoop.mapred.Task$Counter", "CPU_MILLISECONDS")) != null && (newCpuMSec = counterCpuMsec.getValue()) > cpuMsec) {
            cpuMsec = newCpuMSec;
        }
        if (cpuMsec > 0L) {
            String status = "MapReduce Total cumulative CPU time: " + Utilities.formatMsecToStr(cpuMsec);
            this.console.printInfo(status);
            this.task.setStatusMessage(status);
        }
        if (fatal) {
            success = false;
        } else if (this.checkFatalErrors(ctrs, errMsg)) {
            this.console.printError("[Fatal Error] " + errMsg.toString());
            success = false;
        } else {
            SessionState ss3 = SessionState.get();
            if (ss3 != null) {
                ss3.getHiveHistory().setTaskCounters(this.queryId, this.getId(), ctrs);
            }
            success = rj.isSuccessful();
        }
        MapRedStats mapRedStats = new MapRedStats(numMap, numReduce, cpuMsec, success, rj.getID().toString());
        mapRedStats.setCounters(ctrs);
        this.updateCounters(ctrs, rj);
        ss = SessionState.get();
        if (ss != null) {
            this.callBackObj.logPlanProgress(ss);
        }
        return mapRedStats;
    }

    private String getId() {
        return this.task.getId();
    }

    public void jobInfo(RunningJob rj) {
        if (ShimLoader.getHadoopShims().isLocalMode((Configuration)this.job)) {
            this.console.printInfo("Job running in-process (local Hadoop)");
        } else {
            if (SessionState.get() != null) {
                SessionState.get().getHiveHistory().setTaskProperty(this.queryId, this.getId(), HiveHistory.Keys.TASK_HADOOP_ID, rj.getID().toString());
            }
            this.console.printInfo(HadoopJobExecHelper.getJobStartMsg(rj.getID()) + ", Tracking URL = " + rj.getTrackingURL());
            this.console.printInfo("Kill Command = " + HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.MAPREDBIN) + " job  -kill " + rj.getID());
        }
    }

    public void localJobDebugger(int exitVal, String taskId) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("Task failed!\n");
        sb.append("Task ID:\n  " + taskId + "\n\n");
        sb.append("Logs:\n");
        this.console.printError(sb.toString());
        for (Appender appender : ((org.apache.logging.log4j.core.Logger)LogManager.getRootLogger()).getAppenders().values()) {
            if (appender instanceof FileAppender) {
                this.console.printError(((FileAppender)appender).getFileName());
                continue;
            }
            if (!(appender instanceof RollingFileAppender)) continue;
            this.console.printError(((RollingFileAppender)appender).getFileName());
        }
    }

    public int progressLocal(Process runningJob, String taskId) {
        int exitVal = -101;
        try {
            exitVal = runningJob.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (exitVal != 0) {
            this.console.printError("Execution failed with exit status: " + exitVal);
            this.console.printError("Obtaining error information");
            if (HiveConf.getBoolVar((Configuration)this.job, HiveConf.ConfVars.SHOW_JOB_FAIL_DEBUG_INFO)) {
                this.localJobDebugger(exitVal, taskId);
            }
        } else {
            this.console.printInfo("Execution completed successfully");
            this.console.printInfo("MapredLocal task succeeded");
        }
        return exitVal;
    }

    public int progress(RunningJob rj, JobClient jc, Context ctx) throws IOException, LockException {
        this.jobId = rj.getID();
        int returnVal = 0;
        String pwd = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD);
        if (pwd != null) {
            HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD, "HIVE");
        }
        if (pwd != null) {
            HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD, pwd);
        }
        runningJobs.add(rj);
        ExecDriverTaskHandle th = new ExecDriverTaskHandle(jc, rj, ctx);
        this.jobInfo(rj);
        MapRedStats mapRedStats = this.progress(th);
        this.task.taskHandle = th;
        if (SessionState.get() != null) {
            SessionState.get().getMapRedStats().put(this.getId(), mapRedStats);
            if (this.task.getQueryPlan() != null) {
                this.computeReducerTimeStatsPerJob(rj);
            }
        }
        boolean success = mapRedStats.isSuccess();
        String statusMesg = HadoopJobExecHelper.getJobEndMsg(rj.getID());
        if (!success) {
            statusMesg = statusMesg + " with errors";
            returnVal = 2;
            this.console.printError(statusMesg);
            if (HiveConf.getBoolVar((Configuration)this.job, HiveConf.ConfVars.SHOW_JOB_FAIL_DEBUG_INFO) || HiveConf.getBoolVar((Configuration)this.job, HiveConf.ConfVars.JOB_DEBUG_CAPTURE_STACKTRACES)) {
                try {
                    JobDebugger jd = SessionState.get() != null ? new JobDebugger(this.job, rj, this.console, SessionState.get().getStackTraces()) : new JobDebugger(this.job, rj, this.console);
                    Thread t = new Thread(jd);
                    t.start();
                    t.join(HiveConf.getIntVar((Configuration)this.job, HiveConf.ConfVars.JOB_DEBUG_TIMEOUT));
                    this.task.setDiagnosticMessage(jd.getDiagnosticMesg());
                    int ec = jd.getErrorCode();
                    if (ec > 0) {
                        returnVal = ec;
                    }
                }
                catch (InterruptedException e) {
                    this.console.printError("Timed out trying to grab more detailed job failure information, please check jobtracker for more info");
                }
            }
        } else {
            this.console.printInfo(statusMesg);
        }
        return returnVal;
    }

    private void computeReducerTimeStatsPerJob(RunningJob rj) throws IOException {
        TaskCompletionEvent[] taskCompletions = rj.getTaskCompletionEvents(0);
        ArrayList<Integer> reducersRunTimes = new ArrayList<Integer>();
        for (TaskCompletionEvent taskCompletion : taskCompletions) {
            if (taskCompletion.isMapTask()) continue;
            reducersRunTimes.add(new Integer(taskCompletion.getTaskRunTime()));
        }
        ReducerTimeStatsPerJob reducerTimeStatsPerJob = new ReducerTimeStatsPerJob(reducersRunTimes);
        this.task.getQueryPlan().getReducerTimeStatsPerJobList().add(reducerTimeStatsPerJob);
    }

    private Map<String, Double> extractAllCounterValues(Counters counters) {
        HashMap<String, Double> exctractedCounters = new HashMap<String, Double>();
        for (Counters.Group cg : counters) {
            for (Counters.Counter c : cg) {
                exctractedCounters.put(cg.getName() + "::" + c.getName(), new Double(c.getCounter()));
            }
        }
        return exctractedCounters;
    }

    private List<ClientStatsPublisher> getClientStatPublishers() {
        String[] clientStatsPublisherClasses;
        ArrayList<ClientStatsPublisher> clientStatsPublishers = new ArrayList<ClientStatsPublisher>();
        String confString = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.CLIENTSTATSPUBLISHERS);
        if ((confString = confString.trim()).equals("")) {
            return clientStatsPublishers;
        }
        for (String clientStatsPublisherClass : clientStatsPublisherClasses = confString.split(",")) {
            try {
                clientStatsPublishers.add((ClientStatsPublisher)Class.forName(clientStatsPublisherClass.trim(), true, Utilities.getSessionSpecifiedClassLoader()).newInstance());
            }
            catch (Exception e) {
                LOG.warn(e.getClass().getName() + " occured when trying to create class: " + clientStatsPublisherClass.trim() + " implementing ClientStatsPublisher interface");
                LOG.warn("The exception message is: " + e.getMessage());
                LOG.warn("Program will continue, but without this ClientStatsPublisher working");
            }
        }
        return clientStatsPublishers;
    }

    static {
        ShutdownHookManager.addShutdownHook(new Runnable(){

            @Override
            public void run() {
                HadoopJobExecHelper.killRunningJobs();
            }
        });
    }

    private static class ExecDriverTaskHandle
    extends TaskHandle {
        JobClient jc;
        RunningJob rj;
        Context ctx;

        JobClient getJobClient() {
            return this.jc;
        }

        RunningJob getRunningJob() {
            return this.rj;
        }

        Context getContext() {
            return this.ctx;
        }

        public ExecDriverTaskHandle(JobClient jc, RunningJob rj, Context ctx) {
            this.jc = jc;
            this.rj = rj;
            this.ctx = ctx;
        }

        public void setRunningJob(RunningJob job) {
            this.rj = job;
        }

        @Override
        public Counters getCounters() throws IOException {
            return this.rj.getCounters();
        }
    }
}

