/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import io.prestosql.hive.$internal.com.google.common.base.Preconditions;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class LlapObjectSubCache<T> {
    private Object[] softReferenceList;
    private List<ReentrantLock> locks;

    private Object[] createSubCache(int numEntries) {
        return new Object[numEntries];
    }

    private List<ReentrantLock> createSubCacheLocks(int numEntries) {
        ArrayList<ReentrantLock> lockList = new ArrayList<ReentrantLock>();
        for (int i = 0; i < numEntries; ++i) {
            lockList.add(i, new ReentrantLock());
        }
        return lockList;
    }

    public LlapObjectSubCache(ObjectCache cache, String subCacheKey, int numEntries) throws HiveException {
        this.softReferenceList = cache.retrieve(subCacheKey + "_main", () -> this.createSubCache(numEntries));
        this.locks = cache.retrieve(subCacheKey + "_locks", () -> this.createSubCacheLocks(numEntries));
    }

    public void lock(int index) {
        this.locks.get(index).lock();
    }

    public void unlock(int index) {
        this.locks.get(index).unlock();
    }

    public T get(int index) {
        Preconditions.checkState(this.locks.get(index).isHeldByCurrentThread());
        if (this.softReferenceList[index] != null) {
            return ((SoftReference)this.softReferenceList[index]).get();
        }
        return null;
    }

    public void set(T value, int index) {
        Preconditions.checkState(this.locks.get(index).isHeldByCurrentThread());
        this.softReferenceList[index] = new SoftReference<T>(value);
    }
}

