/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.persistence.HybridHashTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.ObjectContainer;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.DataOutputBuffer;

public class VectorMapJoinBaseOperator
extends MapJoinOperator
implements VectorizationOperator,
VectorizationContextRegion {
    private static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinBaseOperator.class.getName());
    protected VectorizationContext vContext;
    protected VectorMapJoinDesc vectorDesc;
    private static final long serialVersionUID = 1L;
    protected VectorizationContext vOutContext;
    protected transient VectorizedRowBatch outputBatch;
    protected transient VectorizedRowBatch scratchBatch;
    protected transient Map<ObjectInspector, VectorAssignRow> outputVectorAssignRowMap;
    protected transient VectorizedRowBatchCtx vrbCtx = null;
    protected transient int tag;

    protected VectorMapJoinBaseOperator() {
    }

    public VectorMapJoinBaseOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinBaseOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        super(ctx);
        MapJoinDesc desc = (MapJoinDesc)conf;
        this.conf = desc;
        this.vContext = vContext;
        this.vectorDesc = (VectorMapJoinDesc)vectorDesc;
        this.order = desc.getTagOrder();
        this.numAliases = desc.getExprs().size();
        this.posBigTable = (byte)desc.getPosBigTable();
        this.filterMaps = desc.getFilterMap();
        this.noOuterJoin = desc.isNoOuterJoin();
        this.vOutContext = new VectorizationContext(this.getName(), desc.getOutputColumnNames(), vContext);
        this.vOutContext.setInitialTypeInfos(Arrays.asList(VectorMapJoinBaseOperator.getOutputTypeInfos(desc)));
    }

    @Override
    public VectorizationContext getInputVectorizationContext() {
        return this.vContext;
    }

    public static TypeInfo[] getOutputTypeInfos(MapJoinDesc desc) {
        TypeInfo[] outputTypeInfos;
        block11: {
            int smallTableOutputCount;
            int nextOutputColumn;
            int smallTableRetainSize;
            List<Integer> smallTableRetainList;
            List<ExprNodeDesc> smallTableExprs;
            block10: {
                int smallTableIndicesSize;
                int[] smallTableIndices;
                byte posBigTable = (byte)desc.getPosBigTable();
                List<ExprNodeDesc> keyDesc = desc.getKeys().get(posBigTable);
                List<ExprNodeDesc> bigTableExprs = desc.getExprs().get(posBigTable);
                Byte[] order = desc.getTagOrder();
                Byte posSingleVectorMapJoinSmallTable = order[0] == posBigTable ? order[1] : order[0];
                int outputColumnCount = desc.getOutputColumnNames().size();
                outputTypeInfos = new TypeInfo[outputColumnCount];
                List<Integer> bigTableRetainList = desc.getRetainList().get(posBigTable);
                int bigTableRetainSize = bigTableRetainList.size();
                smallTableExprs = desc.getExprs().get(posSingleVectorMapJoinSmallTable);
                if (desc.getValueIndices() != null && desc.getValueIndices().get(posSingleVectorMapJoinSmallTable) != null) {
                    smallTableIndices = desc.getValueIndices().get(posSingleVectorMapJoinSmallTable);
                    smallTableIndicesSize = smallTableIndices.length;
                } else {
                    smallTableIndices = null;
                    smallTableIndicesSize = 0;
                }
                smallTableRetainList = desc.getRetainList().get(posSingleVectorMapJoinSmallTable);
                smallTableRetainSize = smallTableRetainList.size();
                int smallTableResultSize = 0;
                if (smallTableIndicesSize > 0) {
                    smallTableResultSize = smallTableIndicesSize;
                } else if (smallTableRetainSize > 0) {
                    smallTableResultSize = smallTableRetainSize;
                }
                nextOutputColumn = order[0] == posBigTable ? 0 : smallTableResultSize;
                for (int i = 0; i < bigTableRetainSize; ++i) {
                    TypeInfo typeInfo;
                    outputTypeInfos[nextOutputColumn] = typeInfo = bigTableExprs.get(i).getTypeInfo();
                    ++nextOutputColumn;
                }
                int firstSmallTableOutputColumn = order[0] == posBigTable ? bigTableRetainSize : 0;
                smallTableOutputCount = 0;
                nextOutputColumn = firstSmallTableOutputColumn;
                if (smallTableIndicesSize <= 0) break block10;
                smallTableOutputCount = smallTableIndicesSize;
                for (int i = 0; i < smallTableIndicesSize; ++i) {
                    TypeInfo typeInfo;
                    if (smallTableIndices[i] >= 0) {
                        int keyIndex = smallTableIndices[i];
                        outputTypeInfos[nextOutputColumn] = typeInfo = keyDesc.get(keyIndex).getTypeInfo();
                    } else {
                        int smallTableValueIndex = -smallTableIndices[i] - 1;
                        outputTypeInfos[nextOutputColumn] = typeInfo = smallTableExprs.get(smallTableValueIndex).getTypeInfo();
                    }
                    ++nextOutputColumn;
                }
                break block11;
            }
            if (smallTableRetainSize <= 0) break block11;
            smallTableOutputCount = smallTableRetainSize;
            for (int i = 0; i < smallTableRetainSize; ++i) {
                TypeInfo typeInfo;
                int smallTableValueIndex = smallTableRetainList.get(i);
                outputTypeInfos[nextOutputColumn] = typeInfo = smallTableExprs.get(smallTableValueIndex).getTypeInfo();
                ++nextOutputColumn;
            }
        }
        return outputTypeInfos;
    }

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.vrbCtx = new VectorizedRowBatchCtx();
        this.vrbCtx.init((StructObjectInspector)this.outputObjInspector, this.vOutContext.getScratchColumnTypeNames(), this.vOutContext.getScratchDataTypePhysicalVariations());
        this.outputBatch = this.vrbCtx.createVectorizedRowBatch();
        this.outputVectorAssignRowMap = new HashMap<ObjectInspector, VectorAssignRow>();
    }

    @Override
    protected void internalForward(Object row, ObjectInspector outputOI) throws HiveException {
        Object[] values = (Object[])row;
        VectorAssignRow va = this.outputVectorAssignRowMap.get(outputOI);
        if (va == null) {
            va = new VectorAssignRow();
            va.init((StructObjectInspector)outputOI, this.vOutContext.getProjectedColumns());
            this.outputVectorAssignRowMap.put(outputOI, va);
        }
        va.assignRow(this.outputBatch, this.outputBatch.size, values);
        ++this.outputBatch.size;
        if (this.outputBatch.size == 1024) {
            this.flushOutput();
        }
    }

    private void flushOutput() throws HiveException {
        this.forward(this.outputBatch, null, true);
        this.outputBatch.reset();
    }

    @Override
    public void closeOp(boolean aborted) throws HiveException {
        super.closeOp(aborted);
        for (MapJoinTableContainer tableContainer : this.mapJoinTables) {
            if (tableContainer == null) continue;
            tableContainer.dumpMetrics();
        }
        if (!aborted && 0 < this.outputBatch.size) {
            this.flushOutput();
        }
    }

    @Override
    protected void reProcessBigTable(int partitionId) throws HiveException {
        if (this.scratchBatch == null) {
            return;
        }
        HybridHashTableContainer.HashPartition partition = this.firstSmallTable.getHashPartitions()[partitionId];
        ObjectContainer bigTable = partition.getMatchfileObjContainer();
        DataOutputBuffer dataOutputBuffer = new DataOutputBuffer();
        while (bigTable.hasNext()) {
            Object row = bigTable.next();
            VectorizedBatchUtil.addProjectedRowToBatchFrom(row, (StructObjectInspector)this.inputObjInspectors[this.posBigTable], this.scratchBatch.size, this.scratchBatch, dataOutputBuffer);
            ++this.scratchBatch.size;
            if (this.scratchBatch.size != 1024) continue;
            this.process(this.scratchBatch, this.tag);
            this.scratchBatch.reset();
            dataOutputBuffer.reset();
        }
        if (this.scratchBatch.size > 0) {
            this.process(this.scratchBatch, this.tag);
            this.scratchBatch.reset();
            dataOutputBuffer.reset();
        }
        bigTable.clear();
    }

    @Override
    public VectorizationContext getOutputVectorizationContext() {
        return this.vOutContext;
    }

    @Override
    public VectorDesc getVectorDesc() {
        return this.vectorDesc;
    }
}

