/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IsNull
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum;

    public IsNull(int colNum, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum = colNum;
    }

    public IsNull() {
        this.colNum = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        ColumnVector inputColVector = batch.cols[this.colNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        int n = batch.size;
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        long[] outputVector = outputColVector.vector;
        boolean[] outputIsNull = outputColVector.isNull;
        if (n <= 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector.noNulls) {
            outputColVector.isRepeating = true;
            outputIsNull[0] = false;
            outputVector[0] = 0L;
        } else if (inputColVector.isRepeating) {
            outputColVector.isRepeating = true;
            outputIsNull[0] = false;
            outputVector[0] = inputIsNull[0] ? 1L : 0L;
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputIsNull[i] = false;
                outputVector[i] = inputIsNull[i] ? 1L : 0L;
            }
        } else {
            Arrays.fill(outputIsNull, 0, n, false);
            for (int i = 0; i != n; ++i) {
                outputVector[i] = inputIsNull[i] ? 1L : 0L;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.ALL_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

