/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class DoubleScalarAddDoubleColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final double value;
    private final int colNum;

    public DoubleScalarAddDoubleColumn(double value, int colNum, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum = colNum;
        this.value = value;
    }

    public DoubleScalarAddDoubleColumn() {
        this.value = 0.0;
        this.colNum = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DoubleColumnVector inputColVector = (DoubleColumnVector)batch.cols[this.colNum];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        double[] vector = inputColVector.vector;
        double[] outputVector = outputColVector.vector;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                outputVector[0] = this.value + vector[0];
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            NullUtil.setNullOutputEntriesColScalar(outputColVector, batch.selectedInUse, sel, n);
            return;
        }
        if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputVector[i] = this.value + vector[i];
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = this.value + vector[i];
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.value + vector[i];
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = inputIsNull[i];
                    outputVector[i] = this.value + vector[i];
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.value + vector[i];
                }
            }
        }
        NullUtil.setNullOutputEntriesColScalar(outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public String vectorExpressionParameters() {
        return "val " + this.value + ", " + this.getColumnParamString(1, this.colNum);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("double"), VectorExpressionDescriptor.ArgumentType.getType("double")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.SCALAR, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

