/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import io.prestosql.hive.$internal.com.google.common.base.Preconditions;
import io.prestosql.hive.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.$internal.org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorLongSum
extends VectorPTFEvaluatorBase {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorPTFEvaluatorLongSum.class.getName();
    private static final Log LOG = LogFactory.getLog(CLASS_NAME);
    protected boolean isGroupResultNull;
    protected long sum;

    public VectorPTFEvaluatorLongSum(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch, boolean isLastGroupBatch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState(!batch.selectedInUse);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        LongColumnVector longColVector = (LongColumnVector)batch.cols[this.inputColumnNum];
        if (longColVector.isRepeating) {
            if (longColVector.noNulls || !longColVector.isNull[0]) {
                if (this.isGroupResultNull) {
                    this.sum = longColVector.vector[0] * (long)batch.size;
                    this.isGroupResultNull = false;
                } else {
                    this.sum += longColVector.vector[0] * (long)batch.size;
                }
            }
        } else if (longColVector.noNulls) {
            long[] vector = longColVector.vector;
            long varSum = vector[0];
            for (int i = 1; i < size; ++i) {
                varSum += vector[i];
            }
            if (this.isGroupResultNull) {
                this.sum = varSum;
                this.isGroupResultNull = false;
            } else {
                this.sum += varSum;
            }
        } else {
            boolean[] batchIsNull = longColVector.isNull;
            int i = 0;
            while (batchIsNull[i]) {
                if (++i < size) continue;
                return;
            }
            long[] vector = longColVector.vector;
            long varSum = vector[i++];
            while (i < size) {
                if (!batchIsNull[i]) {
                    varSum += vector[i];
                }
                ++i;
            }
            if (this.isGroupResultNull) {
                this.sum = varSum;
                this.isGroupResultNull = false;
            } else {
                this.sum += varSum;
            }
        }
    }

    @Override
    public boolean isGroupResultNull() {
        return this.isGroupResultNull;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.LONG;
    }

    @Override
    public long getLongGroupResult() {
        return this.sum;
    }

    @Override
    public void resetEvaluator() {
        this.isGroupResultNull = true;
        this.sum = 0L;
    }
}

