/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import io.prestosql.hive.$internal.com.google.protobuf.MessageLite;
import io.prestosql.hive.$internal.com.google.protobuf.Parser;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.ql.hooks.ProtoMessageReader;
import org.apache.hadoop.hive.ql.hooks.ProtoMessageWriter;
import org.apache.hadoop.yarn.util.Clock;

public class DatePartitionedLogger<T extends MessageLite> {
    private static final FsPermission DIR_PERMISSION = FsPermission.createImmutable((short)1023);
    private final Parser<T> parser;
    private final Path basePath;
    private final Configuration conf;
    private final Clock clock;
    private final FileSystem fileSystem;

    public DatePartitionedLogger(Parser<T> parser, Path baseDir, Configuration conf, Clock clock) throws IOException {
        this.conf = conf;
        this.clock = clock;
        this.parser = parser;
        this.fileSystem = baseDir.getFileSystem(conf);
        if (!this.fileSystem.exists(baseDir)) {
            this.fileSystem.mkdirs(baseDir);
            this.fileSystem.setPermission(baseDir, DIR_PERMISSION);
        }
        this.basePath = this.fileSystem.resolvePath(baseDir);
    }

    public ProtoMessageWriter<T> getWriter(String fileName) throws IOException {
        Path filePath = this.getPathForDate(this.getNow().toLocalDate(), fileName);
        return new ProtoMessageWriter<T>(this.conf, filePath, this.parser);
    }

    public ProtoMessageReader<T> getReader(Path filePath) throws IOException {
        return new ProtoMessageReader<T>(this.conf, filePath, this.parser);
    }

    public Path getPathForDate(LocalDate date, String fileName) throws IOException {
        Path path = new Path(this.basePath, this.getDirForDate(date));
        if (!this.fileSystem.exists(path)) {
            this.fileSystem.mkdirs(path);
            this.fileSystem.setPermission(path, DIR_PERMISSION);
        }
        return new Path(path, fileName);
    }

    public LocalDate getDateFromDir(String dirName) {
        if (!dirName.startsWith("date=")) {
            throw new IllegalArgumentException("Invalid directory: " + dirName);
        }
        return LocalDate.parse(dirName.substring(5), DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public String getDirForDate(LocalDate date) {
        return "date=" + DateTimeFormatter.ISO_LOCAL_DATE.format(date);
    }

    public String getNextDirectory(String currentDir) throws IOException {
        String nextDate = this.getDirForDate(this.getDateFromDir(currentDir).plusDays(1L));
        if (this.fileSystem.exists(new Path(this.basePath, nextDate))) {
            return nextDate;
        }
        String dirName = null;
        for (FileStatus status : this.fileSystem.listStatus(this.basePath)) {
            String name = status.getPath().getName();
            if (name.compareTo(currentDir) <= 0 || dirName != null && name.compareTo(dirName) >= 0) continue;
            dirName = name;
        }
        return dirName;
    }

    public List<Path> scanForChangedFiles(String subDir, Map<String, Long> currentOffsets) throws IOException {
        Path dirPath = new Path(this.basePath, subDir);
        ArrayList<Path> newFiles = new ArrayList<Path>();
        if (!this.fileSystem.exists(dirPath)) {
            return newFiles;
        }
        for (FileStatus status : this.fileSystem.listStatus(dirPath)) {
            String fileName = status.getPath().getName();
            Long offset = currentOffsets.get(fileName);
            if (offset != null && offset >= status.getLen()) continue;
            newFiles.add(new Path(dirPath, fileName));
        }
        return newFiles;
    }

    public LocalDateTime getNow() {
        return LocalDateTime.ofEpochSecond(this.clock.getTime() / 1000L, 0, ZoneOffset.UTC);
    }

    public Configuration getConfig() {
        return this.conf;
    }
}

