/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import io.prestosql.hive.$internal.com.google.common.collect.ArrayListMultimap;
import io.prestosql.hive.$internal.com.google.common.collect.HashMultimap;
import io.prestosql.hive.$internal.com.google.common.collect.ListMultimap;
import io.prestosql.hive.$internal.com.google.common.collect.SetMultimap;
import io.prestosql.hive.$internal.com.google.common.collect.Sets;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.rel.RelNode;

public class HiveRulesRegistry {
    private SetMultimap<RelOptRule, RelNode> registryVisited = HashMultimap.create();
    private ListMultimap<RelNode, Set<String>> registryPushedPredicates = ArrayListMultimap.create();

    public void registerVisited(RelOptRule rule, RelNode operator) {
        this.registryVisited.put(rule, operator);
    }

    public Set<RelNode> getVisited(RelOptRule rule) {
        return this.registryVisited.get(rule);
    }

    public Set<String> getPushedPredicates(RelNode operator, int pos) {
        if (!this.registryPushedPredicates.containsKey(operator)) {
            for (int i = 0; i < operator.getInputs().size(); ++i) {
                this.registryPushedPredicates.get(operator).add(Sets.newHashSet());
            }
        }
        return this.registryPushedPredicates.get(operator).get(pos);
    }

    public void copyPushedPredicates(RelNode operator, RelNode otherOperator) {
        if (this.registryPushedPredicates.containsKey(operator)) {
            for (Set<String> s : this.registryPushedPredicates.get(operator)) {
                this.registryPushedPredicates.put(otherOperator, Sets.newHashSet(s));
            }
        }
    }
}

