/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.util.ControlFlowException;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;

public class MaterializedViewRewritingRelVisitor
extends RelVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(MaterializedViewRewritingRelVisitor.class);
    private boolean containsAggregate = false;
    private boolean rewritingAllowed = false;

    public void visit(RelNode node, int ordinal, RelNode parent) {
        if (node instanceof Aggregate) {
            this.containsAggregate = true;
            RelNode input = node.getInput(0);
            if (input instanceof Union) {
                this.check((Union)input);
            }
        } else if (node instanceof Union) {
            this.check((Union)node);
        } else if (node instanceof Project) {
            super.visit(node, ordinal, parent);
        }
        throw new ReturnedValue(false);
    }

    private void check(Union union) {
        if (union.getInputs().size() != 2) {
            throw new ReturnedValue(false);
        }
        new RelVisitor(){

            public void visit(RelNode node, int ordinal, RelNode parent) {
                if (node instanceof TableScan || node instanceof Filter || node instanceof Project || node instanceof Join) {
                    super.visit(node, ordinal, parent);
                } else if (node instanceof Aggregate && MaterializedViewRewritingRelVisitor.this.containsAggregate) {
                    super.visit(node, ordinal, parent);
                } else {
                    throw new ReturnedValue(false);
                }
            }
        }.go(union.getInput(0));
        new RelVisitor(){

            public void visit(RelNode node, int ordinal, RelNode parent) {
                if (node instanceof TableScan) {
                    RelOptHiveTable hiveTable = (RelOptHiveTable)node.getTable();
                    if (!hiveTable.getHiveTableMD().isMaterializedView()) {
                        throw new ReturnedValue(false);
                    }
                    if (MaterializedViewRewritingRelVisitor.this.containsAggregate && !AcidUtils.isFullAcidTable(hiveTable.getHiveTableMD())) {
                        throw new ReturnedValue(false);
                    }
                } else if (node instanceof Project) {
                    super.visit(node, ordinal, parent);
                } else {
                    throw new ReturnedValue(false);
                }
            }
        }.go(union.getInput(1));
        throw new ReturnedValue(true);
    }

    public RelNode go(RelNode p) {
        try {
            this.visit(p, 0, null);
        }
        catch (ReturnedValue e) {
            this.rewritingAllowed = e.value;
        }
        return p;
    }

    public boolean isContainsAggregate() {
        return this.containsAggregate;
    }

    public boolean isRewritingAllowed() {
        return this.rewritingAllowed;
    }

    private static class ReturnedValue
    extends ControlFlowException {
        private final boolean value;

        public ReturnedValue(boolean value) {
            this.value = value;
        }
    }
}

