/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.Set;
import javax.annotation.Nullable;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.dump.TableExport;
import org.apache.hadoop.hive.ql.plan.ExportWork;

public class ExportSemanticAnalyzer
extends BaseSemanticAnalyzer {
    ExportSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        this.rootTasks.add(ExportSemanticAnalyzer.analyzeExport(ast, null, this.db, this.conf, this.inputs, this.outputs));
    }

    static Task<ExportWork> analyzeExport(ASTNode ast, @Nullable String acidTableName, Hive db, HiveConf conf, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
        BaseSemanticAnalyzer.TableSpec ts;
        Tree tableTree = ast.getChild(0);
        Tree toTree = ast.getChild(1);
        ReplicationSpec replicationSpec = ast.getChildCount() > 2 ? new ReplicationSpec((ASTNode)ast.getChild(2)) : new ReplicationSpec();
        if (replicationSpec.getCurrentReplicationState() == null) {
            try {
                long currentEventId = db.getMSC().getCurrentNotificationEventId().getEventId();
                replicationSpec.setCurrentReplicationState(String.valueOf(currentEventId));
            }
            catch (Exception e) {
                throw new SemanticException("Error when getting current notification event ID", e);
            }
        }
        try {
            ts = new BaseSemanticAnalyzer.TableSpec(db, conf, (ASTNode)tableTree, false, true);
        }
        catch (SemanticException sme) {
            if (replicationSpec.isInReplicationScope() && (sme.getCause() instanceof InvalidTableException || sme instanceof Table.ValidationFailureSemanticException)) {
                ts = null;
            }
            throw sme;
        }
        String tmpPath = ExportSemanticAnalyzer.stripQuotes(toTree.getText());
        TableExport.Paths exportPaths = new TableExport.Paths(ErrorMsg.INVALID_PATH.getMsg(ast), tmpPath, conf, false);
        TableExport tableExport = new TableExport(exportPaths, ts, replicationSpec, db, null, conf);
        TableExport.AuthEntities authEntities = tableExport.getAuthEntities();
        inputs.addAll(authEntities.inputs);
        outputs.addAll(authEntities.outputs);
        String exportRootDirName = tmpPath;
        ExportWork exportWork = new ExportWork(exportRootDirName, ts, replicationSpec, ErrorMsg.INVALID_PATH.getMsg(ast), acidTableName);
        return TaskFactory.get(exportWork);
    }
}

