/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.HashMap;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSQRewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MaterializedViewRebuildSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;

public final class SemanticAnalyzerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SemanticAnalyzerFactory.class);
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(QueryState queryState, ASTNode tree) throws SemanticException {
        BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.getInternal(queryState, tree);
        if (queryState.getHiveOperation() == null) {
            String query = queryState.getQueryString();
            if (query != null && query.length() > 30) {
                query = query.substring(0, 30);
            }
            String msg = "Unknown HiveOperation for query='" + query + "' queryId=" + queryState.getQueryId();
            LOG.debug(msg);
        }
        return sem;
    }

    private static BaseSemanticAnalyzer getInternal(QueryState queryState, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        HiveOperation opType = commandType.get(tree.getType());
        queryState.setCommandType(opType);
        switch (tree.getType()) {
            case 833: {
                return new ExplainSemanticAnalyzer(queryState);
            }
            case 834: {
                return new ExplainSQRewriteSemanticAnalyzer(queryState);
            }
            case 891: {
                return new LoadSemanticAnalyzer(queryState);
            }
            case 836: {
                if (UpdateDeleteSemanticAnalyzer.isAcidExport(tree)) {
                    return new UpdateDeleteSemanticAnalyzer(queryState);
                }
                return new ExportSemanticAnalyzer(queryState);
            }
            case 860: {
                return new ImportSemanticAnalyzer(queryState);
            }
            case 969: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 970: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 971: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 721: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 722: 
                    case 723: 
                    case 724: 
                    case 725: 
                    case 730: 
                    case 731: 
                    case 732: 
                    case 733: 
                    case 737: 
                    case 738: 
                    case 739: 
                    case 740: 
                    case 741: 
                    case 743: 
                    case 746: 
                    case 748: 
                    case 749: 
                    case 751: {
                        queryState.setCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                opType = tablePartitionCommandType.get(child.getType())[tree.getChildCount() > 2 ? 1 : 0];
                queryState.setCommandType(opType);
                return new DDLSemanticAnalyzer(queryState);
            }
            case 753: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 754: 
                    case 755: 
                    case 756: 
                    case 757: 
                    case 758: {
                        opType = commandType.get(child.getType());
                        queryState.setCommandType(opType);
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                assert (child.getType() == 957);
                queryState.setCommandType(HiveOperation.ALTERVIEW_AS);
                return new SemanticAnalyzer(queryState);
            }
            case 760: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 762: {
                        opType = commandType.get(child.getType());
                        queryState.setCommandType(opType);
                        return new DDLSemanticAnalyzer(queryState);
                    }
                    case 761: {
                        opType = commandType.get(child.getType());
                        queryState.setCommandType(opType);
                        return new MaterializedViewRebuildSemanticAnalyzer(queryState);
                    }
                }
                queryState.setCommandType(null);
                return new DDLSemanticAnalyzer(queryState);
            }
            case 711: 
            case 718: 
            case 719: 
            case 720: 
            case 728: 
            case 759: 
            case 763: 
            case 764: 
            case 765: 
            case 772: 
            case 782: 
            case 785: 
            case 788: 
            case 790: 
            case 791: 
            case 792: 
            case 810: 
            case 811: 
            case 812: 
            case 819: 
            case 822: 
            case 823: 
            case 824: 
            case 825: 
            case 826: 
            case 827: 
            case 828: 
            case 829: 
            case 848: 
            case 850: 
            case 881: 
            case 892: 
            case 893: 
            case 898: 
            case 976: 
            case 977: 
            case 996: 
            case 997: 
            case 998: 
            case 999: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1006: 
            case 1007: 
            case 1008: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: 
            case 1015: 
            case 1016: 
            case 1017: 
            case 1035: 
            case 1081: 
            case 1090: 
            case 1091: {
                return new DDLSemanticAnalyzer(queryState);
            }
            case 783: 
            case 820: 
            case 962: {
                return new FunctionSemanticAnalyzer(queryState);
            }
            case 766: {
                return new ColumnStatsSemanticAnalyzer(queryState);
            }
            case 784: 
            case 821: {
                return new MacroSemanticAnalyzer(queryState);
            }
            case 809: 
            case 896: 
            case 1094: {
                return new UpdateDeleteSemanticAnalyzer(queryState);
            }
        }
        SemanticAnalyzer semAnalyzer = HiveConf.getBoolVar(queryState.getConf(), HiveConf.ConfVars.HIVE_CBO_ENABLED) ? new CalcitePlanner(queryState) : new SemanticAnalyzer(queryState);
        return semAnalyzer;
    }

    private SemanticAnalyzerFactory() {
    }

    static HiveOperation getOperation(int hiveParserToken) {
        return commandType.get(hiveParserToken);
    }

    static {
        commandType.put(833, HiveOperation.EXPLAIN);
        commandType.put(891, HiveOperation.LOAD);
        commandType.put(836, HiveOperation.EXPORT);
        commandType.put(860, HiveOperation.IMPORT);
        commandType.put(782, HiveOperation.CREATEDATABASE);
        commandType.put(819, HiveOperation.DROPDATABASE);
        commandType.put(1035, HiveOperation.SWITCHDATABASE);
        commandType.put(786, HiveOperation.CREATETABLE);
        commandType.put(1081, HiveOperation.TRUNCATETABLE);
        commandType.put(823, HiveOperation.DROPTABLE);
        commandType.put(812, HiveOperation.DESCTABLE);
        commandType.put(811, HiveOperation.DESCFUNCTION);
        commandType.put(898, HiveOperation.MSCK);
        commandType.put(722, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(743, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(741, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(740, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(731, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(724, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(748, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(725, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(749, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(739, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(732, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(733, HiveOperation.ALTERTABLE_EXCHANGEPARTITION);
        commandType.put(730, HiveOperation.ALTERTABLE_DROPCONSTRAINT);
        commandType.put(723, HiveOperation.ALTERTABLE_ADDCONSTRAINT);
        commandType.put(751, HiveOperation.ALTERTABLE_UPDATECOLUMNS);
        commandType.put(998, HiveOperation.SHOWDATABASES);
        commandType.put(1004, HiveOperation.SHOWTABLES);
        commandType.put(996, HiveOperation.SHOWCOLUMNS);
        commandType.put(1015, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(1016, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(1007, HiveOperation.SHOW_CREATEDATABASE);
        commandType.put(1008, HiveOperation.SHOW_CREATETABLE);
        commandType.put(1000, HiveOperation.SHOWFUNCTIONS);
        commandType.put(1003, HiveOperation.SHOWPARTITIONS);
        commandType.put(1001, HiveOperation.SHOWLOCKS);
        commandType.put(999, HiveOperation.SHOWLOCKS);
        commandType.put(997, HiveOperation.SHOWCONF);
        commandType.put(1005, HiveOperation.SHOWVIEWS);
        commandType.put(1002, HiveOperation.SHOWMATERIALIZEDVIEWS);
        commandType.put(783, HiveOperation.CREATEFUNCTION);
        commandType.put(820, HiveOperation.DROPFUNCTION);
        commandType.put(962, HiveOperation.RELOADFUNCTION);
        commandType.put(784, HiveOperation.CREATEMACRO);
        commandType.put(821, HiveOperation.DROPMACRO);
        commandType.put(787, HiveOperation.CREATEVIEW);
        commandType.put(789, HiveOperation.CREATE_MATERIALIZED_VIEW);
        commandType.put(824, HiveOperation.DROPVIEW);
        commandType.put(826, HiveOperation.DROP_MATERIALIZED_VIEW);
        commandType.put(757, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(756, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(754, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(755, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(737, HiveOperation.ALTERTABLE_OWNER);
        commandType.put(758, HiveOperation.ALTERVIEW_RENAME);
        commandType.put(753, HiveOperation.ALTERVIEW_AS);
        commandType.put(762, HiveOperation.ALTER_MATERIALIZED_VIEW_REWRITE);
        commandType.put(957, HiveOperation.QUERY);
        commandType.put(893, HiveOperation.LOCKTABLE);
        commandType.put(1091, HiveOperation.UNLOCKTABLE);
        commandType.put(892, HiveOperation.LOCKDB);
        commandType.put(1090, HiveOperation.UNLOCKDB);
        commandType.put(785, HiveOperation.CREATEROLE);
        commandType.put(822, HiveOperation.DROPROLE);
        commandType.put(848, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(976, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(1009, HiveOperation.SHOW_GRANT);
        commandType.put(850, HiveOperation.GRANT_ROLE);
        commandType.put(977, HiveOperation.REVOKE_ROLE);
        commandType.put(1010, HiveOperation.SHOW_ROLES);
        commandType.put(1014, HiveOperation.SHOW_ROLES);
        commandType.put(1012, HiveOperation.SHOW_ROLE_PRINCIPALS);
        commandType.put(1011, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(720, HiveOperation.ALTERDATABASE);
        commandType.put(719, HiveOperation.ALTERDATABASE_OWNER);
        commandType.put(718, HiveOperation.ALTERDATABASE_LOCATION);
        commandType.put(810, HiveOperation.DESCDATABASE);
        commandType.put(746, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(766, HiveOperation.ANALYZE_TABLE);
        commandType.put(772, HiveOperation.CACHE_METADATA);
        commandType.put(738, HiveOperation.ALTERTABLE_PARTCOLTYPE);
        commandType.put(1006, HiveOperation.SHOW_COMPACTIONS);
        commandType.put(1017, HiveOperation.SHOW_TRANSACTIONS);
        commandType.put(711, HiveOperation.ABORT_TRANSACTIONS);
        commandType.put(1023, HiveOperation.START_TRANSACTION);
        commandType.put(780, HiveOperation.COMMIT);
        commandType.put(982, HiveOperation.ROLLBACK);
        commandType.put(994, HiveOperation.SET_AUTOCOMMIT);
        commandType.put(969, HiveOperation.REPLDUMP);
        commandType.put(970, HiveOperation.REPLLOAD);
        commandType.put(971, HiveOperation.REPLSTATUS);
        commandType.put(881, HiveOperation.KILL_QUERY);
        commandType.put(791, HiveOperation.CREATE_RESOURCEPLAN);
        commandType.put(1013, HiveOperation.SHOW_RESOURCEPLAN);
        commandType.put(764, HiveOperation.ALTER_RESOURCEPLAN);
        commandType.put(828, HiveOperation.DROP_RESOURCEPLAN);
        commandType.put(792, HiveOperation.CREATE_TRIGGER);
        commandType.put(765, HiveOperation.ALTER_TRIGGER);
        commandType.put(829, HiveOperation.DROP_TRIGGER);
        commandType.put(790, HiveOperation.CREATE_POOL);
        commandType.put(763, HiveOperation.ALTER_POOL);
        commandType.put(827, HiveOperation.DROP_POOL);
        commandType.put(788, HiveOperation.CREATE_MAPPING);
        commandType.put(759, HiveOperation.ALTER_MAPPING);
        commandType.put(825, HiveOperation.DROP_MAPPING);
        tablePartitionCommandType.put(734, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(735, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(736, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(745, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(744, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(742, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(729, new HiveOperation[]{HiveOperation.ALTERTABLE_COMPACT, HiveOperation.ALTERTABLE_COMPACT});
        tablePartitionCommandType.put(747, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(726, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(728, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
        tablePartitionCommandType.put(750, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
        tablePartitionCommandType.put(752, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
    }
}

