/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import io.prestosql.hive.;
import io.prestosql.hive.$internal.com.google.common.base.Joiner;
import io.prestosql.hive.$internal.com.google.common.collect.Lists;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.impl.LlapManagementProtocolClientImpl;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstance;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.CommandUtil;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.net.NetUtils;

public class LlapCacheResourceProcessor
implements CommandProcessor {
    public static final Logger LOG = LoggerFactory.getLogger(LlapCacheResourceProcessor.class);
    private .Options CACHE_OPTIONS = new .Options();
    private .HelpFormatter helpFormatter = new .HelpFormatter();

    LlapCacheResourceProcessor() {
        this.CACHE_OPTIONS.addOption("purge", "purge", false, "Purge LLAP IO cache");
    }

    private CommandProcessorResponse returnErrorResponse(String errmsg) {
        return new CommandProcessorResponse(1, "LLAP Cache Processor Helper Failed:" + errmsg, null);
    }

    @Override
    public CommandProcessorResponse run(String command) {
        SessionState ss = SessionState.get();
        command = new VariableSubstitution(() -> SessionState.get().getHiveVariables()).substitute(ss.getConf(), command);
        String[] tokens = command.split("\\s+");
        if (tokens.length < 1) {
            return this.returnErrorResponse("Command arguments are empty.");
        }
        String[] params = Arrays.copyOfRange(tokens, 1, tokens.length);
        try {
            return this.llapCacheCommandHandler(ss, params);
        }
        catch (Exception e) {
            return this.returnErrorResponse(e.getMessage());
        }
    }

    private CommandProcessorResponse llapCacheCommandHandler(SessionState ss, String[] params) throws .ParseException {
        .CommandLine args = this.parseCommandArgs(this.CACHE_OPTIONS, params);
        boolean purge = args.hasOption("purge");
        String hs2Host = null;
        if (ss.isHiveServerQuery()) {
            hs2Host = ss.getHiveServer2Host();
        }
        if (purge) {
            ArrayList<String> fullCommand = Lists.newArrayList("llap", "cache");
            fullCommand.addAll(Arrays.asList(params));
            CommandProcessorResponse authErrResp = CommandUtil.authorizeCommandAndServiceObject(ss, HiveOperationType.LLAP_CACHE_PURGE, fullCommand, hs2Host);
            if (authErrResp != null) {
                return authErrResp;
            }
            try {
                LlapRegistryService llapRegistryService = LlapRegistryService.getClient((Configuration)ss.getConf());
                this.llapCachePurge(ss, llapRegistryService);
                return this.createProcessorSuccessResponse();
            }
            catch (Exception e) {
                LOG.error("Error while purging LLAP IO Cache. err: ", e);
                return this.returnErrorResponse("Error while purging LLAP IO Cache. err: " + e.getMessage());
            }
        }
        String usage = this.getUsageAsString();
        return this.returnErrorResponse("Unsupported sub-command option. " + usage);
    }

    private CommandProcessorResponse createProcessorSuccessResponse() {
        return new CommandProcessorResponse(0, null, null, this.getSchema());
    }

    private Schema getSchema() {
        Schema sch = new Schema();
        sch.addToFieldSchemas(new FieldSchema("hostName", "string", ""));
        sch.addToFieldSchemas(new FieldSchema("purgedMemoryBytes", "string", ""));
        sch.putToProperties("serialization.null.format", "\\N");
        return sch;
    }

    private void llapCachePurge(SessionState ss, LlapRegistryService llapRegistryService) throws Exception {
        ExecutorService executorService = Executors.newCachedThreadPool();
        ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>();
        Collection instances = llapRegistryService.getInstances().getAll();
        for (LlapServiceInstance instance : instances) {
            futures.add(executorService.submit(new PurgeCallable(ss.getConf(), instance)));
        }
        int i = 0;
        for (LlapServiceInstance instance : instances) {
            Future future = (Future)futures.get(i);
            ss.out.println(Joiner.on("\t").join(instance.getHost(), future.get(), new Object[0]));
            ++i;
        }
    }

    private String getUsageAsString() {
        StringWriter out = new StringWriter();
        PrintWriter pw = new PrintWriter(out);
        this.helpFormatter.printUsage(pw, this.helpFormatter.getWidth(), "llap cache", this.CACHE_OPTIONS);
        pw.flush();
        return out.toString();
    }

    private .CommandLine parseCommandArgs(.Options opts, String[] args) throws .ParseException {
        .GnuParser parser = new .GnuParser();
        return parser.parse(opts, args);
    }

    @Override
    public void close() {
    }

    private static class PurgeCallable
    implements Callable<Long> {
        public static final Logger LOG = LoggerFactory.getLogger(PurgeCallable.class);
        private Configuration conf;
        private LlapServiceInstance instance;
        private SocketFactory socketFactory;
        private RetryPolicy retryPolicy;

        PurgeCallable(Configuration conf, LlapServiceInstance llapServiceInstance) {
            this.conf = conf;
            this.instance = llapServiceInstance;
            this.socketFactory = NetUtils.getDefaultSocketFactory((Configuration)conf);
            this.retryPolicy = RetryPolicies.retryUpToMaximumTimeWithFixedSleep((long)10000L, (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }

        @Override
        public Long call() {
            try {
                LlapManagementProtocolClientImpl client = new LlapManagementProtocolClientImpl(this.conf, this.instance.getHost(), this.instance.getManagementPort(), this.retryPolicy, this.socketFactory);
                LlapDaemonProtocolProtos.PurgeCacheResponseProto resp = client.purgeCache(null, LlapDaemonProtocolProtos.PurgeCacheRequestProto.newBuilder().build());
                return resp.getPurgedMemoryBytes();
            }
            catch (Exception e) {
                LOG.warn("Exception while purging cache.", e);
                return 0L;
            }
        }
    }
}

