/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import io.prestosql.hive.;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.io.IOUtils;

public class OperationLog {
    private static final Logger LOG = LoggerFactory.getLogger(OperationLog.class.getName());
    private final String operationName;
    private final LogFile logFile;
    private final LogFile testLogFile;
    private final boolean isShortLogs;
    private final boolean isRemoveLogs;
    private LoggingLevel opLoggingLevel = LoggingLevel.UNKNOWN;

    public OperationLog(String name, File file, HiveConf hiveConf) {
        this.operationName = name;
        this.logFile = new LogFile(file);
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_ENABLED)) {
            String logLevel = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LEVEL);
            this.opLoggingLevel = OperationLog.getLoggingLevel(logLevel);
        }
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
            this.isRemoveLogs = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_TESTING_REMOVE_LOGS);
            if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_TESTING_SHORT_LOGS)) {
                this.testLogFile = new LogFile(new File(file.getAbsolutePath() + ".test"));
                this.isShortLogs = true;
            } else {
                this.testLogFile = null;
                this.isShortLogs = false;
            }
        } else {
            this.testLogFile = null;
            this.isShortLogs = false;
            this.isRemoveLogs = true;
        }
    }

    public static LoggingLevel getLoggingLevel(String mode) {
        if (mode.equalsIgnoreCase("none")) {
            return LoggingLevel.NONE;
        }
        if (mode.equalsIgnoreCase("execution")) {
            return LoggingLevel.EXECUTION;
        }
        if (mode.equalsIgnoreCase("verbose")) {
            return LoggingLevel.VERBOSE;
        }
        if (mode.equalsIgnoreCase("performance")) {
            return LoggingLevel.PERFORMANCE;
        }
        return LoggingLevel.UNKNOWN;
    }

    public LoggingLevel getOpLoggingLevel() {
        return this.opLoggingLevel;
    }

    public List<String> readOperationLog(boolean isFetchFirst, long maxRows) throws SQLException {
        if (this.isShortLogs) {
            return this.testLogFile.read(isFetchFirst, maxRows);
        }
        return this.logFile.read(isFetchFirst, maxRows);
    }

    public void close() {
        if (this.isShortLogs) {
            this.logFile.close(this.isRemoveLogs);
            this.testLogFile.close(this.isRemoveLogs);
        } else {
            this.logFile.close(true);
        }
    }

    private class LogFile {
        private final File file;
        private BufferedReader in;
        private volatile boolean isRemoved;

        LogFile(File file) {
            this.file = file;
            this.isRemoved = false;
        }

        synchronized List<String> read(boolean isFetchFirst, long maxRows) throws SQLException {
            if (isFetchFirst) {
                this.resetIn();
            }
            return this.readResults(maxRows);
        }

        synchronized void close(boolean removeLog) {
            try {
                if (this.in != null) {
                    this.in.close();
                }
                if (!this.isRemoved && removeLog && this.file.exists()) {
                    .FileUtils.forceDelete((File)this.file);
                    this.isRemoved = true;
                }
            }
            catch (Exception e) {
                LOG.error("Failed to remove corresponding log file of operation: " + OperationLog.this.operationName, e);
            }
        }

        private void resetIn() {
            if (this.in != null) {
                IOUtils.closeStream((Closeable)this.in);
                this.in = null;
            }
        }

        private List<String> readResults(long nLines) throws SQLException {
            ArrayList<String> logs = new ArrayList<String>();
            if (this.in == null) {
                try {
                    this.in = new BufferedReader(new InputStreamReader(new FileInputStream(this.file)));
                    if (OperationLog.this.isShortLogs) {
                        logs.add("Reading log file: " + this.file);
                        --nLines;
                    }
                }
                catch (FileNotFoundException e) {
                    return logs;
                }
            }
            String line = "";
            int i = 0;
            while ((long)i < nLines || nLines <= 0L) {
                try {
                    line = this.in.readLine();
                    if (line == null) break;
                    logs.add(line);
                }
                catch (IOException e) {
                    if (this.isRemoved) {
                        throw new SQLException("The operation has been closed and its log file " + this.file.getAbsolutePath() + " has been removed.", e);
                    }
                    throw new SQLException("Reading operation log file encountered an exception: ", e);
                }
                ++i;
            }
            return logs;
        }
    }

    public static enum LoggingLevel {
        NONE,
        EXECUTION,
        PERFORMANCE,
        VERBOSE,
        UNKNOWN;

    }
}

