/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFLead;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.LeadLagBuffer;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.io.IntWritable;

public abstract class GenericUDAFLeadLag
extends AbstractGenericUDAFResolver {
    static final Logger LOG = LoggerFactory.getLogger(GenericUDAFLead.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo parameters) throws SemanticException {
        ObjectInspector[] paramOIs = parameters.getParameterObjectInspectors();
        String fNm = this.functionName();
        if (paramOIs.length < 1 || paramOIs.length > 3) {
            throw new UDFArgumentTypeException(paramOIs.length - 1, "Incorrect invocation of " + fNm + ": _FUNC_(expr, amt, default)");
        }
        int amt = 1;
        if (paramOIs.length > 1) {
            ObjectInspector amtOI = paramOIs[1];
            if (!ObjectInspectorUtils.isConstantObjectInspector(amtOI) || amtOI.getCategory() != ObjectInspector.Category.PRIMITIVE || ((PrimitiveObjectInspector)amtOI).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.INT) {
                throw new UDFArgumentTypeException(1, fNm + " amount must be a integer value " + amtOI.getTypeName() + " was passed as parameter 1.");
            }
            Object o = ((ConstantObjectInspector)amtOI).getWritableConstantValue();
            amt = ((IntWritable)o).get();
            if (amt < 0) {
                throw new UDFArgumentTypeException(1, fNm + " amount can not be nagative. Specified: " + amt);
            }
        }
        if (paramOIs.length == 3) {
            ObjectInspectorConverters.getConverter(paramOIs[2], paramOIs[0]);
        }
        GenericUDAFLeadLagEvaluator eval = this.createLLEvaluator();
        eval.setAmt(amt);
        return eval;
    }

    protected abstract String functionName();

    protected abstract GenericUDAFLeadLagEvaluator createLLEvaluator();

    public static abstract class GenericUDAFLeadLagEvaluator
    extends GenericUDAFEvaluator {
        private transient ObjectInspector[] inputOI;
        private int amt;
        String fnName;
        private transient ObjectInspectorConverters.Converter defaultValueConverter;

        public GenericUDAFLeadLagEvaluator() {
        }

        protected GenericUDAFLeadLagEvaluator(GenericUDAFLeadLagEvaluator src) {
            this.inputOI = src.inputOI;
            this.amt = src.amt;
            this.fnName = src.fnName;
            this.defaultValueConverter = src.defaultValueConverter;
            this.mode = src.mode;
        }

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m != GenericUDAFEvaluator.Mode.COMPLETE) {
                throw new HiveException("Only COMPLETE mode supported for " + this.fnName + " function");
            }
            this.inputOI = parameters;
            if (parameters.length == 3) {
                this.defaultValueConverter = ObjectInspectorConverters.getConverter(parameters[2], parameters[0]);
            }
            return ObjectInspectorFactory.getStandardListObjectInspector(ObjectInspectorUtils.getStandardObjectInspector(parameters[0]));
        }

        public int getAmt() {
            return this.amt;
        }

        public void setAmt(int amt) {
            this.amt = amt;
        }

        public String getFnName() {
            return this.fnName;
        }

        public void setFnName(String fnName) {
            this.fnName = fnName;
        }

        protected abstract LeadLagBuffer getNewLLBuffer() throws HiveException;

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            LeadLagBuffer lb = this.getNewLLBuffer();
            lb.initialize(this.amt);
            return lb;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((LeadLagBuffer)agg).initialize(this.amt);
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            Object rowExprVal = ObjectInspectorUtils.copyToStandardObject(parameters[0], this.inputOI[0]);
            Object defaultVal = parameters.length > 2 ? ObjectInspectorUtils.copyToStandardObject(this.defaultValueConverter.convert(parameters[2]), this.inputOI[0]) : null;
            ((LeadLagBuffer)agg).addRow(rowExprVal, defaultVal);
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            throw new HiveException("terminatePartial not supported");
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            throw new HiveException("merge not supported");
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return ((LeadLagBuffer)agg).terminate();
        }
    }
}

