/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazybinary.fast;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class LazyBinarySerializeWrite
implements SerializeWrite {
    public static final Logger LOG = LoggerFactory.getLogger(LazyBinarySerializeWrite.class.getName());
    private ByteStream.Output output;
    private int rootFieldCount;
    private boolean skipLengthPrefix = false;
    private TimestampWritable timestampWritable;
    private HiveIntervalYearMonthWritable hiveIntervalYearMonthWritable;
    private HiveIntervalDayTimeWritable hiveIntervalDayTimeWritable;
    private HiveIntervalDayTime hiveIntervalDayTime;
    private HiveDecimalWritable hiveDecimalWritable;
    private byte[] vLongBytes;
    private long[] scratchLongs;
    private byte[] scratchBuffer;
    private Field root;
    private Deque<Field> stack = new ArrayDeque<Field>();
    private LazyBinarySerDe.BooleanRef warnedOnceNullMapKey;

    public LazyBinarySerializeWrite(int fieldCount) {
        this();
        this.vLongBytes = new byte[9];
        this.rootFieldCount = fieldCount;
        this.resetWithoutOutput();
    }

    private LazyBinarySerializeWrite() {
    }

    @Override
    public void set(ByteStream.Output output) {
        this.output = output;
        output.reset();
        this.resetWithoutOutput();
    }

    @Override
    public void setAppend(ByteStream.Output output) {
        this.output = output;
        this.resetWithoutOutput();
        this.root.nullOffset = output.getLength();
    }

    @Override
    public void reset() {
        this.output.reset();
        this.resetWithoutOutput();
    }

    private void resetWithoutOutput() {
        this.root = new Field(ObjectInspector.Category.STRUCT);
        this.root.fieldCount = this.rootFieldCount;
        this.stack.clear();
        this.stack.push(this.root);
        this.warnedOnceNullMapKey = null;
    }

    @Override
    public void writeNull() throws IOException {
        Field current = this.stack.peek();
        if (current.type == ObjectInspector.Category.STRUCT) {
            if (current.fieldIndex % 8 == 0) {
                if (current.fieldIndex > 0) {
                    this.output.writeByte(current.nullOffset, current.nullByte);
                    current.nullByte = 0;
                    current.nullOffset = this.output.getLength();
                }
                this.output.reserve(1);
            }
            ++current.fieldIndex;
            if (current.fieldIndex == current.fieldCount) {
                this.output.writeByte(current.nullOffset, current.nullByte);
            }
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.beginElement();
        this.output.write((byte)(v ? 1 : 0));
        this.finishElement();
    }

    @Override
    public void writeByte(byte v) throws IOException {
        this.beginElement();
        this.output.write(v);
        this.finishElement();
    }

    @Override
    public void writeShort(short v) throws IOException {
        this.beginElement();
        this.output.write((byte)(v >> 8));
        this.output.write((byte)v);
        this.finishElement();
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.beginElement();
        this.writeVInt(v);
        this.finishElement();
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.beginElement();
        this.writeVLong(v);
        this.finishElement();
    }

    @Override
    public void writeFloat(float vf) throws IOException {
        this.beginElement();
        int v = Float.floatToIntBits(vf);
        this.output.write((byte)(v >> 24));
        this.output.write((byte)(v >> 16));
        this.output.write((byte)(v >> 8));
        this.output.write((byte)v);
        this.finishElement();
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.beginElement();
        LazyBinaryUtils.writeDouble(this.output, v);
        this.finishElement();
    }

    @Override
    public void writeString(byte[] v) throws IOException {
        this.beginElement();
        int length = v.length;
        this.writeVInt(length);
        this.output.write(v, 0, length);
        this.finishElement();
    }

    @Override
    public void writeString(byte[] v, int start, int length) throws IOException {
        this.beginElement();
        this.writeVInt(length);
        this.output.write(v, start, length);
        this.finishElement();
    }

    @Override
    public void writeHiveChar(HiveChar hiveChar) throws IOException {
        String string = hiveChar.getStrippedValue();
        byte[] bytes = string.getBytes();
        this.writeString(bytes);
    }

    @Override
    public void writeHiveVarchar(HiveVarchar hiveVarchar) throws IOException {
        String string = hiveVarchar.getValue();
        byte[] bytes = string.getBytes();
        this.writeString(bytes);
    }

    @Override
    public void writeBinary(byte[] v) throws IOException {
        this.writeString(v);
    }

    @Override
    public void writeBinary(byte[] v, int start, int length) throws IOException {
        this.writeString(v, start, length);
    }

    @Override
    public void writeDate(Date date) throws IOException {
        this.beginElement();
        this.writeVInt(DateWritable.dateToDays(date));
        this.finishElement();
    }

    @Override
    public void writeDate(int dateAsDays) throws IOException {
        this.beginElement();
        this.writeVInt(dateAsDays);
        this.finishElement();
    }

    @Override
    public void writeTimestamp(Timestamp v) throws IOException {
        this.beginElement();
        if (this.timestampWritable == null) {
            this.timestampWritable = new TimestampWritable();
        }
        this.timestampWritable.set(v);
        this.timestampWritable.writeToByteStream(this.output);
        this.finishElement();
    }

    @Override
    public void writeHiveIntervalYearMonth(HiveIntervalYearMonth viyt) throws IOException {
        this.beginElement();
        if (this.hiveIntervalYearMonthWritable == null) {
            this.hiveIntervalYearMonthWritable = new HiveIntervalYearMonthWritable();
        }
        this.hiveIntervalYearMonthWritable.set(viyt);
        this.hiveIntervalYearMonthWritable.writeToByteStream(this.output);
        this.finishElement();
    }

    @Override
    public void writeHiveIntervalYearMonth(int totalMonths) throws IOException {
        this.beginElement();
        if (this.hiveIntervalYearMonthWritable == null) {
            this.hiveIntervalYearMonthWritable = new HiveIntervalYearMonthWritable();
        }
        this.hiveIntervalYearMonthWritable.set(totalMonths);
        this.hiveIntervalYearMonthWritable.writeToByteStream(this.output);
        this.finishElement();
    }

    @Override
    public void writeHiveIntervalDayTime(HiveIntervalDayTime vidt) throws IOException {
        this.beginElement();
        if (this.hiveIntervalDayTimeWritable == null) {
            this.hiveIntervalDayTimeWritable = new HiveIntervalDayTimeWritable();
        }
        this.hiveIntervalDayTimeWritable.set(vidt);
        this.hiveIntervalDayTimeWritable.writeToByteStream(this.output);
        this.finishElement();
    }

    @Override
    public void writeDecimal64(long decimal64Long, int scale) throws IOException {
        if (this.hiveDecimalWritable == null) {
            this.hiveDecimalWritable = new HiveDecimalWritable();
        }
        this.hiveDecimalWritable.deserialize64(decimal64Long, scale);
        this.writeHiveDecimal(this.hiveDecimalWritable, scale);
    }

    @Override
    public void writeHiveDecimal(HiveDecimal dec, int scale) throws IOException {
        this.beginElement();
        if (this.scratchLongs == null) {
            this.scratchLongs = new long[6];
            this.scratchBuffer = new byte[49];
        }
        LazyBinarySerDe.writeToByteStream((ByteStream.RandomAccessOutput)this.output, dec, this.scratchLongs, this.scratchBuffer);
        this.finishElement();
    }

    @Override
    public void writeHiveDecimal(HiveDecimalWritable decWritable, int scale) throws IOException {
        this.beginElement();
        if (this.scratchLongs == null) {
            this.scratchLongs = new long[6];
            this.scratchBuffer = new byte[49];
        }
        LazyBinarySerDe.writeToByteStream((ByteStream.RandomAccessOutput)this.output, decWritable, this.scratchLongs, this.scratchBuffer);
        this.finishElement();
    }

    private void writeVInt(int v) {
        int len = LazyBinaryUtils.writeVLongToByteArray(this.vLongBytes, v);
        this.output.write(this.vLongBytes, 0, len);
    }

    private void writeVLong(long v) {
        int len = LazyBinaryUtils.writeVLongToByteArray(this.vLongBytes, v);
        this.output.write(this.vLongBytes, 0, len);
    }

    @Override
    public void beginList(List list) {
        int size;
        Field current = new Field(ObjectInspector.Category.LIST);
        this.beginComplex(current);
        current.fieldCount = size = list.size();
        if (!this.skipLengthPrefix) {
            current.byteSizeStart = this.output.getLength();
            this.output.reserve(4);
            current.start = this.output.getLength();
        }
        LazyBinaryUtils.writeVInt(this.output, size);
        int nullByte = 0;
        for (int eid = 0; eid < size; ++eid) {
            if (null != list.get(eid)) {
                nullByte = (byte)(nullByte | 1 << eid % 8);
            }
            if (7 != eid % 8 && eid != size - 1) continue;
            this.output.write(nullByte);
            nullByte = 0;
        }
    }

    @Override
    public void separateList() {
    }

    @Override
    public void finishList() {
        Field current = this.stack.peek();
        if (!this.skipLengthPrefix) {
            int listEnd = this.output.getLength();
            int listSize = listEnd - current.start;
            LazyBinarySerializeWrite.writeSizeAtOffset(this.output, current.byteSizeStart, listSize);
        }
        this.finishComplex();
    }

    @Override
    public void beginMap(Map<?, ?> map) {
        int size;
        Field current = new Field(ObjectInspector.Category.MAP);
        this.beginComplex(current);
        if (!this.skipLengthPrefix) {
            current.byteSizeStart = this.output.getLength();
            this.output.reserve(4);
            current.start = this.output.getLength();
        }
        current.fieldIndex = size = map.size();
        LazyBinaryUtils.writeVInt(this.output, size);
        int b = 0;
        int nullByte = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (null != entry.getKey()) {
                nullByte = (byte)(nullByte | 1 << b % 8);
            } else if (this.warnedOnceNullMapKey != null) {
                if (!this.warnedOnceNullMapKey.value) {
                    LOG.warn("Null map key encountered! Ignoring similar problems.");
                }
                this.warnedOnceNullMapKey.value = true;
            }
            ++b;
            if (null != entry.getValue()) {
                nullByte = (byte)(nullByte | 1 << b % 8);
            }
            if (0 != ++b % 8 && b != size * 2) continue;
            this.output.write(nullByte);
            nullByte = 0;
        }
    }

    @Override
    public void separateKey() {
    }

    @Override
    public void separateKeyValuePair() {
    }

    @Override
    public void finishMap() {
        Field current = this.stack.peek();
        if (!this.skipLengthPrefix) {
            int mapEnd = this.output.getLength();
            int mapSize = mapEnd - current.start;
            LazyBinarySerializeWrite.writeSizeAtOffset(this.output, current.byteSizeStart, mapSize);
        }
        this.finishComplex();
    }

    @Override
    public void beginStruct(List fieldValues) {
        Field current = new Field(ObjectInspector.Category.STRUCT);
        this.beginComplex(current);
        current.fieldCount = fieldValues.size();
        if (!this.skipLengthPrefix) {
            current.byteSizeStart = this.output.getLength();
            this.output.reserve(4);
            current.start = this.output.getLength();
        }
        current.nullOffset = this.output.getLength();
    }

    @Override
    public void separateStruct() {
    }

    @Override
    public void finishStruct() {
        Field current = this.stack.peek();
        if (!this.skipLengthPrefix) {
            int typeEnd = this.output.getLength();
            int typeSize = typeEnd - current.start;
            LazyBinarySerializeWrite.writeSizeAtOffset(this.output, current.byteSizeStart, typeSize);
        }
        this.finishComplex();
    }

    @Override
    public void beginUnion(int tag) throws IOException {
        Field current = new Field(ObjectInspector.Category.UNION);
        this.beginComplex(current);
        current.fieldCount = 1;
        if (!this.skipLengthPrefix) {
            current.byteSizeStart = this.output.getLength();
            this.output.reserve(4);
            current.start = this.output.getLength();
        }
        this.output.write(tag);
    }

    @Override
    public void finishUnion() {
        Field current = this.stack.peek();
        if (!this.skipLengthPrefix) {
            int typeEnd = this.output.getLength();
            int typeSize = typeEnd - current.start;
            LazyBinarySerializeWrite.writeSizeAtOffset(this.output, current.byteSizeStart, typeSize);
        }
        this.finishComplex();
    }

    private void beginElement() {
        Field current = this.stack.peek();
        if (current.type == ObjectInspector.Category.STRUCT) {
            if (current.fieldIndex % 8 == 0) {
                if (current.fieldIndex > 0) {
                    this.output.writeByte(current.nullOffset, current.nullByte);
                    current.nullByte = 0;
                    current.nullOffset = this.output.getLength();
                }
                this.output.reserve(1);
            }
            current.nullByte = (byte)(current.nullByte | 1 << current.fieldIndex % 8);
        }
    }

    private void finishElement() {
        Field current = this.stack.peek();
        if (current.type == ObjectInspector.Category.STRUCT) {
            ++current.fieldIndex;
            if (current.fieldIndex == current.fieldCount) {
                this.output.writeByte(current.nullOffset, current.nullByte);
            }
        }
    }

    private void beginComplex(Field field) {
        this.beginElement();
        this.stack.push(field);
    }

    private void finishComplex() {
        this.stack.pop();
        this.finishElement();
    }

    private static void writeSizeAtOffset(ByteStream.RandomAccessOutput byteStream, int byteSizeStart, int size) {
        byteStream.writeInt(byteSizeStart, size);
    }

    private static class Field {
        ObjectInspector.Category type;
        int fieldCount;
        int fieldIndex;
        int byteSizeStart;
        int start;
        long nullOffset;
        byte nullByte;

        Field(ObjectInspector.Category type) {
            this.type = type;
        }
    }
}

