/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.format.converter;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.CorruptStatistics;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.statistics.BooleanStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.ColumnChunk;
import org.apache.parquet.format.ColumnMetaData;
import org.apache.parquet.format.ColumnOrder;
import org.apache.parquet.format.CompressionCodec;
import org.apache.parquet.format.ConvertedType;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.DataPageHeaderV2;
import org.apache.parquet.format.DictionaryPageHeader;
import org.apache.parquet.format.Encoding;
import org.apache.parquet.format.FieldRepetitionType;
import org.apache.parquet.format.FileMetaData;
import org.apache.parquet.format.KeyValue;
import org.apache.parquet.format.PageEncodingStats;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.PageType;
import org.apache.parquet.format.RowGroup;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.format.Statistics;
import org.apache.parquet.format.Type;
import org.apache.parquet.format.TypeDefinedOrder;
import org.apache.parquet.format.Util;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.ColumnOrder;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.TypeVisitor;
import org.apache.parquet.schema.Types;

public class ParquetMetadataConverter {
    private static final TypeDefinedOrder TYPE_DEFINED_ORDER = new TypeDefinedOrder();
    public static final MetadataFilter NO_FILTER = new NoFilter();
    public static final MetadataFilter SKIP_ROW_GROUPS = new SkipMetadataFilter();
    public static final long MAX_STATS_SIZE = 4096L;
    private static final Logger LOG = LoggerFactory.getLogger(ParquetMetadataConverter.class);
    private final boolean useSignedStringMinMax;
    private static final ConcurrentHashMap<Set<org.apache.parquet.column.Encoding>, Set<org.apache.parquet.column.Encoding>> cachedEncodingSets = new ConcurrentHashMap();
    private static final Set<OriginalType> STRING_TYPES = Collections.unmodifiableSet(new HashSet<OriginalType>(Arrays.asList(OriginalType.UTF8, OriginalType.ENUM, OriginalType.JSON)));

    public ParquetMetadataConverter() {
        this(false);
    }

    @Deprecated
    public ParquetMetadataConverter(Configuration conf) {
        this(conf.getBoolean("parquet.strings.signed-min-max.enabled", false));
    }

    public ParquetMetadataConverter(ParquetReadOptions options) {
        this(options.useSignedStringMinMax());
    }

    private ParquetMetadataConverter(boolean useSignedStringMinMax) {
        this.useSignedStringMinMax = useSignedStringMinMax;
    }

    public FileMetaData toParquetMetadata(int currentVersion, ParquetMetadata parquetMetadata) {
        List<BlockMetaData> blocks = parquetMetadata.getBlocks();
        ArrayList<RowGroup> rowGroups = new ArrayList<RowGroup>();
        long numRows = 0L;
        for (BlockMetaData block : blocks) {
            numRows += block.getRowCount();
            this.addRowGroup(parquetMetadata, rowGroups, block);
        }
        FileMetaData fileMetaData = new FileMetaData(currentVersion, this.toParquetSchema(parquetMetadata.getFileMetaData().getSchema()), numRows, rowGroups);
        Set<Map.Entry<String, String>> keyValues = parquetMetadata.getFileMetaData().getKeyValueMetaData().entrySet();
        for (Map.Entry<String, String> keyValue : keyValues) {
            ParquetMetadataConverter.addKeyValue(fileMetaData, keyValue.getKey(), keyValue.getValue());
        }
        fileMetaData.setCreated_by(parquetMetadata.getFileMetaData().getCreatedBy());
        fileMetaData.setColumn_orders(this.getColumnOrders(parquetMetadata.getFileMetaData().getSchema()));
        return fileMetaData;
    }

    private List<ColumnOrder> getColumnOrders(MessageType schema) {
        ArrayList<ColumnOrder> columnOrders = new ArrayList<ColumnOrder>();
        int n = schema.getPaths().size();
        for (int i = 0; i < n; ++i) {
            ColumnOrder columnOrder = new ColumnOrder();
            columnOrder.setTYPE_ORDER(TYPE_DEFINED_ORDER);
            columnOrders.add(columnOrder);
        }
        return columnOrders;
    }

    List<SchemaElement> toParquetSchema(MessageType schema) {
        ArrayList<SchemaElement> result = new ArrayList<SchemaElement>();
        this.addToList(result, schema);
        return result;
    }

    private void addToList(final List<SchemaElement> result, org.apache.parquet.schema.Type field) {
        field.accept(new TypeVisitor(){

            @Override
            public void visit(PrimitiveType primitiveType) {
                SchemaElement element = new SchemaElement(primitiveType.getName());
                element.setRepetition_type(ParquetMetadataConverter.this.toParquetRepetition(primitiveType.getRepetition()));
                element.setType(ParquetMetadataConverter.this.getType(primitiveType.getPrimitiveTypeName()));
                if (primitiveType.getOriginalType() != null) {
                    element.setConverted_type(ParquetMetadataConverter.this.getConvertedType(primitiveType.getOriginalType()));
                }
                if (primitiveType.getDecimalMetadata() != null) {
                    element.setPrecision(primitiveType.getDecimalMetadata().getPrecision());
                    element.setScale(primitiveType.getDecimalMetadata().getScale());
                }
                if (primitiveType.getTypeLength() > 0) {
                    element.setType_length(primitiveType.getTypeLength());
                }
                if (primitiveType.getId() != null) {
                    element.setField_id(primitiveType.getId().intValue());
                }
                result.add(element);
            }

            @Override
            public void visit(MessageType messageType) {
                SchemaElement element = new SchemaElement(messageType.getName());
                if (messageType.getId() != null) {
                    element.setField_id(messageType.getId().intValue());
                }
                this.visitChildren(result, messageType.asGroupType(), element);
            }

            @Override
            public void visit(GroupType groupType) {
                SchemaElement element = new SchemaElement(groupType.getName());
                element.setRepetition_type(ParquetMetadataConverter.this.toParquetRepetition(groupType.getRepetition()));
                if (groupType.getOriginalType() != null) {
                    element.setConverted_type(ParquetMetadataConverter.this.getConvertedType(groupType.getOriginalType()));
                }
                if (groupType.getId() != null) {
                    element.setField_id(groupType.getId().intValue());
                }
                this.visitChildren(result, groupType, element);
            }

            private void visitChildren(List<SchemaElement> result2, GroupType groupType, SchemaElement element) {
                element.setNum_children(groupType.getFieldCount());
                result2.add(element);
                for (org.apache.parquet.schema.Type field : groupType.getFields()) {
                    ParquetMetadataConverter.this.addToList(result2, field);
                }
            }
        });
    }

    private void addRowGroup(ParquetMetadata parquetMetadata, List<RowGroup> rowGroups, BlockMetaData block) {
        List<ColumnChunkMetaData> columns = block.getColumns();
        ArrayList<ColumnChunk> parquetColumns = new ArrayList<ColumnChunk>();
        for (ColumnChunkMetaData columnMetaData : columns) {
            ColumnChunk columnChunk = new ColumnChunk(columnMetaData.getFirstDataPageOffset());
            columnChunk.file_path = block.getPath();
            columnChunk.meta_data = new ColumnMetaData(this.getType(columnMetaData.getType()), this.toFormatEncodings(columnMetaData.getEncodings()), Arrays.asList(columnMetaData.getPath().toArray()), this.toFormatCodec(columnMetaData.getCodec()), columnMetaData.getValueCount(), columnMetaData.getTotalUncompressedSize(), columnMetaData.getTotalSize(), columnMetaData.getFirstDataPageOffset());
            columnChunk.meta_data.dictionary_page_offset = columnMetaData.getDictionaryPageOffset();
            if (!columnMetaData.getStatistics().isEmpty()) {
                columnChunk.meta_data.setStatistics(ParquetMetadataConverter.toParquetStatistics(columnMetaData.getStatistics()));
            }
            if (columnMetaData.getEncodingStats() != null) {
                columnChunk.meta_data.setEncoding_stats(this.convertEncodingStats(columnMetaData.getEncodingStats()));
            }
            parquetColumns.add(columnChunk);
        }
        RowGroup rowGroup = new RowGroup(parquetColumns, block.getTotalByteSize(), block.getRowCount());
        rowGroups.add(rowGroup);
    }

    private List<Encoding> toFormatEncodings(Set<org.apache.parquet.column.Encoding> encodings) {
        ArrayList<Encoding> converted = new ArrayList<Encoding>(encodings.size());
        for (org.apache.parquet.column.Encoding encoding : encodings) {
            converted.add(this.getEncoding(encoding));
        }
        return converted;
    }

    Set<org.apache.parquet.column.Encoding> fromFormatEncodings(List<Encoding> encodings) {
        Set<org.apache.parquet.column.Encoding> converted = new HashSet();
        for (Encoding encoding : encodings) {
            converted.add(this.getEncoding(encoding));
        }
        Set<org.apache.parquet.column.Encoding> cached = cachedEncodingSets.putIfAbsent(converted = Collections.unmodifiableSet(converted), converted);
        if (cached == null) {
            cached = converted;
        }
        return cached;
    }

    private CompressionCodecName fromFormatCodec(CompressionCodec codec) {
        return CompressionCodecName.valueOf(codec.toString());
    }

    private CompressionCodec toFormatCodec(CompressionCodecName codec) {
        return CompressionCodec.valueOf(codec.toString());
    }

    public org.apache.parquet.column.Encoding getEncoding(Encoding encoding) {
        return org.apache.parquet.column.Encoding.valueOf(encoding.name());
    }

    public Encoding getEncoding(org.apache.parquet.column.Encoding encoding) {
        return Encoding.valueOf(encoding.name());
    }

    public EncodingStats convertEncodingStats(List<PageEncodingStats> stats) {
        if (stats == null) {
            return null;
        }
        EncodingStats.Builder builder = new EncodingStats.Builder();
        for (PageEncodingStats stat : stats) {
            switch (stat.getPage_type()) {
                case DATA_PAGE_V2: {
                    builder.withV2Pages();
                }
                case DATA_PAGE: {
                    builder.addDataEncoding(this.getEncoding(stat.getEncoding()), stat.getCount());
                    break;
                }
                case DICTIONARY_PAGE: {
                    builder.addDictEncoding(this.getEncoding(stat.getEncoding()), stat.getCount());
                }
            }
        }
        return builder.build();
    }

    public List<PageEncodingStats> convertEncodingStats(EncodingStats stats) {
        if (stats == null) {
            return null;
        }
        ArrayList<PageEncodingStats> formatStats = new ArrayList<PageEncodingStats>();
        for (org.apache.parquet.column.Encoding encoding : stats.getDictionaryEncodings()) {
            formatStats.add(new PageEncodingStats(PageType.DICTIONARY_PAGE, this.getEncoding(encoding), stats.getNumDictionaryPagesEncodedAs(encoding)));
        }
        PageType dataPageType = stats.usesV2Pages() ? PageType.DATA_PAGE_V2 : PageType.DATA_PAGE;
        for (org.apache.parquet.column.Encoding encoding : stats.getDataEncodings()) {
            formatStats.add(new PageEncodingStats(dataPageType, this.getEncoding(encoding), stats.getNumDataPagesEncodedAs(encoding)));
        }
        return formatStats;
    }

    public static Statistics toParquetStatistics(org.apache.parquet.column.statistics.Statistics stats) {
        Statistics formatStats = new Statistics();
        if (!stats.isEmpty() && stats.isSmallerThan(4096L)) {
            formatStats.setNull_count(stats.getNumNulls());
            if (stats.hasNonNullValue()) {
                byte[] min = stats.getMinBytes();
                byte[] max = stats.getMaxBytes();
                if (ParquetMetadataConverter.sortOrder(stats.type()) == SortOrder.SIGNED || Arrays.equals(min, max)) {
                    formatStats.setMin(min);
                    formatStats.setMax(max);
                }
                if (ParquetMetadataConverter.isMinMaxStatsSupported(stats.type()) || Arrays.equals(min, max)) {
                    formatStats.setMin_value(min);
                    formatStats.setMax_value(max);
                }
            }
        }
        return formatStats;
    }

    private static boolean isMinMaxStatsSupported(PrimitiveType type) {
        return type.columnOrder().getColumnOrderName() == ColumnOrder.ColumnOrderName.TYPE_DEFINED_ORDER;
    }

    @Deprecated
    public static org.apache.parquet.column.statistics.Statistics fromParquetStatistics(Statistics statistics, PrimitiveType.PrimitiveTypeName type) {
        return ParquetMetadataConverter.fromParquetStatistics(null, statistics, type);
    }

    @Deprecated
    public static org.apache.parquet.column.statistics.Statistics fromParquetStatistics(String createdBy, Statistics statistics, PrimitiveType.PrimitiveTypeName type) {
        return ParquetMetadataConverter.fromParquetStatisticsInternal(createdBy, statistics, new PrimitiveType(Type.Repetition.OPTIONAL, type, "fake_type"), ParquetMetadataConverter.defaultSortOrder(type));
    }

    static org.apache.parquet.column.statistics.Statistics fromParquetStatisticsInternal(String createdBy, Statistics formatStats, PrimitiveType type, SortOrder typeSortOrder) {
        Statistics.Builder statsBuilder = org.apache.parquet.column.statistics.Statistics.getBuilderForReading(type);
        if (formatStats != null) {
            if (formatStats.isSetMin_value() && formatStats.isSetMax_value()) {
                byte[] min = formatStats.min_value.array();
                byte[] max = formatStats.max_value.array();
                if (ParquetMetadataConverter.isMinMaxStatsSupported(type) || Arrays.equals(min, max)) {
                    statsBuilder.withMin(min);
                    statsBuilder.withMax(max);
                }
                if (formatStats.isSetNull_count()) {
                    statsBuilder.withNumNulls(formatStats.null_count);
                }
            } else {
                boolean sortOrdersMatch;
                boolean isSet = formatStats.isSetMax() && formatStats.isSetMin();
                boolean maxEqualsMin = isSet ? Arrays.equals(formatStats.getMin(), formatStats.getMax()) : false;
                boolean bl = sortOrdersMatch = SortOrder.SIGNED == typeSortOrder;
                if (!CorruptStatistics.shouldIgnoreStatistics(createdBy, type.getPrimitiveTypeName()) && (sortOrdersMatch || maxEqualsMin)) {
                    if (isSet) {
                        statsBuilder.withMin(formatStats.min.array());
                        statsBuilder.withMax(formatStats.max.array());
                    }
                    if (formatStats.isSetNull_count()) {
                        statsBuilder.withNumNulls(formatStats.null_count);
                    }
                }
            }
        }
        return statsBuilder.build();
    }

    public org.apache.parquet.column.statistics.Statistics fromParquetStatistics(String createdBy, Statistics statistics, PrimitiveType type) {
        SortOrder expectedOrder = this.overrideSortOrderToSigned(type) ? SortOrder.SIGNED : ParquetMetadataConverter.sortOrder(type);
        return ParquetMetadataConverter.fromParquetStatisticsInternal(createdBy, statistics, type, expectedOrder);
    }

    private boolean overrideSortOrderToSigned(PrimitiveType type) {
        OriginalType annotation = type.getOriginalType();
        return this.useSignedStringMinMax && PrimitiveType.PrimitiveTypeName.BINARY == type.getPrimitiveTypeName() && (annotation == null || STRING_TYPES.contains((Object)annotation));
    }

    private static SortOrder defaultSortOrder(PrimitiveType.PrimitiveTypeName primitive) {
        switch (primitive) {
            case BOOLEAN: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: {
                return SortOrder.SIGNED;
            }
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                return SortOrder.UNSIGNED;
            }
        }
        return SortOrder.UNKNOWN;
    }

    private static SortOrder sortOrder(PrimitiveType primitive) {
        OriginalType annotation = primitive.getOriginalType();
        if (annotation != null) {
            switch (annotation) {
                case INT_8: 
                case INT_16: 
                case INT_32: 
                case INT_64: 
                case DATE: 
                case TIME_MICROS: 
                case TIME_MILLIS: 
                case TIMESTAMP_MICROS: 
                case TIMESTAMP_MILLIS: {
                    return SortOrder.SIGNED;
                }
                case UINT_8: 
                case UINT_16: 
                case UINT_32: 
                case UINT_64: 
                case ENUM: 
                case UTF8: 
                case BSON: 
                case JSON: {
                    return SortOrder.UNSIGNED;
                }
                case DECIMAL: 
                case LIST: 
                case MAP: 
                case MAP_KEY_VALUE: 
                case INTERVAL: {
                    return SortOrder.UNKNOWN;
                }
            }
        }
        return ParquetMetadataConverter.defaultSortOrder(primitive.getPrimitiveTypeName());
    }

    public PrimitiveType.PrimitiveTypeName getPrimitive(Type type) {
        switch (type) {
            case BYTE_ARRAY: {
                return PrimitiveType.PrimitiveTypeName.BINARY;
            }
            case INT64: {
                return PrimitiveType.PrimitiveTypeName.INT64;
            }
            case INT32: {
                return PrimitiveType.PrimitiveTypeName.INT32;
            }
            case BOOLEAN: {
                return PrimitiveType.PrimitiveTypeName.BOOLEAN;
            }
            case FLOAT: {
                return PrimitiveType.PrimitiveTypeName.FLOAT;
            }
            case DOUBLE: {
                return PrimitiveType.PrimitiveTypeName.DOUBLE;
            }
            case INT96: {
                return PrimitiveType.PrimitiveTypeName.INT96;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY;
            }
        }
        throw new RuntimeException("Unknown type " + type);
    }

    Type getType(PrimitiveType.PrimitiveTypeName type) {
        switch (type) {
            case INT64: {
                return Type.INT64;
            }
            case INT32: {
                return Type.INT32;
            }
            case BOOLEAN: {
                return Type.BOOLEAN;
            }
            case BINARY: {
                return Type.BYTE_ARRAY;
            }
            case FLOAT: {
                return Type.FLOAT;
            }
            case DOUBLE: {
                return Type.DOUBLE;
            }
            case INT96: {
                return Type.INT96;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return Type.FIXED_LEN_BYTE_ARRAY;
            }
        }
        throw new RuntimeException("Unknown primitive type " + (Object)((Object)type));
    }

    OriginalType getOriginalType(ConvertedType type) {
        switch (type) {
            case UTF8: {
                return OriginalType.UTF8;
            }
            case MAP: {
                return OriginalType.MAP;
            }
            case MAP_KEY_VALUE: {
                return OriginalType.MAP_KEY_VALUE;
            }
            case LIST: {
                return OriginalType.LIST;
            }
            case ENUM: {
                return OriginalType.ENUM;
            }
            case DECIMAL: {
                return OriginalType.DECIMAL;
            }
            case DATE: {
                return OriginalType.DATE;
            }
            case TIME_MILLIS: {
                return OriginalType.TIME_MILLIS;
            }
            case TIME_MICROS: {
                return OriginalType.TIME_MICROS;
            }
            case TIMESTAMP_MILLIS: {
                return OriginalType.TIMESTAMP_MILLIS;
            }
            case TIMESTAMP_MICROS: {
                return OriginalType.TIMESTAMP_MICROS;
            }
            case INTERVAL: {
                return OriginalType.INTERVAL;
            }
            case INT_8: {
                return OriginalType.INT_8;
            }
            case INT_16: {
                return OriginalType.INT_16;
            }
            case INT_32: {
                return OriginalType.INT_32;
            }
            case INT_64: {
                return OriginalType.INT_64;
            }
            case UINT_8: {
                return OriginalType.UINT_8;
            }
            case UINT_16: {
                return OriginalType.UINT_16;
            }
            case UINT_32: {
                return OriginalType.UINT_32;
            }
            case UINT_64: {
                return OriginalType.UINT_64;
            }
            case JSON: {
                return OriginalType.JSON;
            }
            case BSON: {
                return OriginalType.BSON;
            }
        }
        throw new RuntimeException("Unknown converted type " + type);
    }

    ConvertedType getConvertedType(OriginalType type) {
        switch (type) {
            case UTF8: {
                return ConvertedType.UTF8;
            }
            case MAP: {
                return ConvertedType.MAP;
            }
            case MAP_KEY_VALUE: {
                return ConvertedType.MAP_KEY_VALUE;
            }
            case LIST: {
                return ConvertedType.LIST;
            }
            case ENUM: {
                return ConvertedType.ENUM;
            }
            case DECIMAL: {
                return ConvertedType.DECIMAL;
            }
            case DATE: {
                return ConvertedType.DATE;
            }
            case TIME_MILLIS: {
                return ConvertedType.TIME_MILLIS;
            }
            case TIME_MICROS: {
                return ConvertedType.TIME_MICROS;
            }
            case TIMESTAMP_MILLIS: {
                return ConvertedType.TIMESTAMP_MILLIS;
            }
            case TIMESTAMP_MICROS: {
                return ConvertedType.TIMESTAMP_MICROS;
            }
            case INTERVAL: {
                return ConvertedType.INTERVAL;
            }
            case INT_8: {
                return ConvertedType.INT_8;
            }
            case INT_16: {
                return ConvertedType.INT_16;
            }
            case INT_32: {
                return ConvertedType.INT_32;
            }
            case INT_64: {
                return ConvertedType.INT_64;
            }
            case UINT_8: {
                return ConvertedType.UINT_8;
            }
            case UINT_16: {
                return ConvertedType.UINT_16;
            }
            case UINT_32: {
                return ConvertedType.UINT_32;
            }
            case UINT_64: {
                return ConvertedType.UINT_64;
            }
            case JSON: {
                return ConvertedType.JSON;
            }
            case BSON: {
                return ConvertedType.BSON;
            }
        }
        throw new RuntimeException("Unknown original type " + (Object)((Object)type));
    }

    private static void addKeyValue(FileMetaData fileMetaData, String key, String value) {
        KeyValue keyValue = new KeyValue(key);
        keyValue.value = value;
        fileMetaData.addToKey_value_metadata(keyValue);
    }

    public static MetadataFilter range(long startOffset, long endOffset) {
        return new RangeMetadataFilter(startOffset, endOffset);
    }

    public static MetadataFilter offsets(long ... offsets) {
        HashSet<Long> set = new HashSet<Long>();
        for (long offset : offsets) {
            set.add(offset);
        }
        return new OffsetMetadataFilter(set);
    }

    @Deprecated
    public ParquetMetadata readParquetMetadata(InputStream from) throws IOException {
        return this.readParquetMetadata(from, NO_FILTER);
    }

    static FileMetaData filterFileMetaDataByMidpoint(FileMetaData metaData, RangeMetadataFilter filter) {
        List<RowGroup> rowGroups = metaData.getRow_groups();
        ArrayList<RowGroup> newRowGroups = new ArrayList<RowGroup>();
        for (RowGroup rowGroup : rowGroups) {
            long totalSize = 0L;
            long startIndex = ParquetMetadataConverter.getOffset(rowGroup.getColumns().get(0));
            for (ColumnChunk col : rowGroup.getColumns()) {
                totalSize += col.getMeta_data().getTotal_compressed_size();
            }
            long midPoint = startIndex + totalSize / 2L;
            if (!filter.contains(midPoint)) continue;
            newRowGroups.add(rowGroup);
        }
        metaData.setRow_groups(newRowGroups);
        return metaData;
    }

    static FileMetaData filterFileMetaDataByStart(FileMetaData metaData, OffsetMetadataFilter filter) {
        List<RowGroup> rowGroups = metaData.getRow_groups();
        ArrayList<RowGroup> newRowGroups = new ArrayList<RowGroup>();
        for (RowGroup rowGroup : rowGroups) {
            long startIndex = ParquetMetadataConverter.getOffset(rowGroup.getColumns().get(0));
            if (!filter.contains(startIndex)) continue;
            newRowGroups.add(rowGroup);
        }
        metaData.setRow_groups(newRowGroups);
        return metaData;
    }

    static long getOffset(RowGroup rowGroup) {
        return ParquetMetadataConverter.getOffset(rowGroup.getColumns().get(0));
    }

    static long getOffset(ColumnChunk columnChunk) {
        ColumnMetaData md = columnChunk.getMeta_data();
        long offset = md.getData_page_offset();
        if (md.isSetDictionary_page_offset() && offset > md.getDictionary_page_offset()) {
            offset = md.getDictionary_page_offset();
        }
        return offset;
    }

    public ParquetMetadata readParquetMetadata(final InputStream from, MetadataFilter filter) throws IOException {
        FileMetaData fileMetaData = filter.accept(new MetadataFilterVisitor<FileMetaData, IOException>(){

            @Override
            public FileMetaData visit(NoFilter filter) throws IOException {
                return Util.readFileMetaData(from);
            }

            @Override
            public FileMetaData visit(SkipMetadataFilter filter) throws IOException {
                return Util.readFileMetaData(from, true);
            }

            @Override
            public FileMetaData visit(OffsetMetadataFilter filter) throws IOException {
                return ParquetMetadataConverter.filterFileMetaDataByStart(Util.readFileMetaData(from), filter);
            }

            @Override
            public FileMetaData visit(RangeMetadataFilter filter) throws IOException {
                return ParquetMetadataConverter.filterFileMetaDataByMidpoint(Util.readFileMetaData(from), filter);
            }
        });
        LOG.debug("{}", (Object)fileMetaData);
        ParquetMetadata parquetMetadata = this.fromParquetMetadata(fileMetaData);
        if (LOG.isDebugEnabled()) {
            LOG.debug(ParquetMetadata.toPrettyJSON(parquetMetadata));
        }
        return parquetMetadata;
    }

    public ParquetMetadata fromParquetMetadata(FileMetaData parquetMetadata) throws IOException {
        MessageType messageType = this.fromParquetSchema(parquetMetadata.getSchema(), parquetMetadata.getColumn_orders());
        ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
        List<RowGroup> row_groups = parquetMetadata.getRow_groups();
        if (row_groups != null) {
            for (RowGroup rowGroup : row_groups) {
                BlockMetaData blockMetaData = new BlockMetaData();
                blockMetaData.setRowCount(rowGroup.getNum_rows());
                blockMetaData.setTotalByteSize(rowGroup.getTotal_byte_size());
                List<ColumnChunk> columns = rowGroup.getColumns();
                String filePath = columns.get(0).getFile_path();
                for (ColumnChunk columnChunk : columns) {
                    if (filePath == null && columnChunk.getFile_path() != null || filePath != null && !filePath.equals(columnChunk.getFile_path())) {
                        throw new ParquetDecodingException("all column chunks of the same row group must be in the same file for now");
                    }
                    ColumnMetaData metaData = columnChunk.meta_data;
                    ColumnPath path = ParquetMetadataConverter.getPath(metaData);
                    ColumnChunkMetaData column = ColumnChunkMetaData.get(path, messageType.getType(path.toArray()).asPrimitiveType(), this.fromFormatCodec(metaData.codec), this.convertEncodingStats(metaData.getEncoding_stats()), this.fromFormatEncodings(metaData.encodings), this.fromParquetStatistics(parquetMetadata.getCreated_by(), metaData.statistics, messageType.getType(path.toArray()).asPrimitiveType()), metaData.data_page_offset, metaData.dictionary_page_offset, metaData.num_values, metaData.total_compressed_size, metaData.total_uncompressed_size);
                    blockMetaData.addColumn(column);
                }
                blockMetaData.setPath(filePath);
                blocks.add(blockMetaData);
            }
        }
        HashMap<String, String> keyValueMetaData = new HashMap<String, String>();
        List<KeyValue> key_value_metadata = parquetMetadata.getKey_value_metadata();
        if (key_value_metadata != null) {
            for (KeyValue keyValue : key_value_metadata) {
                keyValueMetaData.put(keyValue.key, keyValue.value);
            }
        }
        return new ParquetMetadata(new org.apache.parquet.hadoop.metadata.FileMetaData(messageType, keyValueMetaData, parquetMetadata.getCreated_by()), blocks);
    }

    private static ColumnPath getPath(ColumnMetaData metaData) {
        String[] path = metaData.path_in_schema.toArray(new String[metaData.path_in_schema.size()]);
        return ColumnPath.get(path);
    }

    MessageType fromParquetSchema(List<SchemaElement> schema, List<ColumnOrder> columnOrders) {
        Iterator<SchemaElement> iterator = schema.iterator();
        SchemaElement root = iterator.next();
        Types.MessageTypeBuilder builder = Types.buildMessage();
        if (root.isSetField_id()) {
            builder.id(root.field_id);
        }
        this.buildChildren(builder, iterator, root.getNum_children(), columnOrders, 0);
        return builder.named(root.name);
    }

    private void buildChildren(Types.GroupBuilder builder, Iterator<SchemaElement> schema, int childrenCount, List<ColumnOrder> columnOrders, int columnCount) {
        for (int i = 0; i < childrenCount; ++i) {
            Types.Builder childBuilder;
            SchemaElement schemaElement = schema.next();
            if (schemaElement.type != null) {
                Types.PrimitiveBuilder primitiveBuilder = builder.primitive(this.getPrimitive(schemaElement.type), this.fromParquetRepetition(schemaElement.repetition_type));
                if (schemaElement.isSetType_length()) {
                    primitiveBuilder.length(schemaElement.type_length);
                }
                if (schemaElement.isSetPrecision()) {
                    primitiveBuilder.precision(schemaElement.precision);
                }
                if (schemaElement.isSetScale()) {
                    primitiveBuilder.scale(schemaElement.scale);
                }
                if (columnOrders != null) {
                    org.apache.parquet.schema.ColumnOrder columnOrder = ParquetMetadataConverter.fromParquetColumnOrder(columnOrders.get(columnCount));
                    if (columnOrder.getColumnOrderName() == ColumnOrder.ColumnOrderName.TYPE_DEFINED_ORDER && (schemaElement.type == Type.INT96 || schemaElement.converted_type == ConvertedType.INTERVAL)) {
                        columnOrder = org.apache.parquet.schema.ColumnOrder.undefined();
                    }
                    primitiveBuilder.columnOrder(columnOrder);
                }
                childBuilder = primitiveBuilder;
            } else {
                childBuilder = builder.group(this.fromParquetRepetition(schemaElement.repetition_type));
                this.buildChildren((Types.GroupBuilder)childBuilder, schema, schemaElement.num_children, columnOrders, columnCount);
            }
            if (schemaElement.isSetConverted_type()) {
                childBuilder.as(this.getOriginalType(schemaElement.converted_type));
            }
            if (schemaElement.isSetField_id()) {
                childBuilder.id(schemaElement.field_id);
            }
            childBuilder.named(schemaElement.name);
            ++columnCount;
        }
    }

    FieldRepetitionType toParquetRepetition(Type.Repetition repetition) {
        return FieldRepetitionType.valueOf(repetition.name());
    }

    Type.Repetition fromParquetRepetition(FieldRepetitionType repetition) {
        return Type.Repetition.valueOf(repetition.name());
    }

    private static org.apache.parquet.schema.ColumnOrder fromParquetColumnOrder(ColumnOrder columnOrder) {
        if (columnOrder.isSetTYPE_ORDER()) {
            return org.apache.parquet.schema.ColumnOrder.typeDefined();
        }
        return org.apache.parquet.schema.ColumnOrder.undefined();
    }

    @Deprecated
    public void writeDataPageHeader(int uncompressedSize, int compressedSize, int valueCount, org.apache.parquet.column.Encoding rlEncoding, org.apache.parquet.column.Encoding dlEncoding, org.apache.parquet.column.Encoding valuesEncoding, OutputStream to) throws IOException {
        Util.writePageHeader(this.newDataPageHeader(uncompressedSize, compressedSize, valueCount, new BooleanStatistics(), rlEncoding, dlEncoding, valuesEncoding), to);
    }

    public void writeDataPageHeader(int uncompressedSize, int compressedSize, int valueCount, org.apache.parquet.column.statistics.Statistics statistics, org.apache.parquet.column.Encoding rlEncoding, org.apache.parquet.column.Encoding dlEncoding, org.apache.parquet.column.Encoding valuesEncoding, OutputStream to) throws IOException {
        Util.writePageHeader(this.newDataPageHeader(uncompressedSize, compressedSize, valueCount, statistics, rlEncoding, dlEncoding, valuesEncoding), to);
    }

    private PageHeader newDataPageHeader(int uncompressedSize, int compressedSize, int valueCount, org.apache.parquet.column.statistics.Statistics statistics, org.apache.parquet.column.Encoding rlEncoding, org.apache.parquet.column.Encoding dlEncoding, org.apache.parquet.column.Encoding valuesEncoding) {
        PageHeader pageHeader = new PageHeader(PageType.DATA_PAGE, uncompressedSize, compressedSize);
        pageHeader.setData_page_header(new DataPageHeader(valueCount, this.getEncoding(valuesEncoding), this.getEncoding(dlEncoding), this.getEncoding(rlEncoding)));
        if (!statistics.isEmpty()) {
            pageHeader.getData_page_header().setStatistics(ParquetMetadataConverter.toParquetStatistics(statistics));
        }
        return pageHeader;
    }

    public void writeDataPageV2Header(int uncompressedSize, int compressedSize, int valueCount, int nullCount, int rowCount, org.apache.parquet.column.statistics.Statistics statistics, org.apache.parquet.column.Encoding dataEncoding, int rlByteLength, int dlByteLength, OutputStream to) throws IOException {
        Util.writePageHeader(this.newDataPageV2Header(uncompressedSize, compressedSize, valueCount, nullCount, rowCount, statistics, dataEncoding, rlByteLength, dlByteLength), to);
    }

    private PageHeader newDataPageV2Header(int uncompressedSize, int compressedSize, int valueCount, int nullCount, int rowCount, org.apache.parquet.column.statistics.Statistics<?> statistics, org.apache.parquet.column.Encoding dataEncoding, int rlByteLength, int dlByteLength) {
        DataPageHeaderV2 dataPageHeaderV2 = new DataPageHeaderV2(valueCount, nullCount, rowCount, this.getEncoding(dataEncoding), dlByteLength, rlByteLength);
        if (!statistics.isEmpty()) {
            dataPageHeaderV2.setStatistics(ParquetMetadataConverter.toParquetStatistics(statistics));
        }
        PageHeader pageHeader = new PageHeader(PageType.DATA_PAGE_V2, uncompressedSize, compressedSize);
        pageHeader.setData_page_header_v2(dataPageHeaderV2);
        return pageHeader;
    }

    public void writeDictionaryPageHeader(int uncompressedSize, int compressedSize, int valueCount, org.apache.parquet.column.Encoding valuesEncoding, OutputStream to) throws IOException {
        PageHeader pageHeader = new PageHeader(PageType.DICTIONARY_PAGE, uncompressedSize, compressedSize);
        pageHeader.setDictionary_page_header(new DictionaryPageHeader(valueCount, this.getEncoding(valuesEncoding)));
        Util.writePageHeader(pageHeader, to);
    }

    static final class OffsetMetadataFilter
    extends MetadataFilter {
        private final Set<Long> offsets;

        public OffsetMetadataFilter(Set<Long> offsets) {
            this.offsets = offsets;
        }

        public boolean contains(long offset) {
            return this.offsets.contains(offset);
        }

        @Override
        <T, E extends Throwable> T accept(MetadataFilterVisitor<T, E> visitor) throws E {
            return visitor.visit(this);
        }
    }

    static final class RangeMetadataFilter
    extends MetadataFilter {
        final long startOffset;
        final long endOffset;

        RangeMetadataFilter(long startOffset, long endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        @Override
        <T, E extends Throwable> T accept(MetadataFilterVisitor<T, E> visitor) throws E {
            return visitor.visit(this);
        }

        public boolean contains(long offset) {
            return offset >= this.startOffset && offset < this.endOffset;
        }

        public String toString() {
            return "range(s:" + this.startOffset + ", e:" + this.endOffset + ")";
        }
    }

    private static final class SkipMetadataFilter
    extends MetadataFilter {
        private SkipMetadataFilter() {
        }

        @Override
        <T, E extends Throwable> T accept(MetadataFilterVisitor<T, E> visitor) throws E {
            return visitor.visit(this);
        }

        public String toString() {
            return "SKIP_ROW_GROUPS";
        }
    }

    private static final class NoFilter
    extends MetadataFilter {
        private NoFilter() {
        }

        @Override
        <T, E extends Throwable> T accept(MetadataFilterVisitor<T, E> visitor) throws E {
            return visitor.visit(this);
        }

        public String toString() {
            return "NO_FILTER";
        }
    }

    public static abstract class MetadataFilter {
        private MetadataFilter() {
        }

        abstract <T, E extends Throwable> T accept(MetadataFilterVisitor<T, E> var1) throws E;
    }

    private static interface MetadataFilterVisitor<T, E extends Throwable> {
        public T visit(NoFilter var1) throws E;

        public T visit(SkipMetadataFilter var1) throws E;

        public T visit(RangeMetadataFilter var1) throws E;

        public T visit(OffsetMetadataFilter var1) throws E;
    }

    static enum SortOrder {
        SIGNED,
        UNSIGNED,
        UNKNOWN;

    }
}

