/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.orc;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.prestosql.orc.DiskRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public final class OrcDataSourceUtils {
    private OrcDataSourceUtils() {
    }

    public static List<DiskRange> mergeAdjacentDiskRanges(Collection<DiskRange> diskRanges, DataSize maxMergeDistance, DataSize maxReadSize) {
        ArrayList<DiskRange> ranges = new ArrayList<DiskRange>(diskRanges);
        ranges.sort(Comparator.comparingLong(DiskRange::getOffset));
        long maxReadSizeBytes = maxReadSize.toBytes();
        long maxMergeDistanceBytes = maxMergeDistance.toBytes();
        ImmutableList.Builder result = ImmutableList.builder();
        DiskRange last = (DiskRange)ranges.get(0);
        for (int i = 1; i < ranges.size(); ++i) {
            DiskRange current = (DiskRange)ranges.get(i);
            DiskRange merged = last.span(current);
            if ((long)merged.getLength() <= maxReadSizeBytes && last.getEnd() + maxMergeDistanceBytes >= current.getOffset()) {
                last = merged;
                continue;
            }
            result.add((Object)last);
            last = current;
        }
        result.add((Object)last);
        return result.build();
    }

    public static Slice getDiskRangeSlice(DiskRange diskRange, Map<DiskRange, byte[]> buffers) {
        for (Map.Entry<DiskRange, byte[]> bufferEntry : buffers.entrySet()) {
            DiskRange bufferRange = bufferEntry.getKey();
            byte[] buffer = bufferEntry.getValue();
            if (!bufferRange.contains(diskRange)) continue;
            int offset = Math.toIntExact(diskRange.getOffset() - bufferRange.getOffset());
            return Slices.wrappedBuffer((byte[])buffer, (int)offset, (int)diskRange.getLength());
        }
        throw new IllegalStateException("No matching buffer for disk range");
    }
}

